/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.tcp;

import java.io.File;
import java.util.ArrayList;
import lombok.Generated;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.json.JSONObject;
import org.junit.Test;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.FakeCamera;
import se.prediktera.breeze.hardware.runtime.BreezeRuntimeConnection;
import se.prediktera.breeze.hardware.tcp.BreezeRuntime;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.test.MockBreezeTestProperties;
import se.prediktera.breeze.util.JSONObjectWith;
import se.prediktera.map.common.update.UpdateHelper;

public class TcpManagerTest
extends MockBreezeTestProperties {
    @Test
    public void itShouldForwardMissingPixelsFilePathOnRedEyeInitialize() {
        FakeRuntime fakeRuntime = new FakeRuntime(new JSONObjectWith("Message", "{'Id':'1'}", "Success", true));
        ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
        arrayList.add(new Command.Argument("MissingPixelsFilePath", (Object)"C:\\somefile.txt"));
        new TcpManager(fakeRuntime).initializeCamera(BreezeProgressManager.createEmpty(), new FakeCamera("InnoSpecCamera"), CameraType.fromXml("RedEye"), arrayList, () -> {});
        MatcherAssert.assertThat((Object)fakeRuntime.getLastSendCommand(), (Matcher)CoreMatchers.is((Object)new Command("InitializeCamera", new Command.Argument("DeviceName", (Object)"InnoSpecCamera"), new Command.Argument("CameraId", (Object)0), new Command.Argument("CameraType", (Object)"RedEye"), new Command.Argument("RequestedPort", (Object)BreezeProperties.getInstance().getDataStreamPort()), new Command.Argument("MissingPixelsFilePath", (Object)"C:\\somefile.txt"))));
    }

    @Test
    public void itShouldNotForwardMissingPixelsFilePathOnRedEyeInitializeIfPathIsNull() {
        FakeRuntime fakeRuntime = new FakeRuntime(new JSONObjectWith("Message", "{'Id':'1'}", "Success", true));
        ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
        new TcpManager(fakeRuntime).initializeCamera(BreezeProgressManager.createEmpty(), new FakeCamera("InnoSpecCamera"), CameraType.fromXml("RedEye"), arrayList, () -> {});
        MatcherAssert.assertThat((Object)fakeRuntime.getLastSendCommand(), (Matcher)CoreMatchers.is((Object)new Command("InitializeCamera", new Command.Argument("DeviceName", (Object)"InnoSpecCamera"), new Command.Argument("CameraId", (Object)0), new Command.Argument("CameraType", (Object)"RedEye"), new Command.Argument("RequestedPort", (Object)BreezeProperties.getInstance().getDataStreamPort()))));
    }

    @Test
    public void itReturnsCameraPropertyOnCameraPropertyCommand() {
        FakeRuntime fakeRuntime = new FakeRuntime(new JSONObjectWith("Message", "testreturnvalue", "Success", true));
        String string = new TcpManager(this, fakeRuntime){

            @Override
            public Time getDefaultTimeout() {
                return new Time.Minutes(10.0);
            }
        }.getCameraProperty(new FakeCamera(), "TestProperty");
        MatcherAssert.assertThat((Object)string, (Matcher)CoreMatchers.is((Object)"testreturnvalue"));
    }

    public static class FakeRuntime
    implements BreezeRuntime {
        private final ArrayList<String> lineQueue = new ArrayList();
        private final JSONObject returnValue;
        private Command lastSendCommand;

        public FakeRuntime(JSONObject jSONObject) {
            this.returnValue = jSONObject;
        }

        public FakeRuntime() {
            this(null);
        }

        @Override
        public void send(BreezeProgress breezeProgress, Command command) {
            this.lastSendCommand = command;
            this.returnValue.put("Id", (Object)this.lastSendCommand.getId());
            this.lineQueue.add(this.returnValue.toString());
        }

        @Override
        public String readCommandLine() {
            ThreadUtil.awaitOrThrow(() -> !this.lineQueue.isEmpty(), Time.Second);
            return this.lineQueue.remove(0);
        }

        @Override
        public String readEventLine() throws BreezeRuntimeConnection.BreezeRuntimeDisconnectedException {
            return null;
        }

        @Override
        public boolean isAnyBreezeRuntimeRunning() {
            return false;
        }

        @Override
        public void closeServer() {
        }

        @Override
        public void startRuntime(BreezeProgress breezeProgress) {
        }

        @Override
        public UpdateHelper.UpdateVersion getVersion() {
            return null;
        }

        @Override
        public File getRuntimeBinaryFile() {
            return null;
        }

        @Generated
        public Command getLastSendCommand() {
            return this.lastSendCommand;
        }
    }
}

