/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.recorder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import se.prediktera.breeze.backend.measure.MeasurementTaker;
import se.prediktera.breeze.backend.measure.settings.ConveyorMeasureSettings;
import se.prediktera.breeze.backend.measure.settings.MeasureSettings;
import se.prediktera.breeze.backend.measure.settings.MoverMeasureSettings;
import se.prediktera.breeze.backend.measure.settings.ReferenceSettings;
import se.prediktera.breeze.backend.measure.settings.TrayMeasureSettings;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.hardware.settings.ByLengthMeasureLengthSettings;
import se.prediktera.breeze.common.hardware.settings.ByObjectMeasureLengthSettings;
import se.prediktera.breeze.common.hardware.settings.MeasureLengthSettings;
import se.prediktera.breeze.common.realtime.variable.RtBasicVariable;
import se.prediktera.breeze.common.realtime.variable.RtRenderModeVariable;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.entry.comment.Comment;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.client.select.active.ActiveRealtimePanel;
import se.prediktera.breeze.frontend.common.entry.EntryComponents;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryTabPanel;
import se.prediktera.breeze.frontend.common.entry.MainViewPanel;
import se.prediktera.breeze.frontend.common.entry.OpenEntryProgressAction;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTextArea;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.hardware.ConnectProgressAction;
import se.prediktera.breeze.frontend.main.WelcomePanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExploreInterface;
import se.prediktera.breeze.frontend.main.settings.SettingsPanel;
import se.prediktera.breeze.frontend.main.settings.focus.HardwareSidePanel;
import se.prediktera.breeze.frontend.main.settings.hardware.MultiCameraSettingsPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.PlaceSampleStep;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.recorder.GroupRecordMmtCreateAndSaveSettings;
import se.prediktera.breeze.recorder.RecordWizard;
import se.prediktera.breeze.recorder.RecorderHelper;
import se.prediktera.breeze.recorder.RecorderPlaySettings;
import se.prediktera.breeze.recorder.RecorderSettingsPanel;
import se.prediktera.breeze.recorder.RenderMode;
import se.prediktera.breeze.test.stubs.MeasurementWithoutIO;
import se.prediktera.map.common.SwingTimer;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.main.Project_GUI;

public class BreezeRecorder
extends BreezeMainPanel {
    private final EntryComponents.BackButton backButton;
    private BreezeRecorderViewPanel viewPanel;
    private Project_GUI evinceProject;
    private final Group group;
    private final ActionButtonPanel buttonPanel = new ActionButtonPanel();
    private final BreezeType type = BreezeType.Recorder;

    public BreezeRecorder(BreezeProgress breezeProgress, BreezeFrame breezeFrame, BreezeType breezeType, Group group, OnMeasurementCallback onMeasurementCallback) {
        super(breezeFrame);
        this.group = group;
        this.setLayout(new BorderLayout());
        this.setBackground(BreezeTheme.getInstance().getPanelBackground());
        EntryComponents.VerticalLabelPanel verticalLabelPanel = new EntryComponents.VerticalLabelPanel(this.buttonPanel);
        this.buttonPanel.setBackground(BreezeTheme.getInstance().getSettingPanelBackground());
        this.backButton = new EntryComponents.BackButton(this, () -> {
            this.viewPanel.pushCommentsToMeasurement();
            this.viewPanel.stopIfRunning();
            if (onMeasurementCallback != null) {
                onMeasurementCallback.onMeasurement(this.viewPanel.getMeasurement());
            }
            if (breezeProgress != null) {
                breezeFrame.removePage(this);
            } else {
                breezeFrame.exit();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        verticalLabelPanel.topPanel.add((Component)this.backButton, gridBagConstraints);
        verticalLabelPanel.setColorAndTitle(this.type.getColor(), "Recorder");
        verticalLabelPanel.labelPanel.setVisible(true);
        this.add((Component)verticalLabelPanel, "West");
        if (breezeProgress != null) {
            this.viewPanel = new BreezeRecorderViewPanel(breezeProgress, this, group);
            this.add((Component)new MainViewPanel(this.viewPanel), "Center");
        }
    }

    @Override
    public void showSelectedEntry(boolean bl) {
        if (bl) {
            BreezeProgressDialog.startProgress(this.frame, new ProgressAction(){

                @Override
                public void runAction() {
                    this.setInfoText("Opening Breeze Recorder");
                    BreezeRecorder.this.viewPanel = new BreezeRecorderViewPanel(this.getProgressManager(), BreezeRecorder.this, BreezeRecorder.this.group);
                    BreezeRecorder.this.add((Component)new MainViewPanel(BreezeRecorder.this.viewPanel), "Center");
                }
            }, "Opening...");
        } else {
            this.viewPanel.updateSettings();
        }
    }

    @Override
    public void setDirty(boolean bl) {
        Component component;
        if (bl && (component = this.frame.getViewStack().getVisiblePanel(PixelExploreInterface.PixelExploreDialogPanel.class)) instanceof PixelExploreInterface.PixelExploreDialogPanel) {
            PixelExploreInterface.PixelExploreDialogPanel pixelExploreDialogPanel = (PixelExploreInterface.PixelExploreDialogPanel)((Object)component);
            pixelExploreDialogPanel.reloadEntry();
        }
    }

    @Override
    public Project_GUI getOrCreateEvinceProject() {
        if (this.evinceProject == null) {
            this.evinceProject = EntryTabPanel.createEvinceProject("recorder", new VisualisationNode.ColorScale("jet"));
            return this.evinceProject;
        }
        return this.evinceProject;
    }

    public void closeEvinceProject() {
        if (this.evinceProject != null) {
            try {
                this.evinceProject.closeProjectNow();
            }
            catch (Exception exception) {
                Logg.error((String)"Error closing Evince project", (Throwable)exception);
            }
            this.evinceProject = null;
        }
    }

    @Override
    public BreezeType getPageType() {
        return BreezeType.Recorder;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.viewPanel.cleanUp();
        System.gc();
    }

    public BreezeButton createRecordButton(String string, String string2, EntryMainHelper.ClickCallBack clickCallBack) {
        return this.createRecordButton(string, string2, clickCallBack, this.type.getColor());
    }

    public BreezeButton createRecordButton(String string, String string2, EntryMainHelper.ClickCallBack clickCallBack, Color color) {
        return EntryMainHelper.createColorButton(string, string2, clickCallBack, color);
    }

    public void awaitOrThrow(MeasurementTaker.MeasurementStatus measurementStatus, Time time) {
        try {
            ThreadUtil.awaitOrThrow(() -> this.viewPanel.getStatus() == measurementStatus, time, "Timeout waiting for " + String.valueOf((Object)measurementStatus));
        }
        catch (ThreadUtil.TimeoutException timeoutException) {
            throw new ThreadUtil.TimeoutException(timeoutException.getMessage() + ", state: " + String.valueOf((Object)this.viewPanel.getStatus()));
        }
    }

    public int getCurrentFrameCount() {
        return this.viewPanel.getCurrentFrameCount();
    }

    public RecordMode getMode() {
        return this.viewPanel.recordMode;
    }

    @Generated
    public EntryComponents.BackButton getBackButton() {
        return this.backButton;
    }

    public static class ActionButtonPanel
    extends JPanel {
        public ActionButtonPanel() {
            super(new GridBagLayout());
            this.setBackground(BreezeTheme.getInstance().getSettingPanelBackground());
        }

        public void addComponent(JComponent jComponent) {
            this.addComponent(jComponent, 0);
        }

        public void addComponent(JComponent jComponent, int n) {
            this.addComponent(jComponent, this.getComponentCount(), n);
        }

        public void addComponent(JComponent jComponent, int n, int n2) {
            this.addComponent(jComponent, n, 5, n2);
        }

        public void addComponentInsets(JComponent jComponent, int n, int n2) {
            this.addComponent(jComponent, this.getComponentCount(), n, n2);
        }

        public void addComponent(JComponent jComponent, int n, int n2, int n3) {
            this.add((Component)jComponent, GridBagHelper.create(n, new Insets(n2, 2, n3, 2)));
        }

        public void addComponentLast(JComponent jComponent) {
            this.addComponentLast(jComponent, this.getComponentCount());
        }

        public void addComponentLast(JComponent jComponent, int n) {
            GridBagConstraints gridBagConstraints = GridBagHelper.createLast(n, new Insets(5, 2, 10, 2));
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 15;
            this.add((Component)jComponent, gridBagConstraints);
        }
    }

    public static interface OnMeasurementCallback {
        public void onMeasurement(Measurement var1);
    }

    public class BreezeRecorderViewPanel
    extends AbstractViewPanel
    implements PlaceSampleStep.MeasurementInfoInterface {
        @Generated
        private final Object $lock;
        public final BreezeInputField nameInputField;
        private final List<BreezeInputField> loggingFields;
        private final BreezeButton recordButton;
        private final BreezeButton stopButton;
        private final BreezeButton deleteButton;
        private final BreezeButton addButton;
        private final BreezeButton settingsButton;
        private final BreezeButton editButton;
        private final BreezeButton finishButton;
        private final MultiCameraSettingsPanel.MultiModeInputField modeInputField;
        private MeasureSettings measureSettings;
        private MeasurementTaker measurementTaker;
        public final HardwareSidePanel hardwareSidePanel;
        private final Group group;
        private final List<Measurement> measurements;
        public final BreezeTextArea commentTextArea;
        private final CollapsePanel commentCollapsePanel;
        private RtBasicVariable currentVariable;
        private RecordMode recordMode;
        private ActiveRealtimePanel.ActiveTablePanel activeTablePanel;
        private final SwingTimer refreshTimer;
        private RecorderHelper.ReferenceSectionPanel referenceSection;

        public BreezeRecorderViewPanel(BreezeProgress breezeProgress, BreezeRecorder breezeRecorder2, Group group) {
            super(breezeRecorder2);
            this.$lock = new Object[0];
            this.nameInputField = new BreezeInputField("Name", "", "");
            this.loggingFields = new ArrayList<BreezeInputField>();
            this.measurements = new ArrayList<Measurement>();
            this.commentTextArea = new BreezeTextArea(0, false);
            this.refreshTimer = new SwingTimer(1000, actionEvent -> this.refreshSettings(), true);
            this.group = group;
            this.recordMode = group.getParent().getRecordMode();
            final Workflow workflow = group.getParent();
            this.setLayout(new BorderLayout());
            this.commentCollapsePanel = new CollapsePanel("Comment", true, !workflow.isToggleComments());
            this.commentCollapsePanel.setCollapseCallback(workflow::setToggleComments);
            this.modeInputField = new MultiCameraSettingsPanel.MultiModeInputField(breezeRecorder2.getFrame(), (Boolean)true);
            this.hardwareSidePanel = new HardwareSidePanel(breezeRecorder2, HardwareSidePanel.HardwareType.RecordWizard, null, hardware -> this.updateSettings());
            this.commentTextArea.setFontSize(14);
            this.commentTextArea.setRows(0);
            this.commentTextArea.setTextBackground(BreezeTheme.getInstance().getPanelBackground());
            this.commentTextArea.setPreferredSize(new Dimension(50, 90));
            ActionButtonPanel actionButtonPanel = breezeRecorder2.buttonPanel;
            this.recordButton = BreezeRecorder.this.createRecordButton("Record", "material/radio_button_checked", () -> this.loadHardwareAndRecord(breezeRecorder2, group), BreezeTheme.RECORDER_BUTTON_COLOR);
            actionButtonPanel.addComponent(this.recordButton);
            this.stopButton = BreezeRecorder.this.createRecordButton("Stop", "material/stop", this::stopRecord);
            this.stopButton.setEnabled(false);
            actionButtonPanel.addComponent(this.stopButton);
            actionButtonPanel.addComponent(new BreezeSeparator());
            this.addButton = BreezeRecorder.this.createRecordButton("New", "material/add", () -> this.addOrDelete(false));
            this.addButton.setEnabled(false);
            actionButtonPanel.addComponent(this.addButton);
            this.deleteButton = BreezeRecorder.this.createRecordButton("Remove", "material/delete", () -> BreezeOptionDialog.showDialog(this.getFrame(), this.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Remove", "Are you sure that you want to remove the recorded measurement?", null, breezeActionEvent -> this.addOrDelete(true)));
            this.deleteButton.setEnabled(false);
            actionButtonPanel.addComponent(this.deleteButton);
            this.finishButton = EntryMainHelper.createColorButton("Done", "material/done_all", () -> breezeRecorder2.getBackButton().executeRunnable(), BreezeTheme.getInstance().getSuccessBackgroundColor());
            this.finishButton.setVisible(false);
            actionButtonPanel.addComponent(this.finishButton);
            this.editButton = EntryMainHelper.createButton("Options", "explore/edit", () -> BreezeProgressDialog.startProgress(this.getFrame(), new OpenEntryProgressAction.OpenEntryDialogProgressAction(this, this.getFrame()){
                final /* synthetic */ BreezeRecorderViewPanel this$1;
                {
                    this.this$1 = breezeRecorderViewPanel;
                    super(breezeFrame);
                }

                @Override
                protected EntryMainPanel createOpenPanel() {
                    return new RecorderSettingsPanel(this.getProgressManager(), this.this$1.getFrame(), workflow, () -> {});
                }
            }, "Opening..."));
            actionButtonPanel.addComponentLast(this.editButton, 100);
            actionButtonPanel.add((Component)new BreezeSeparator(), GridBagHelper.create(101, new Insets(0, 5, 5, 5)));
            actionButtonPanel.addComponent(EntryMainHelper.createButton("Intro", "material/help", () -> BreezeOptionDialog.showDialog(this.getFrame(), this.getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Introduction to Breeze", "", (AbstractBreezeCustomPanel)new WelcomePanel(false), null, null)), 102, 10);
            this.settingsButton = EntryMainHelper.createSettingsButton(BreezeRecorder.this.frame);
            actionButtonPanel.addComponent(this.settingsButton, 103, 10);
            this.nameInputField.setName("measurementName");
            this.nameInputField.setValue(group.nextMeasurementName());
            this.setLeftSettingsPanel(this.hardwareSidePanel);
            this.activeTablePanel = new ActiveRealtimePanel.ActiveTablePanel(breezeRecorder2);
            this.setRightSettingsPanel(this.activeTablePanel);
            this.setRecordMode(this.recordMode);
            this.refreshTimer.start();
        }

        public void setRecordMode(RecordMode recordMode) {
            this.recordMode = recordMode;
            Workflow workflow = this.group.getParent();
            workflow.setRecordMode(recordMode);
            workflow.save();
            if (recordMode.isMeasurement()) {
                this.recordButton.setDesc("Record");
                this.recordButton.setResourceIcon("material/radio_button_checked");
                this.currentVariable = new RtRenderModeVariable(RenderMode.Rgb);
            } else {
                this.recordButton.setDesc("Play");
                this.recordButton.setResourceIcon("material/smart_display");
                this.currentVariable = null;
            }
            this.measurementTaker = null;
            this.updateSettings();
        }

        @Override
        public boolean showRightSettingsPanel() {
            return true;
        }

        private void loadHardwareAndRecord(BreezeRecorder breezeRecorder, final Group group) {
            BreezeProgressDialog.startProgressWithCancel(BreezeRecorder.this.frame, new ProgressAction(this){
                final /* synthetic */ BreezeRecorderViewPanel this$1;
                {
                    this.this$1 = breezeRecorderViewPanel;
                }

                @Override
                public void runAction() {
                    boolean bl = ConnectProgressAction.anyHardwareNeedsConnect();
                    ConnectProgressAction.connectAll(this.getProgressManager(), this.this$1.BreezeRecorder.this.frame);
                    this.setInfoText("Updating settings");
                    this.this$1.updateSettings(bl, false);
                }

                @Override
                public void actionFinished() {
                    SwingUtilities.invokeLater(() -> {
                        List<Camera> list = HardwareRegistry.getInstance().getCamerasForRecord();
                        SampleMover sampleMover = HardwareRegistry.getInstance().getSampleMover();
                        if (PlaceSampleStep.checkValid(this.this$1.BreezeRecorder.this.frame, group, this.this$1.nameInputField, this.this$1.getMeasurementName(), list, sampleMover, this.this$1.hardwareSidePanel, () -> this.checkWizardAndStartRecord(list))) {
                            this.checkWizardAndStartRecord(list);
                        }
                    });
                }

                private void checkWizardAndStartRecord(final List<Camera> list) {
                    if (this.shouldShowWizard()) {
                        BreezeProgressDialog.startProgress(this.this$1.getFrame(), new OpenEntryProgressAction(this, this.this$1.getFrame(), 0.7){
                            final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = var1_1;
                                super(breezeFrame, d);
                            }

                            @Override
                            protected BreezeMainPanel createOpenPanel() {
                                return new RecordWizard(this.this$2.this$1, this.this$2.this$1.group, this.this$2.this$1.recordMode, "Record wizard", list, this.this$2.this$1.measurementTaker, this.this$2.this$1.measureSettings, this.this$2.shouldScanBarcode(), string -> {
                                    String string2 = this.this$2.this$1.getMeasurementName().replace("<BARCODE>", string);
                                    if (PlaceSampleStep.checkValidName(this.this$2.this$1.BreezeRecorder.this.frame, group, null, string2)) {
                                        this.this$2.this$1.nameInputField.setText(string2);
                                        return true;
                                    }
                                    return false;
                                }, () -> this.this$2.startRecord());
                            }
                        }, "Opening...", 0);
                    } else {
                        this.startRecord();
                    }
                }

                private boolean shouldScanBarcode() {
                    String string = this.this$1.getMeasurementName();
                    boolean bl = string.contains("<BARCODE>");
                    return this.this$1.recordMode.isMeasurement() && bl;
                }

                private boolean shouldShowWizard() {
                    if (this.shouldScanBarcode()) {
                        return true;
                    }
                    if (this.this$1.recordMode.isMeasurement() && !this.this$1.hardwareSidePanel.isToggled()) {
                        return true;
                    }
                    ReferenceSettings referenceSettings = this.this$1.measureSettings.referenceSettings();
                    if (BreezeProperties.getInstance().showDarkReferenceWizardStep() && referenceSettings.shouldTakeDarkReferenceAutomatically(false)) {
                        return true;
                    }
                    return referenceSettings.shouldTakeAnyReferencesManually();
                }

                private void startRecord() {
                    SwingUtilities.invokeLater(() -> {
                        this.this$1.hardwareSidePanel.setEnabled(false);
                        this.this$1.commentCollapsePanel.setEnabled(true);
                        this.this$1.commentCollapsePanel.setExpandEnabled(true);
                        this.this$1.recordButton.setEnabled(false);
                        this.this$1.editButton.setEnabled(false);
                        this.this$1.settingsButton.setEnabled(false);
                        AtomicInteger atomicInteger = new AtomicInteger(1);
                        if (BreezeProperties.getInstance().getMultiCameraSetting().mode() == Camera.MultiCameraMode.SeparateFiles) {
                            atomicInteger.set(HardwareRegistry.getInstance().getCamerasForRecord().size());
                        }
                        this.this$1.measurementTaker.startMeasurementTaking(this.this$1.BreezeRecorder.this.frame, () -> this.this$1.stopButton.setEnabled(true), () -> {
                            if (atomicInteger.decrementAndGet() == 0) {
                                this.this$1.stopRecord();
                            }
                        }, () -> this.this$1.addOrDelete(true), n -> {});
                    });
                }

                @Override
                public boolean actionFailed(Exception exception) {
                    return ConnectProgressAction.logAndShowErrorMessage(this.this$1.BreezeRecorder.this.frame, exception, "camera");
                }
            }, "Connecting to hardware");
        }

        private void pushCommentsToMeasurement() {
            if (ObjectUtils.isNotEmpty(this.measurements) && !this.commentTextArea.getText().isEmpty()) {
                for (Measurement measurement : this.measurements) {
                    measurement.getComments().removeAll();
                    measurement.getComments().add(new Comment(this.commentTextArea.getText()));
                }
            }
        }

        private void addOrDelete(boolean bl) {
            this.addButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            if (bl) {
                if (ObjectUtils.isNotEmpty(this.measurements)) {
                    for (Measurement measurement : this.measurements) {
                        if (measurement == null) continue;
                        measurement.delete(false);
                        this.group.removeChild(measurement);
                    }
                    ToastHandler.getInstance().showToast(this.nameInputField.getValue() + " removed");
                    ToastHandler.getInstance().clearToast(this.nameInputField.getValue() + " saved");
                }
            } else {
                this.pushCommentsToMeasurement();
            }
            this.measurements.clear();
            this.reset();
            this.updateSettings();
            if (!bl) {
                this.nameInputField.setValue(this.group.nextMeasurementName());
                this.commentTextArea.setText("");
            }
            this.hardwareSidePanel.setEnabled(true);
            this.recordButton.setEnabled(true);
            this.editButton.setEnabled(true);
            this.settingsButton.setEnabled(true);
        }

        private void stopIfRunning() {
            if (this.stopButton.isEnabled()) {
                this.stopRecord();
            }
            this.measurementTaker.setStatus(MeasurementTaker.MeasurementStatus.Done);
        }

        private void stopRecord() {
            this.stopButton.setEnabled(false);
            this.addButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.finishButton.setVisible(true);
            this.editButton.setEnabled(true);
            this.settingsButton.setEnabled(true);
            this.measurementTaker.stopMeasurementTaking(true, list -> {
                this.measurements.clear();
                if (list != null) {
                    String string = this.commentTextArea.getText();
                    for (Measurement measurement : list) {
                        this.measurements.add(measurement);
                        if (string.isEmpty()) continue;
                        measurement.getComments().add(new Comment(string));
                        measurement.save();
                    }
                }
                if (this.recordMode.isMeasurement()) {
                    ToastHandler.getInstance().showToast(this.nameInputField.getValue() + " saved", Toast.IconType.Success, new Time.Seconds(15.0));
                }
            });
        }

        public void updateSettings() {
            this.updateSettings(true, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateSettings(boolean bl, boolean bl2) {
            Object object = this.$lock;
            synchronized (object) {
                if (bl2) {
                    SwingUtilities.invokeLater(() -> this.updateSettingsLocally(bl));
                } else {
                    this.updateSettingsLocally(bl);
                }
            }
        }

        public void updateSettingsLocally(boolean bl) {
            Object object;
            SampleMover sampleMover = HardwareRegistry.getInstance().getSampleMover();
            List<Camera> list = HardwareRegistry.getInstance().getCamerasForRecord();
            Camera camera = list.getFirst();
            Workflow workflow = this.group.getParent();
            if (bl) {
                if (this.recordMode.isMeasurement()) {
                    this.measureSettings = new MeasureSettings(MoverMeasureSettings.sampleMoverSettingsByType(sampleMover), new ByLengthMeasureLengthSettings(camera, false), new GroupRecordMmtCreateAndSaveSettings(this, measurement -> DataSetCache.clear(this.group)), ReferenceSettings.FromPropertiesCaptureMode(list, sampleMover));
                } else {
                    boolean bl2 = workflow.isDemoMode();
                    this.measureSettings = new MeasureSettings(this.getSampleMoverSettings(sampleMover, bl2), this.getPlayLengthSettings(camera, sampleMover, bl2), new RecorderPlaySettings.ByObjectSaveSettings(workflow), ReferenceSettings.FromPropertiesCaptureMode(list, sampleMover));
                }
                if (this.measurementTaker != null) {
                    this.currentVariable = this.measurementTaker.getCurrentVariable();
                    this.measurementTaker.cleanUp();
                }
                object = BreezeProperties.getInstance().getMultiCameraSetting().mode();
                this.measurementTaker = new MeasurementTaker(this.getMainPanel(), this.activeTablePanel, this.group, this.measureSettings, runtimeException -> {
                    Logg.error((String)"Error while recording", (Throwable)runtimeException);
                    BreezeOptionDialog.showErrorDialog(this.getFrame(), "Error while recording", runtimeException);
                    return true;
                }, list, this.recordMode, this.currentVariable, (Camera.MultiCameraMode)((Object)object));
                this.removeAll();
                this.add((Component)((Object)this.measurementTaker.getRuntimePanel()), "Center");
                this.revalidate();
                this.repaint();
            }
            this.modeInputField.setChangedListener(multiCameraSetting -> SwingUtilities.invokeLater(this::updateSettings));
            this.modeInputField.setVisible(HardwareRegistry.getInstance().getSecondCamera() != null);
            this.modeInputField.selectDefault();
            object = this.hardwareSidePanel.getAdditionSettingsPanel();
            ((Container)object).setLayout(new GridBagLayout());
            ((Container)object).removeAll();
            MeasurementWithoutIO measurementWithoutIO = new MeasurementWithoutIO(this.group);
            BreezeLabel breezeLabel = new BreezeLabel(measurementWithoutIO.getParent().getParent().getName() + " / " + measurementWithoutIO.getParent().getName() + " / ", ImageHelper.getResourceIcon("material/folder"), 12);
            breezeLabel.setMinimumSize(new Dimension(0, 25));
            breezeLabel.setPreferredSize(new Dimension(0, 25));
            breezeLabel.setFontStyle(2);
            breezeLabel.setOpaque(false);
            ((Container)object).add((Component)breezeLabel, GridBagHelper.create(((Container)object).getComponentCount(), new Insets(0, 0, 5, 0)));
            RecorderHelper.addRecordModeSection((JPanel)object, this, this.recordMode, this.modeInputField);
            if (this.recordMode.isMeasurement()) {
                DefaultSettingsPanel.SectionPanel sectionPanel = new DefaultSettingsPanel.SectionPanel("Measurement settings");
                sectionPanel.addComponentHorizontal(new SettingsPanel.MeasurementLengthPanel(BreezeRecorder.this));
                sectionPanel.addComponentHorizontal(this.nameInputField);
                this.commentCollapsePanel.getLabel().setFontSize(12);
                this.commentCollapsePanel.addPanel(this.commentTextArea);
                sectionPanel.addComponentHorizontal(this.commentCollapsePanel);
                ((Container)object).add((Component)sectionPanel, GridBagHelper.create(((Container)object).getComponentCount(), new Insets(0, 0, 0, 0)));
                this.activeTablePanel.setVisible(false);
            } else {
                ((Container)object).add((Component)new RecorderPlaySettings(workflow, this.measureSettings, camera.hasShutter(), sampleMover), GridBagHelper.create(((Container)object).getComponentCount(), new Insets(0, 0, 0, 0)));
                this.activeTablePanel.setVisible(true);
            }
            this.referenceSection = new RecorderHelper.ReferenceSectionPanel(this.getFrame(), () -> this.updateSettings(true, true), this.measureSettings.referenceSettings());
            if (this.referenceSection.hasVisibleComponents()) {
                ((Container)object).add((Component)this.referenceSection, GridBagHelper.create(((Container)object).getComponentCount(), new Insets(0, 0, 0, 0)));
            }
            this.hardwareSidePanel.setCameras(list);
            this.hardwareSidePanel.setSampleMover(sampleMover);
        }

        public void refreshSettings() {
            if (this.referenceSection != null) {
                this.referenceSection.checkValidTime();
            }
        }

        private MeasureLengthSettings getPlayLengthSettings(Camera camera, SampleMover sampleMover, boolean bl) {
            if (sampleMover == null || sampleMover.isConveyor()) {
                return new ByObjectMeasureLengthSettings();
            }
            return new ByLengthMeasureLengthSettings(camera, bl);
        }

        private MoverMeasureSettings getSampleMoverSettings(SampleMover sampleMover, boolean bl) {
            if (SampleMover.isConveyor(sampleMover)) {
                return new ConveyorMeasureSettings.SampleMoverConveyorByObjectSettings(sampleMover);
            }
            return new TrayMeasureSettings(sampleMover, bl);
        }

        private void reset() {
            this.measureSettings.referenceSettings().updateReferenceInfo();
            this.measurementTaker.reset();
        }

        @Override
        public String getType() {
            return "Recorder";
        }

        @Override
        public void showEntry(Object object, Object object2) {
        }

        public Measurement getMeasurement() {
            if (!this.measurements.isEmpty()) {
                return this.measurements.getFirst();
            }
            return null;
        }

        @Override
        public String getMeasurementName() {
            return this.nameInputField.getValue().trim();
        }

        @Override
        public List<BreezeInputField> getLoggingFields() {
            return this.loggingFields;
        }

        public MeasurementTaker.MeasurementStatus getStatus() {
            return this.measurementTaker.getStatus();
        }

        public int getCurrentFrameCount() {
            return this.measurementTaker.getCurrentFrameCount();
        }

        @Override
        protected void cleanUpChild() {
            super.cleanUpChild();
            if (this.measurementTaker != null) {
                this.measurementTaker.cleanUp();
            }
            this.refreshTimer.stop();
        }
    }

    public static enum RecordMode {
        Measurement,
        Play,
        TestScan;


        public boolean isMeasurement() {
            return this.equals((Object)Measurement) || this.equals((Object)TestScan);
        }

        public boolean isTestScan() {
            return this.equals((Object)TestScan);
        }

        public static RecordMode parse(String string) {
            for (RecordMode recordMode : RecordMode.values()) {
                if (!recordMode.name().equalsIgnoreCase(string)) continue;
                return recordMode;
            }
            return Measurement;
        }

        public boolean doPostProcessing() {
            return !this.isTestScan();
        }
    }
}

