/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.recorder;

import se.prediktera.breeze.backend.measure.settings.MeasureSaveSettings;
import se.prediktera.breeze.common.realtime.descriptor.usgs.DepthRegistrationPanel;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportBreezeRuntime;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.wizard.measure.step.PlaceSampleStep;
import se.prediktera.breeze.recorder.BreezeRecorder;

public class GroupRecordMmtCreateAndSaveSettings
implements MeasureSaveSettings {
    private final PlaceSampleStep.MeasurementInfoInterface measurementInfo;
    private final BreezeRecorder.OnMeasurementCallback onMeasurementCallback;

    public GroupRecordMmtCreateAndSaveSettings(PlaceSampleStep.MeasurementInfoInterface measurementInfoInterface, BreezeRecorder.OnMeasurementCallback onMeasurementCallback) {
        this.measurementInfo = measurementInfoInterface;
        this.onMeasurementCallback = onMeasurementCallback;
    }

    @Override
    public boolean byObject() {
        return false;
    }

    @Override
    public boolean shouldSaveMeasurements() {
        return true;
    }

    @Override
    public boolean shouldSaveRawData() {
        return true;
    }

    @Override
    public String getMeasurementName(Group group) {
        if (this.measurementInfo != null) {
            return this.measurementInfo.getMeasurementName();
        }
        return group.nextMeasurementName();
    }

    @Override
    public PPExportBreezeRuntime.ObjectProcessing getObjectProcessing() {
        return PPExportBreezeRuntime.ObjectProcessing.Sequential;
    }

    @Override
    public boolean isCropMeasurement() {
        return false;
    }

    @Override
    public void onMeasurementCallback(Measurement measurement) {
        if (this.measurementInfo != null && this.measurementInfo.getLoggingFields().size() > 0) {
            DepthRegistrationPanel.MeasurementDepthInfo measurementDepthInfo = new DepthRegistrationPanel.MeasurementDepthInfo(measurement);
            for (BreezeInputField breezeInputField : this.measurementInfo.getLoggingFields()) {
                measurement.getProperties().setPropertyLocal("logging/" + breezeInputField.getName(), RtDataFormat.toStringAll(breezeInputField.getNumber() / measurementDepthInfo.factor));
                measurement.save();
            }
        }
        this.onMeasurementCallback.onMeasurement(measurement);
    }
}

