/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.recorder;

import java.util.List;
import se.prediktera.breeze.backend.measure.MeasurementTaker;
import se.prediktera.breeze.backend.measure.settings.MeasureSettings;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.frontend.common.swing.dialog.ScanBarcodeWizardStep;
import se.prediktera.breeze.frontend.wizard.WizardPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.ManualDarkReferenceStep;
import se.prediktera.breeze.frontend.wizard.measure.step.ManualRemoveDarkReferenceStep;
import se.prediktera.breeze.frontend.wizard.measure.step.ManualRemoveWhiteReferenceStep;
import se.prediktera.breeze.frontend.wizard.measure.step.ManualWhiteReferenceStep;
import se.prediktera.breeze.frontend.wizard.measure.step.MeasurementInformationStep;
import se.prediktera.breeze.frontend.wizard.measure.step.TakeDarkReferenceStep;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.recorder.BreezeRecorder;

public class RecordWizard
extends WizardPanel {
    private final Runnable onFinish;

    public RecordWizard(BreezeRecorder.BreezeRecorderViewPanel breezeRecorderViewPanel, Group group, BreezeRecorder.RecordMode recordMode, String string, List<Camera> list, MeasurementTaker measurementTaker, MeasureSettings measureSettings, boolean bl, OnBarcodeScannedCallback onBarcodeScannedCallback, Runnable runnable) {
        super(breezeRecorderViewPanel.getFrame(), string, false);
        this.onFinish = runnable;
        WizardStep.WizardControlCallback wizardControlCallback = this.createWizardControl();
        if (recordMode.isMeasurement() && !breezeRecorderViewPanel.hardwareSidePanel.isToggled()) {
            this.addWizardStep(new MeasurementInformationStep(breezeRecorderViewPanel, group));
        }
        if (bl) {
            this.addWizardStep(new ScanBarcodeWizardStep(this.getFrame(), this.getPageColor(), onBarcodeScannedCallback::onBarcodeScanned, () -> this.moveToNextStep(true)));
        }
        for (Camera camera : list) {
            this.addWhiteAndDarkReferenceSteps(camera, wizardControlCallback, measurementTaker, measureSettings);
        }
    }

    private void addWhiteAndDarkReferenceSteps(Camera camera, WizardStep.WizardControlCallback wizardControlCallback, MeasurementTaker measurementTaker, MeasureSettings measureSettings) {
        ManualDarkReferenceStep manualDarkReferenceStep = new ManualDarkReferenceStep(wizardControlCallback, measurementTaker, this.getFrame(), camera, measureSettings);
        this.addWizardStep(manualDarkReferenceStep);
        this.addWizardStep(new ManualRemoveDarkReferenceStep(camera, measurementTaker, manualDarkReferenceStep));
        this.addWizardStep(new TakeDarkReferenceStep(measurementTaker, this.getFrame(), camera, measureSettings));
        SampleMover sampleMover = measureSettings.sampleMoverSettings().sampleMover();
        ManualWhiteReferenceStep manualWhiteReferenceStep = new ManualWhiteReferenceStep(wizardControlCallback, measurementTaker, this.getFrame(), camera, measureSettings, sampleMover);
        this.addWizardStep(manualWhiteReferenceStep);
        this.addWizardStep(new ManualRemoveWhiteReferenceStep(camera, measurementTaker, manualWhiteReferenceStep, sampleMover));
    }

    @Override
    public BreezeType getPageType() {
        return BreezeType.Recorder;
    }

    @Override
    protected void finishWizard() {
        this.onFinish.run();
        super.finishWizard();
    }

    @Override
    protected String getFinishText() {
        return "Record";
    }

    public static interface OnBarcodeScannedCallback {
        public boolean onBarcodeScanned(String var1);
    }
}

