/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.recorder;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.SimpleDateFormat;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.backend.measure.settings.ReferenceSettings;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeRadioButton;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.hardware.ConnectProgressAction;
import se.prediktera.breeze.frontend.main.settings.hardware.MultiCameraSettingsPanel;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.recorder.BreezeRecorder;

public class RecorderHelper {
    public static void addRecordModeSection(JPanel jPanel, BreezeRecorder.BreezeRecorderViewPanel breezeRecorderViewPanel, BreezeRecorder.RecordMode recordMode, MultiCameraSettingsPanel.MultiModeInputField multiModeInputField) {
        DefaultSettingsPanel.SectionPanel sectionPanel = new DefaultSettingsPanel.SectionPanel("Record mode");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setOpaque(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.add((Component)new BreezeRadioButton("Fixed length", 12, buttonGroup, recordMode.isMeasurement(), (breezeRadioButton, bl) -> breezeRecorderViewPanel.setRecordMode(BreezeRecorder.RecordMode.Measurement)), gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        jPanel2.add((Component)new BreezeRadioButton("Continuous", 12, buttonGroup, !recordMode.isMeasurement(), (breezeRadioButton, bl) -> breezeRecorderViewPanel.setRecordMode(BreezeRecorder.RecordMode.Play)), gridBagConstraints2);
        sectionPanel.addComponentHorizontal(jPanel2);
        sectionPanel.addComponentHorizontal(multiModeInputField, 5);
        jPanel.add((Component)sectionPanel, GridBagHelper.createWithWeigthX1(jPanel.getComponentCount(), new Insets(0, 0, 0, 0)));
    }

    private static JPanel setWarningIconAfterComboBox(ReferenceComboBoxInputField referenceComboBoxInputField, String string, String string2) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)referenceComboBoxInputField, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        BreezeButton breezeButton = new BreezeButton();
        breezeButton.setResourceIcon("material/warning");
        breezeButton.addClickCallBack(() -> BreezeOptionDialog.showDialog(BreezeFrame.getInstance(), BreezeType.Recorder.getColor(), AbstractBreezeDialog.MessageType.ERROR_OPTION, string, string2));
        jPanel.add((Component)breezeButton, gridBagConstraints);
        return jPanel;
    }

    public static class ReferenceComboBoxInputField
    extends BreezeComboBoxInputField<Object> {
        private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        public ReferenceComboBoxInputField(boolean bl, ReferenceSettings referenceSettings) {
            super(bl ? "Dark" : "White", "", BreezeInputFieldHelper.Format.OneRow);
            SpectralReference spectralReference;
            boolean bl2;
            long l;
            ReferenceSettings.ReferenceAction referenceAction;
            this.getLabel().setFontSize(12);
            this.setLabelWidth(35);
            this.getComboBox().setName(bl ? "darkAction" : "whiteAction");
            this.getComboBox().setFont(new Font("Tahoma", 0, 12));
            if (bl) {
                referenceAction = referenceSettings.getDarkAction();
                l = BreezeProperties.getInstance().getDarkReferenceDelay().ms;
                bl2 = referenceSettings.canTakeDarkReferenceAutomatically();
                spectralReference = referenceSettings.getDarkReference();
            } else {
                referenceAction = referenceSettings.getWhiteAction();
                l = BreezeProperties.getInstance().getWhiteReferenceDelay().ms;
                bl2 = referenceSettings.canTakeWhiteReferenceAutomatically();
                spectralReference = referenceSettings.getWhiteReference();
            }
            this.addItem("Capture new (" + (bl2 ? "Automatically" : "Manually") + ")");
            if (spectralReference != null) {
                if (l > 0L) {
                    this.addItem(new UseStoredItem(bl, referenceSettings));
                } else {
                    this.addItem("Use stored (" + sdf.format(spectralReference.getDate()) + ")");
                }
            }
            if (!bl || WorkspaceManager.GUITEST) {
                this.addItem("Disable");
            }
            this.setSelectedIndex(referenceAction);
            this.setChangedListener(object -> {
                ReferenceSettings.ReferenceAction referenceAction = ReferenceSettings.ReferenceAction.getAction(this.getSelectedItem());
                if (bl) {
                    referenceSettings.setActionDark(referenceAction);
                    BreezeProperties.getInstance().setDarkReferenceCaptureMode(referenceAction);
                } else {
                    referenceSettings.setActionWhite(referenceAction);
                    BreezeProperties.getInstance().setWhiteReferenceCaptureMode(referenceAction);
                }
            });
            this.setEnabled(this.getItemCount() > 1);
            if (bl) {
                this.setVisible(!referenceAction.record() || !bl2);
            }
        }

        private void setSelectedIndex(ReferenceSettings.ReferenceAction referenceAction) {
            for (int i = 0; i < this.getItemCount(); ++i) {
                if (!referenceAction.equals((Object)ReferenceSettings.ReferenceAction.getAction(this.getItemAt(i)))) continue;
                this.setSelectedIndex(i);
                return;
            }
        }

        public void checkValidTime() {
            if (this.getSelectedItem() instanceof UseStoredItem) {
                this.getComboBox().repaint();
            }
        }

        private static final class UseStoredItem {
            private final boolean isDark;
            private final ReferenceSettings ref;

            public UseStoredItem(boolean bl, ReferenceSettings referenceSettings) {
                this.isDark = bl;
                this.ref = referenceSettings;
            }

            private Time currentValidTime() {
                return this.isDark ? this.ref.getDarkReferenceValidTime() : this.ref.getWhiteReferenceValidTime();
            }

            public String toString() {
                Time time = this.currentValidTime();
                String string = time.isZero() ? "Expired" : time.toCompactNiceString();
                return "Use stored [" + string + "]";
            }

            public boolean equals(Object object) {
                return this == object;
            }

            public int hashCode() {
                return System.identityHashCode(this);
            }
        }
    }

    public static class ReferenceSectionPanel
    extends DefaultSettingsPanel.SectionPanel {
        private ReferenceComboBoxInputField darkRefComboBox;
        private ReferenceComboBoxInputField whiteRefComboBox;

        public ReferenceSectionPanel(final BreezeFrame breezeFrame, final OnConnectCallback onConnectCallback, final ReferenceSettings referenceSettings) {
            super("Reference information");
            if (!referenceSettings.isHardwareConnected()) {
                ImageIcon imageIcon = ImageHelper.getResourceIcon("information");
                this.addComponent(new BreezeLabel("Hardware not connected", imageIcon, 12));
                this.addComponentRight(EntryMainHelper.createSmallTextButton("Connect", () -> BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(this){

                    @Override
                    public void runAction() {
                        ConnectProgressAction.connectAll(this.getProgressManager(), breezeFrame, referenceSettings.getCameras());
                        this.setInfoText("Updating settings");
                        onConnectCallback.connect();
                    }
                }, "Connecting hardware")));
            } else if (referenceSettings.useAnyReferences()) {
                this.darkRefComboBox = new ReferenceComboBoxInputField(true, referenceSettings);
                if (this.darkRefComboBox.isVisible()) {
                    ReferenceSettings.ReferenceAction referenceAction = ReferenceSettings.ReferenceAction.getAction(this.darkRefComboBox.getSelectedItem());
                    if (!referenceAction.record() && HardwareRegistry.getInstance().anyCameraHasShutter()) {
                        this.addComponentHorizontal(RecorderHelper.setWarningIconAfterComboBox(this.darkRefComboBox, "Using stored dark reference", "Using cached dark references is generally discouraged when the camera has an automatic shutter. Consider adjusting the dark reference capture mode if applicable."));
                    } else {
                        this.addComponentHorizontal(this.darkRefComboBox);
                    }
                }
                this.whiteRefComboBox = new ReferenceComboBoxInputField(false, referenceSettings);
                if (referenceSettings.shouldCaptureNewWhiteStoredReference()) {
                    this.addComponentHorizontal(RecorderHelper.setWarningIconAfterComboBox(this.whiteRefComboBox, "White Reference Expiry Notice and Renewal Instructions", "The current cached white reference has expired or is no longer valid. Breeze will prompt you to record a new white reference during your next measurement. This new reference will be used for future recordings as long as it remains within the cache period.\n\nPlease ensure you have access to the white reference material when required."));
                } else {
                    this.addComponentHorizontal(this.whiteRefComboBox);
                }
            }
        }

        public void checkValidTime() {
            ReferenceSectionPanel.checkValidTime(this.darkRefComboBox);
            ReferenceSectionPanel.checkValidTime(this.whiteRefComboBox);
        }

        private static void checkValidTime(ReferenceComboBoxInputField referenceComboBoxInputField) {
            if (referenceComboBoxInputField != null && referenceComboBoxInputField.isVisible()) {
                referenceComboBoxInputField.checkValidTime();
            }
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            for (int i = 0; i < this.getPanel().getComponentCount(); ++i) {
                Component component;
                JPanel jPanel;
                Component component2 = this.getPanel().getComponent(i);
                if (!(component2 instanceof JPanel) || (jPanel = (JPanel)component2).getComponentCount() <= 1 || !((component = jPanel.getComponent(1)) instanceof BreezeButton)) continue;
                component2 = (BreezeButton)component;
                ((BreezeButton)component2).setEnabled(true);
            }
        }

        public static interface OnConnectCallback {
            public void connect();
        }
    }
}

