/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.recorder;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.backend.measure.settings.MeasureSaveSettings;
import se.prediktera.breeze.backend.measure.settings.MeasureSettings;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportBreezeRuntime;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportSegmentation;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeRadioButton;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;
import se.prediktera.breeze.frontend.main.settings.SettingsPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.SegmentationOptionPanel;
import se.prediktera.breeze.hardware.SampleMover;

public class RecorderPlaySettings
extends JPanel {
    private final MeasureSettings measureSettings;
    private GeneralPanel generalPanel;
    private DemoPanel demoPanel;
    private final Workflow workflow;
    private boolean updating;
    private MeasurementSegmentationPanel segmentationPanel;

    public RecorderPlaySettings(Workflow workflow, MeasureSettings measureSettings, boolean bl, SampleMover sampleMover) {
        super(new GridBagLayout());
        this.workflow = workflow;
        this.setBackground(BreezeTheme.getInstance().getSettingPanelBackground());
        this.updating = true;
        this.removeAll();
        this.measureSettings = measureSettings;
        ByObjectSaveSettings byObjectSaveSettings = (ByObjectSaveSettings)measureSettings.saveSettings();
        this.generalPanel = new GeneralPanel(workflow, byObjectSaveSettings, measureSettings, bl, sampleMover);
        this.addOption(this.generalPanel);
        this.segmentationPanel = new MeasurementSegmentationPanel(byObjectSaveSettings);
        this.addOption(this.segmentationPanel);
        if (SampleMover.isTray(sampleMover)) {
            this.demoPanel = new DemoPanel(sampleMover, workflow.isDemoMode());
            this.addOption(this.demoPanel);
        }
        this.revalidate();
        this.repaint();
        this.updating = false;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof DefaultSettingsPanel.SectionPanel)) continue;
            DefaultSettingsPanel.SectionPanel sectionPanel = (DefaultSettingsPanel.SectionPanel)component;
            sectionPanel.setEnabled(bl);
        }
    }

    public void addOption(DefaultSettingsPanel.SectionPanel sectionPanel) {
        int n;
        this.add((Component)sectionPanel, GridBagHelper.createWithWeigthX1(n, new Insets((n = this.getComponentCount()) > 0 ? 2 : 0, 0, 0, 0)));
    }

    private void updateMeasureSettingsAndSave() {
        if (this.updating) {
            return;
        }
        ByObjectSaveSettings byObjectSaveSettings = (ByObjectSaveSettings)this.measureSettings.saveSettings();
        byObjectSaveSettings.setShouldSaveMeasurements(this.generalPanel.isSaveMeasurements());
        byObjectSaveSettings.setShouldSaveRawData(this.generalPanel.isSaveRawData());
        byObjectSaveSettings.setObjectProcessing(this.segmentationPanel.getObjectProcessing());
        byObjectSaveSettings.setCropMeasurement(this.segmentationPanel.isCropMeasurement());
        this.workflow.setDemoMode(false);
        if (this.demoPanel != null) {
            this.measureSettings.sampleMoverSettings().setMode(SampleMover.ScanMode.fromDemo(this.demoPanel.enabled()));
            this.measureSettings.lengthSettings().setDemoMode(this.demoPanel.enabled());
            if (this.demoPanel.enabled()) {
                this.workflow.setDemoMode(true);
            }
        }
        XmlProperties xmlProperties = this.workflow.getProperties();
        xmlProperties.setPropertyBoolLocal("measure/saveMeasurements", byObjectSaveSettings.shouldSaveMeasurements());
        xmlProperties.setPropertyBoolLocal("measure/saveRawData", byObjectSaveSettings.shouldSaveRawData());
        xmlProperties.setPropertyBoolLocal("measure/parallelMeasurementSegmentation", byObjectSaveSettings.getObjectProcessing().boolValue());
        xmlProperties.setPropertyBoolLocal("measure/cropMeasurement", byObjectSaveSettings.isCropMeasurement());
        this.workflow.save();
    }

    public static class ByObjectSaveSettings
    implements MeasureSaveSettings {
        private boolean shouldSaveMeasurements = true;
        private boolean shouldSaveRawData = true;
        private PPExportBreezeRuntime.ObjectProcessing objectProcessing = PPExportBreezeRuntime.ObjectProcessing.Sequential;
        private boolean cropMeasurement;

        public ByObjectSaveSettings(Workflow workflow) {
            this.shouldSaveMeasurements = workflow.shouldSaveMeasurementsWithObjectRecognition();
            this.shouldSaveRawData = workflow.shouldSaveRawDataWhenMeasuringWithObjectRecognition();
            this.objectProcessing = workflow.isParallelMeasurementSegmentation();
            this.cropMeasurement = workflow.isCropMeasurement();
        }

        @Override
        public boolean byObject() {
            return true;
        }

        public void setShouldSaveRawData(boolean bl) {
            this.shouldSaveRawData = bl;
        }

        @Override
        public boolean shouldSaveMeasurements() {
            return this.shouldSaveMeasurements;
        }

        public void setShouldSaveMeasurements(boolean bl) {
            this.shouldSaveMeasurements = bl;
        }

        @Override
        public boolean shouldSaveRawData() {
            return this.shouldSaveRawData;
        }

        public void setObjectProcessing(PPExportBreezeRuntime.ObjectProcessing objectProcessing) {
            this.objectProcessing = objectProcessing;
        }

        @Override
        public PPExportBreezeRuntime.ObjectProcessing getObjectProcessing() {
            return this.objectProcessing;
        }

        public void setCropMeasurement(boolean bl) {
            this.cropMeasurement = bl;
        }

        @Override
        public boolean isCropMeasurement() {
            return this.cropMeasurement;
        }

        @Override
        public String getMeasurementName(Group group) {
            return null;
        }

        @Override
        public void onMeasurementCallback(Measurement measurement) {
        }
    }

    private class GeneralPanel
    extends DefaultSettingsPanel.SectionPanel {
        private final BreezeCheckBox saveMeasurementsCheckBox;
        private final BreezeCheckBox saveRawDataCheckBox;

        public GeneralPanel(Workflow workflow, ByObjectSaveSettings byObjectSaveSettings, MeasureSettings measureSettings, boolean bl2, SampleMover sampleMover) {
            super("Settings");
            if (SampleMover.isTray(sampleMover)) {
                this.addComponentHorizontal(new SettingsPanel.MeasurementLengthPanel());
            }
            this.saveMeasurementsCheckBox = new BreezeCheckBox("Save image measurements", byObjectSaveSettings.shouldSaveMeasurements(), bl -> RecorderPlaySettings.this.updateMeasureSettingsAndSave());
            this.addComponentHorizontal(this.saveMeasurementsCheckBox, 5);
            this.saveMeasurementsCheckBox.setFontSize(12);
            this.saveMeasurementsCheckBox.setName("savemeasurements");
            this.saveRawDataCheckBox = new BreezeCheckBox("Include spectral raw data", byObjectSaveSettings.shouldSaveRawData(), bl -> RecorderPlaySettings.this.updateMeasureSettingsAndSave());
            this.addComponentHorizontal(this.saveRawDataCheckBox, 0);
            this.saveRawDataCheckBox.setFontSize(12);
            this.saveRawDataCheckBox.setName("saverawdata");
            this.saveRawDataCheckBox.setEnabled(this.saveMeasurementsCheckBox.isSelected());
            this.saveMeasurementsCheckBox.addItemListener(itemEvent -> this.saveRawDataCheckBox.setEnabled(this.saveMeasurementsCheckBox.isSelected()));
        }

        public boolean isSaveMeasurements() {
            return this.saveMeasurementsCheckBox.isSelected();
        }

        public boolean isSaveRawData() {
            return this.saveRawDataCheckBox.isSelected();
        }
    }

    private class MeasurementSegmentationPanel
    extends DefaultSettingsPanel.SectionPanel {
        private final ButtonGroup buttonGroup;
        private final BreezeRadioButton sequentialMeasurementSegmentationRadioButton;
        private final BreezeRadioButton parallelMeasurementSegmentationRadioButton;
        private final BreezeCheckBox cropMeasurementCheckBox;
        private final JPanel leftPanel;

        public MeasurementSegmentationPanel(ByObjectSaveSettings byObjectSaveSettings) {
            super("Segmentation");
            this.buttonGroup = new ButtonGroup();
            this.leftPanel = new JPanel(new GridBagLayout());
            PPExportSegmentation.SegmentationInputField segmentationInputField = new PPExportSegmentation.SegmentationInputField();
            segmentationInputField.getLabel().setFontSize(12);
            segmentationInputField.init(RecorderPlaySettings.this.workflow);
            segmentationInputField.setChangedListener(object -> {
                recorderPlaySettings.workflow.getVisualisationNode().setSegmentationLevel(segmentationInputField.getSelectedIndex());
                RecorderPlaySettings.this.updateMeasureSettingsAndSave();
            });
            this.addComponentHorizontal(segmentationInputField);
            this.leftPanel.setOpaque(false);
            SegmentationOptionPanel segmentationOptionPanel = new SegmentationOptionPanel();
            this.cropMeasurementCheckBox = new BreezeCheckBox("Crop", byObjectSaveSettings.isCropMeasurement(), bl -> this.updateOption(segmentationOptionPanel));
            this.cropMeasurementCheckBox.setFontSize(12);
            this.sequentialMeasurementSegmentationRadioButton = new BreezeRadioButton("Sequential", 12, this.buttonGroup, !byObjectSaveSettings.getObjectProcessing().boolValue(), (breezeRadioButton, bl) -> this.updateOption(segmentationOptionPanel));
            InputFieldHelper.addPanel(this.leftPanel, this.sequentialMeasurementSegmentationRadioButton);
            this.sequentialMeasurementSegmentationRadioButton.setName("sequantial");
            this.parallelMeasurementSegmentationRadioButton = new BreezeRadioButton("Parallel", 12, this.buttonGroup, byObjectSaveSettings.getObjectProcessing().boolValue(), (breezeRadioButton, bl) -> this.updateOption(segmentationOptionPanel));
            InputFieldHelper.addPanel(this.leftPanel, this.parallelMeasurementSegmentationRadioButton);
            this.parallelMeasurementSegmentationRadioButton.setName("parallel");
            InputFieldHelper.addPanel(this.leftPanel, this.cropMeasurementCheckBox, true, new Insets(10, 10, 0, 0));
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setOpaque(false);
            GridBagConstraints gridBagConstraints = GridBagHelper.create(0, new Insets(0, 0, 0, 0), false);
            gridBagConstraints.anchor = 18;
            jPanel.add((Component)this.leftPanel, gridBagConstraints);
            jPanel.add((Component)segmentationOptionPanel, GridBagHelper.create(1, new Insets(0, 20, 0, 0), true));
            CollapsePanel collapsePanel = new CollapsePanel("Object processing", true, !WorkspaceManager.GUITEST);
            collapsePanel.setLabelFontSize(12);
            collapsePanel.addPanel(jPanel);
            this.addComponentHorizontal(collapsePanel);
            this.updateOption(segmentationOptionPanel);
            this.cropMeasurementCheckBox.setEnabled(this.parallelMeasurementSegmentationRadioButton.isSelected());
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            for (int i = 0; i < this.leftPanel.getComponentCount(); ++i) {
                this.leftPanel.getComponent(i).setEnabled(bl);
            }
        }

        private void updateOption(SegmentationOptionPanel segmentationOptionPanel) {
            if (this.sequentialMeasurementSegmentationRadioButton.isSelected()) {
                this.cropMeasurementCheckBox.setEnabled(false);
                segmentationOptionPanel.setOption(SegmentationOptionPanel.SegmentationOption.Sequential);
            } else {
                this.cropMeasurementCheckBox.setEnabled(true);
                if (this.cropMeasurementCheckBox.isSelected()) {
                    segmentationOptionPanel.setOption(SegmentationOptionPanel.SegmentationOption.Crop);
                } else {
                    segmentationOptionPanel.setOption(SegmentationOptionPanel.SegmentationOption.Parallel);
                }
            }
            RecorderPlaySettings.this.updateMeasureSettingsAndSave();
        }

        public PPExportBreezeRuntime.ObjectProcessing getObjectProcessing() {
            return PPExportBreezeRuntime.ObjectProcessing.parse(this.parallelMeasurementSegmentationRadioButton.isSelected());
        }

        public boolean isCropMeasurement() {
            return this.cropMeasurementCheckBox.isEnabled() && this.cropMeasurementCheckBox.isSelected();
        }
    }

    private class DemoPanel
    extends DefaultSettingsPanel.SectionPanel {
        private final BreezeCheckBox demoCheckBox;

        public DemoPanel(SampleMover sampleMover, boolean bl2) {
            super("Demo mode");
            this.demoCheckBox = new BreezeCheckBox("", false, bl -> RecorderPlaySettings.this.updateMeasureSettingsAndSave());
            this.demoCheckBox.setFontSize(12);
            this.demoCheckBox.setSelected(bl2);
            this.demoCheckBox.setName("demo");
            this.demoCheckBox.setEnabled(SampleMover.isTray(sampleMover));
            this.demoCheckBox.setText("<html>Sample mover will loop forward<br>and backwards</html>");
            this.addComponentHorizontal(this.demoCheckBox);
        }

        public boolean enabled() {
            return this.demoCheckBox.isEnabled() && this.demoCheckBox.isSelected();
        }
    }
}

