/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.recorder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.EntryWithSave;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlPropertyViewPanel;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;

public class RecorderSettingsPanel
extends EntryMainPanel {
    public RecorderSettingsPanel(BreezeProgress breezeProgress, BreezeFrame breezeFrame, Workflow workflow, Runnable runnable) {
        super(breezeFrame, BreezeType.Settings, "Project options", false, false, 320);
        this.verticalLabelPanel.setVisible(false);
        ArrayList<ViewClass> arrayList = new ArrayList<ViewClass>();
        arrayList.add(new MaintenancePanel.SettingsViewClass("Current project options", "Visualization and continuous options", (AbstractViewPanel)new SettingsPanel(this, workflow, runnable), "general.png"));
        this.setLists(arrayList, arrayList, null);
    }

    @Override
    protected int getMainHeight() {
        return 70;
    }

    public static class SettingsPanel
    extends AbstractViewPanel
    implements EntryWithSave {
        private final XmlPropertyViewPanel generalSettingsPanel;
        private final XmlPropertyViewPanel visualizationPanel;
        private final Workflow workflow;
        private final Runnable callback;

        public SettingsPanel(RecorderSettingsPanel recorderSettingsPanel, Workflow workflow, Runnable runnable) {
            super(recorderSettingsPanel);
            this.workflow = workflow;
            this.callback = runnable;
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBackground(BreezeTheme.getInstance().getPanelBackground());
            int n = 0;
            CollapsePanel collapsePanel = new CollapsePanel("Visualization", true, false);
            this.visualizationPanel = new XmlPropertyViewPanel(recorderSettingsPanel, this);
            collapsePanel.addPanel((JComponent)((Object)this.visualizationPanel), GridBagHelper.createWithWeigthX1(n++, new Insets(12, 0, 0, 0)));
            jPanel.add((Component)collapsePanel, GridBagHelper.createWithWeigthX1(n++, new Insets(12, 0, 0, 0)));
            collapsePanel = new CollapsePanel("Continuous settings", false, false);
            jPanel.add((Component)collapsePanel, GridBagHelper.createWithWeigthX1(n++, new Insets(12, 0, 0, 0)));
            this.generalSettingsPanel = new XmlPropertyViewPanel(recorderSettingsPanel, this);
            collapsePanel.addPanel((JComponent)((Object)this.generalSettingsPanel), GridBagHelper.createWithWeigthX1(n++, new Insets(12, 0, 0, 0)));
            jPanel.add((Component)new BreezeLabel(""), GridBagHelper.createLast(n, new Insets(0, 0, 0, 0)));
            this.add(new BreezeScrollPane.VerticalOnly(jPanel));
        }

        @Override
        public String getType() {
            return "Settings";
        }

        public String toString() {
            return "";
        }

        @Override
        public void showEntry(Object object, Object object2) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            arrayList.add(this.workflow.getProperties().getPropertyNodeLocal("measure/maxlines"));
            this.generalSettingsPanel.updatePanel(null, arrayList);
            ArrayList<Node> arrayList2 = new ArrayList<Node>();
            arrayList2.add(this.workflow.getProperties().getPropertyNodeLocal("visualisation/colorScale"));
            arrayList2.add(this.workflow.getProperties().getPropertyNodeLocal("visualisation/direction"));
            arrayList2.add(this.workflow.getProperties().getPropertyNodeLocal("visualisation/horizontalDirection"));
            arrayList2.add(this.workflow.getProperties().getPropertyNodeLocal("visualisation/verticalDirection"));
            this.visualizationPanel.updatePanel(null, arrayList2);
        }

        @Override
        public void save() {
            this.workflow.save();
            this.callback.run();
        }
    }
}

