/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.recorder;

import lombok.Generated;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;

public enum RenderMode {
    Gray("Gray"),
    Rgb("RGB"),
    RgbSquareRoot("RGB\u221a"),
    Intensity("Intensity"),
    Saturation("Saturation");

    private final String text;

    private RenderMode(String string2) {
        this.text = string2;
    }

    public boolean hasLegend() {
        return this.equals((Object)Intensity) || this.equals((Object)Saturation);
    }

    public boolean isRgb() {
        return this.equals((Object)Rgb) || this.equals((Object)RgbSquareRoot);
    }

    public String getDescription() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "RGB converted to gray scale";
            case 1 -> "RGB values";
            case 2 -> "Square root of RGB values";
            case 3 -> "Percentage of maximum signal";
            case 4 -> "Percentage of saturated bands";
        };
    }

    public String getVariableName(int n) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "Gray#" + n;
            case 1 -> "Rgb#";
            case 2 -> "Rgb#Square";
            case 3 -> "Saturation#";
            case 4 -> "Saturation#Band%";
        };
    }

    public Factor getFactor() {
        if (this.equals((Object)Intensity)) {
            return new PropertyFactor(this.name(), "uid", "Max %");
        }
        if (this.equals((Object)Saturation)) {
            return new PropertyFactor(this.name(), "uid", "Band %");
        }
        return null;
    }

    @Generated
    public String getText() {
        return this.text;
    }
}

