/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.test.asserts;

import java.util.ArrayList;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import se.prediktera.breeze.common.entry.measurement.MeasurementFileLocation;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorHolder;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.test.asserts.AssertCloseTo;
import se.prediktera.breeze.common.util.test.asserts.AssertFrame;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;

public class AssertMeasurement {
    public static void assertMeasurementHasAllFiles_noReferences_noPrediction(Measurement measurement) {
        MatcherAssert.assertThat((String)"measurement has xml file", (boolean)measurement.getXml().exists());
        MatcherAssert.assertThat((String)"measurement has raw file", (boolean)new MeasurementFileLocation.Raw().file(measurement).exists());
        MatcherAssert.assertThat((String)"measurement has raw header file", (boolean)new MeasurementFileLocation.Raw().header(measurement).exists());
        MatcherAssert.assertThat((String)"measurement has thumbnail file", (boolean)measurement.getThumbnailFile().exists());
    }

    public static void assertMeasurementHasAllFiles_noPrediction(Measurement measurement) {
        MatcherAssert.assertThat((String)"measurement has xml file", (boolean)measurement.getXml().exists());
        MatcherAssert.assertThat((String)"measurement has raw file", (boolean)new MeasurementFileLocation.Raw().file(measurement).exists());
        MatcherAssert.assertThat((String)"measurement has raw header file", (boolean)new MeasurementFileLocation.Raw().header(measurement).exists());
        MatcherAssert.assertThat((String)"measurement has thumbnail file", (boolean)measurement.getThumbnailFile().exists());
        MatcherAssert.assertThat((String)"measurement has all files", (boolean)measurement.hasReferences());
    }

    public static void assertMeasurementHasAllFiles(Measurement measurement) {
        MatcherAssert.assertThat((String)"measurement has xml file", (boolean)measurement.getXml().exists());
        MatcherAssert.assertThat((String)"measurement has raw file", (boolean)new MeasurementFileLocation.Raw().file(measurement).exists());
        MatcherAssert.assertThat((String)"measurement has raw header file", (boolean)new MeasurementFileLocation.Raw().header(measurement).exists());
        MatcherAssert.assertThat((String)"measurement has thumbnail file", (boolean)measurement.getThumbnailFile().exists());
        MatcherAssert.assertThat((String)"measurement has all files", (boolean)measurement.hasReferences());
        MatcherAssert.assertThat((String)"measurement has all files", (boolean)measurement.getPredictionRawFile().exists());
        MatcherAssert.assertThat((String)"measurement has all files", (boolean)measurement.getPredictionHdrFile().exists());
    }

    public static void assertMeasurementHasAllFiles_noRaw(Measurement measurement) {
        MatcherAssert.assertThat((String)"measurement has xml file", (boolean)measurement.getXml().exists());
        MatcherAssert.assertThat((String)"measurement has thumbnail file", (boolean)measurement.getThumbnailFile().exists());
        MatcherAssert.assertThat((String)"measurement has all files", (boolean)measurement.hasReferences());
        MatcherAssert.assertThat((String)"measurement has all files", (boolean)measurement.getPredictionRawFile().exists());
        MatcherAssert.assertThat((String)"measurement has all files", (boolean)measurement.getPredictionHdrFile().exists());
    }

    public static void assertMeasurementsHasCorrectPixelsAndFrames(Group group, PixelWidth pixelWidth, FrameCount frameCount) {
        for (Measurement measurement : new ArrayList<Measurement>(group.getChildList())) {
            AssertMeasurement.assertMeasurementHasCorrectPixelsAndFrames(measurement, pixelWidth, frameCount);
        }
    }

    public static void assertMeasurementHasCorrectPixelsAndFrames(Measurement measurement, PixelWidth pixelWidth, FrameCount frameCount) {
        RawFile rawFile = measurement.rawFile();
        String string = measurement.getName() + "(" + measurement.getUid() + ") hdr file ";
        MatcherAssert.assertThat((String)(string + "pixels"), (Object)rawFile.header().pixelWidth(), (Matcher)CoreMatchers.equalTo((Object)pixelWidth));
        MatcherAssert.assertThat((String)(string + "frames"), (Object)rawFile.header().frameCount(), (Matcher)CoreMatchers.equalTo((Object)frameCount));
    }

    public static void assertMeasurementsHasCorrectMetadataPixelsAndFrames(Group group, PixelWidth pixelWidth, FrameCount frameCount) {
        for (Measurement measurement : new ArrayList<Measurement>(group.getChildList())) {
            AssertMeasurement.assertMeasurementHasCorrectMetadataPixelsAndFrames(measurement, pixelWidth, frameCount);
        }
    }

    private static void assertMeasurementHasCorrectMetadataPixelsAndFrames(Measurement measurement, PixelWidth pixelWidth, FrameCount frameCount) {
        String string = measurement.getMetaValue("PixelsPerLine");
        String string2 = measurement.getMetaValue("Frames");
        MatcherAssert.assertThat((String)(measurement.getUid() + " metadata pixels"), (Object)Integer.valueOf(string), (Matcher)CoreMatchers.equalTo((Object)pixelWidth.value));
        MatcherAssert.assertThat((String)(measurement.getUid() + " metadata frames"), (Object)Integer.valueOf(string2), (Matcher)CoreMatchers.equalTo((Object)frameCount.value));
    }

    public static void assertMeasurementsHasPixelsAndFrames(Group group) {
        for (Measurement measurement : new ArrayList<Measurement>(group.getChildList())) {
            AssertMeasurement.assertMeasurementHasPixelsAndFrames(measurement);
        }
    }

    private static void assertMeasurementHasPixelsAndFrames(Measurement measurement) {
        RawFile rawFile = measurement.rawFile();
        MatcherAssert.assertThat((String)(measurement.getUid() + " has header file pixels"), (rawFile.header().pixelWidth().value > 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)(measurement.getUid() + " has header file frames"), (rawFile.header().frameCount().value > 0 ? 1 : 0) != 0);
    }

    public static void assertMeasurementsHasWhiteAndDarkReference(Group group) {
        for (Measurement measurement : new ArrayList<Measurement>(group.getChildList())) {
            AssertMeasurement.assertMeasurementHasHasWhiteAndDarkReference(measurement);
        }
    }

    public static void assertMeasurementHasHasWhiteAndDarkReference(Measurement measurement) {
        MatcherAssert.assertThat((String)("measurement " + measurement.toString() + " has references"), (boolean)measurement.hasReferences());
    }

    public static void assertMeasurementsHasNoReferences(Group group) {
        for (Measurement measurement : new ArrayList<Measurement>(group.getChildList())) {
            AssertMeasurement.assertMeasurementHasHasNoReference(measurement);
        }
    }

    private static void assertMeasurementHasHasNoReference(Measurement measurement) {
        MatcherAssert.assertThat((String)("measurement " + measurement.toString() + " has no references"), (!measurement.hasReferences() ? 1 : 0) != 0);
    }

    public static void assertOneSampleInEveryMeasurementWithData(Group group) {
        for (Measurement measurement : new ArrayList<Measurement>(group.getChildList())) {
            if (!measurement.hasData()) continue;
            AssertMeasurement.assertOneSampleInMeasurement(measurement);
        }
    }

    public static void assertOneSampleInMeasurement(Measurement measurement) {
        MatcherAssert.assertThat((String)"measurement has one sample", (Object)measurement.getChildList().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        BasicSample basicSample = measurement.getChildList().get(0);
        MatcherAssert.assertThat((String)"sample has name", (Object)basicSample.getName(), (Matcher)CoreMatchers.notNullValue());
    }

    public static void assertMeasurementsHasRawData(Group group) {
        for (Measurement measurement : new ArrayList<Measurement>(group.getChildList())) {
            MatcherAssert.assertThat((String)"measurement has raw file", (boolean)measurement.hasData());
        }
    }

    public static void assertMeasurementsHasPredictedData(Group group) {
        for (Measurement measurement : new ArrayList<Measurement>(group.getChildList())) {
            MatcherAssert.assertThat((String)"measurement has result file", (boolean)measurement.getPredictionRawFile().exists());
            MatcherAssert.assertThat((String)"measurement has result header file", (boolean)measurement.getPredictionHdrFile().exists());
        }
    }

    public static void assertMeasurementsHasEqualSampleDescriptorValues(Measurement measurement, Measurement measurement2) {
        MatcherAssert.assertThat((String)"Number of samples does not agree", (Object)measurement.getSamples(1).size(), (Matcher)CoreMatchers.equalTo((Object)measurement2.getSamples(1).size()));
        AssertMeasurement.assertEqualSampleDescriptorValues(measurement.getRootSample(), measurement2.getRootSample());
    }

    private static void assertEqualSampleDescriptorValues(Sample sample, Sample sample2) {
        DescriptorHolder descriptorHolder = sample.getDescriptorHolder();
        DescriptorHolder descriptorHolder2 = sample2.getDescriptorHolder();
        for (Map.Entry<String, FunctionResult> entry : descriptorHolder.entrySet()) {
            FunctionResult functionResult = entry.getValue();
            FunctionResult functionResult2 = descriptorHolder2.getFunctionResult(entry.getKey());
            AbstractBreezeFunction abstractBreezeFunction = functionResult.getFunction();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Measurement ");
            stringBuilder.append(sample.measurement().getUid());
            stringBuilder.append(", Descriptor ");
            stringBuilder.append(abstractBreezeFunction.getName());
            stringBuilder.append(" (");
            stringBuilder.append(abstractBreezeFunction.getNodeString(functionResult.getNode(), 0, FunctionTreeNode.TextType.Normal));
            stringBuilder.append(")");
            AssertCloseTo.assertThatNumberIsCloseTo(stringBuilder.toString(), functionResult2.getValue(), functionResult.getValue(), 0.001);
        }
        for (int i = 0; i < sample.getChildCount(); ++i) {
            AssertMeasurement.assertEqualSampleDescriptorValues(sample.getChild(i), sample2.getChild(i));
        }
    }

    public static void assertMeasurements(Group group, PixelWidth pixelWidth, FrameCount frameCount) {
        AssertMeasurement.assertMeasurementsHasCorrectMetadataPixelsAndFrames(group, pixelWidth, frameCount);
        AssertMeasurement.assertMeasurementsHasCorrectPixelsAndFrames(group, pixelWidth, frameCount);
        AssertMeasurement.assertMeasurementsHasWhiteAndDarkReference(group);
        AssertMeasurement.assertOneSampleInEveryMeasurementWithData(group);
    }

    public static void assertRaw(Measurement measurement, Measurement measurement2) {
        AssertMeasurement.assertRaw(measurement.rawFile(), measurement2.rawFile());
    }

    public static void assertRaw(RawFile rawFile, RawFile rawFile2) {
        AssertFrame.closeTo(rawFile.readFrames(), rawFile2.readFrames());
    }

    public static void assertRaw(RawFile rawFile, RawFile rawFile2, double d) {
        AssertFrame.closeTo(rawFile.readFrames(), rawFile2.readFrames(), d);
    }
}

