/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.test.asserts;

import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;
import se.prediktera.map.common.error.Logg;

public class AssertSocket {
    private static final int SOCKET_TIMEOUT = 1000;

    public static void assertNoMoreDataOnSocket(Socket socket) throws Exception {
        socket.setSoTimeout(100);
        InputStream inputStream = socket.getInputStream();
        inputStream.skip(inputStream.available());
        Logg.trace((String)"assertNoMoreDataOnStream cleared input stream", (Object[])new Object[0]);
        try {
            MatcherAssert.assertThat((String)"no data should come on stream", (Object)inputStream.read(), (Matcher)CoreMatchers.equalTo((Object)-1));
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
    }

    public static void assertClientSocketGotLines(Socket socket, byte[][] byArray, int n) throws Exception {
        socket.setSoTimeout(1000);
        InputStream inputStream = socket.getInputStream();
        byte[] byArray2 = new byte[BufferedTcpStream.HEADERSIZE];
        byte[] byArray3 = new byte[n];
        for (byte[] byArray4 : byArray) {
            int n2;
            int n3 = -1;
            for (n2 = 0; (n3 = inputStream.read(byArray2, 0, byArray2.length)) < 0 && n2 < 50; ++n2) {
                ThreadUtil.sleep(10L);
            }
            MatcherAssert.assertThat((String)("should read " + byArray2.length + " bytes from stream"), (Object)n3, (Matcher)CoreMatchers.equalTo((Object)byArray2.length));
            BufferedTcpStream.TcpHeader tcpHeader = new BufferedTcpStream.TcpHeader(byArray2);
            MatcherAssert.assertThat((Object)((Object)tcpHeader.getType()), (Matcher)CoreMatchers.is((Object)((Object)BufferedTcpStream.HeaderType.RawPixelLine)));
            MatcherAssert.assertThat((Object)(tcpHeader.getInTime().getValue() != 0L ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)tcpHeader.getBodySize(), (Matcher)CoreMatchers.is((Object)n));
            n3 = -1;
            for (n2 = 0; (n3 = inputStream.read(byArray3, 0, n)) < 0 && n2 < 50; ++n2) {
                ThreadUtil.sleep(10L);
            }
            MatcherAssert.assertThat((String)("should read " + n + " bytes from stream"), (Object)n3, (Matcher)CoreMatchers.equalTo((Object)3));
            AssertSocket.assertBuffersEqual(byArray4, byArray3);
        }
    }

    public static void assertBuffersEqual(byte[] byArray, byte[] byArray2) {
        MatcherAssert.assertThat((Object)byArray.length, (Matcher)CoreMatchers.equalTo((Object)byArray2.length));
        for (int i = 0; i < byArray.length; ++i) {
            MatcherAssert.assertThat((Object)byArray[i], (Matcher)CoreMatchers.equalTo((Object)byArray2[i]));
        }
    }
}

