/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util;

import org.junit.Test;
import se.prediktera.breeze.backend.realtime.module.AbsorbanceRtModule;
import se.prediktera.breeze.common.util.AbsorbanceToReflectance;
import se.prediktera.breeze.common.util.test.asserts.AssertCloseTo;

public class AbsorbanceToReflectanceTest {
    @Test
    public void shouldConvertAbsorbanceToReflectance() {
        AbsorbanceToReflectance absorbanceToReflectance = new AbsorbanceToReflectance();
        AssertCloseTo.assertThatNumberIsCloseTo(absorbanceToReflectance.convert(10.0f), 0.0, 1.0E-4);
        AssertCloseTo.assertThatNumberIsCloseTo(absorbanceToReflectance.convert(0.0f), 1.0, 1.0E-4);
        AssertCloseTo.assertThatNumberIsCloseTo(absorbanceToReflectance.convert(-0.30103f), 2.0, 1.0E-4);
        AssertCloseTo.assertThatNumberIsCloseTo(absorbanceToReflectance.convert(-0.47712f), 3.0, 1.0E-4);
        AssertCloseTo.assertThatNumberIsCloseTo(absorbanceToReflectance.convert(-0.60206f), 4.0, 1.0E-4);
        AssertCloseTo.assertThatNumberIsCloseTo(absorbanceToReflectance.convert(-1.0f), 10.0, 1.0E-4);
    }

    @Test
    public void shouldConvertRefToAbsAndViceVersa() {
        AbsorbanceRtModule.ReflectanceToAbsorbance reflectanceToAbsorbance = new AbsorbanceRtModule.ReflectanceToAbsorbance();
        AbsorbanceToReflectance absorbanceToReflectance = new AbsorbanceToReflectance();
        for (float f = 0.1f; f < 10.0f; f += 0.1f) {
            AssertCloseTo.assertThatNumberIsCloseTo(absorbanceToReflectance.convert(reflectanceToAbsorbance.mlog10(f)), f, 1.0E-4);
        }
    }
}

