/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util;

import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.frame.ShortFrame;
import se.prediktera.breeze.common.util.AverageFrame;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.PixelWidth;

public class AverageFrameTest {
    @Test
    public void shouldBeSameAsOneFrame() {
        ArrayList<RawFrame> arrayList = new ArrayList<RawFrame>();
        arrayList.add(this.createFrame(new double[][]{{10.0, 11.0, 12.0}, {13.0, 14.0, 15.0}, {16.0, 17.0, 18.0}, {19.0, 20.0, 21.0}}));
        AverageFrame averageFrame = new AverageFrame(arrayList);
        MatcherAssert.assertThat((Object)Float.valueOf(averageFrame.getFrameValue(0, 0)), (Matcher)Matchers.is((Object)Float.valueOf(10.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(averageFrame.getFrameValue(1, 2)), (Matcher)Matchers.is((Object)Float.valueOf(17.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(averageFrame.getFrameValue(2, 3)), (Matcher)Matchers.is((Object)Float.valueOf(21.0f)));
    }

    @Test
    public void shouldThrowOnEmptyList() {
        try {
            new AverageFrame(new ArrayList<RawFrame>());
            Assert.fail((String)"should throw");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void shouldAverageThreeFrames() {
        ArrayList<RawFrame> arrayList = new ArrayList<RawFrame>();
        arrayList.add(this.createFrame(new double[][]{{10.0, 11.0, 12.0}, {13.0, 14.0, 15.0}, {16.0, 17.0, 18.0}, {19.0, 20.0, 21.0}}));
        arrayList.add(this.createFrame(new double[][]{{20.0, 22.0, 24.0}, {26.0, 28.0, 30.0}, {32.0, 34.0, 36.0}, {38.0, 40.0, 42.0}}));
        arrayList.add(this.createFrame(new double[][]{{30.0, 33.0, 36.0}, {39.0, 42.0, 45.0}, {48.0, 51.0, 54.0}, {57.0, 60.0, 63.0}}));
        AverageFrame averageFrame = new AverageFrame(arrayList);
        MatcherAssert.assertThat((Object)Float.valueOf(averageFrame.getFrameValue(0, 0)), (Matcher)Matchers.is((Object)Float.valueOf(20.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(averageFrame.getFrameValue(1, 2)), (Matcher)Matchers.is((Object)Float.valueOf(34.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(averageFrame.getFrameValue(2, 3)), (Matcher)Matchers.is((Object)Float.valueOf(42.0f)));
    }

    private ShortFrame createFrame(double[][] dArray) {
        ShortFrame shortFrame = new ShortFrame(new BandCount(dArray[0].length), new PixelWidth(dArray.length), BandNames.fromIndex(dArray[0].length));
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                shortFrame.setFrameValue(j, i, (float)dArray[i][j]);
            }
        }
        return shortFrame;
    }
}

