/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.main.IniManager;

public class BreezeProcess {
    static final File pidFile = Paths.get(IniManager.getPredikteraPath(), "Breeze", "breeze.pid").toFile();

    public static Optional<Long> getPid() {
        String string;
        if (!pidFile.exists()) {
            return Optional.empty();
        }
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(pidFile));){
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            return Optional.empty();
        }
        return Optional.of(Long.parseLong(string));
    }

    public static boolean isBreezeRunning() {
        Optional<Long> optional = BreezeProcess.getPid();
        if (optional.isEmpty()) {
            return false;
        }
        Boolean bl = ProcessHandle.of(optional.get()).map(ProcessHandle::isAlive).orElse(false);
        Logg.debug((String)("Breeze process " + String.valueOf(optional.get()) + " " + (bl != false ? "is running" : "is not running")), (Object[])new Object[0]);
        return bl;
    }

    public static void breezeExit() {
        FileUtils.deleteQuietly((File)pidFile);
    }

    public static void setBreezeRunning() {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        String string2 = string.split("@")[0];
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(pidFile));){
            bufferedWriter.write(string2);
        }
    }
}

