/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import se.prediktera.breeze.util.ClasspathResource;

public class ClasspathZipFile {
    private final String zipResourcePath;

    public ClasspathZipFile(String string) {
        this.zipResourcePath = string;
    }

    public void extractAll(Path path, boolean bl) {
        try (ZipInputStream zipInputStream = new ZipInputStream(new ClasspathResource(this.zipResourcePath).inputStream());){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                File file = new File(path.toFile(), zipEntry.getName());
                if (bl || !file.exists()) {
                    if (zipEntry.isDirectory()) {
                        file.mkdirs();
                    } else {
                        file.getParentFile().mkdirs();
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        IOUtils.copy((InputStream)zipInputStream, (OutputStream)fileOutputStream);
                        ((OutputStream)fileOutputStream).close();
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

