/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.common.util.MinMax;

public class MinMaxTest {
    @Test
    public void shouldHaveNullIfMissingValues() {
        MinMax minMax = new MinMax();
        MatcherAssert.assertThat((Object)minMax.min(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)minMax.max(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldTrackMinValue() {
        MinMax minMax = new MinMax();
        minMax.add(1.0f);
        minMax.add(2.0f);
        MatcherAssert.assertThat((Object)minMax.min(), (Matcher)CoreMatchers.is((Object)Float.valueOf(1.0f)));
    }

    @Test
    public void shouldTrackMaxValue() {
        MinMax minMax = new MinMax();
        minMax.add(1.0f);
        minMax.add(3.0f);
        MatcherAssert.assertThat((Object)minMax.max(), (Matcher)CoreMatchers.is((Object)Float.valueOf(3.0f)));
    }

    @Test
    public void shouldExtendByOtherMinMax() {
        MinMax minMax = new MinMax();
        minMax.add(1.0f);
        minMax.add(3.0f);
        MinMax minMax2 = new MinMax();
        minMax2.add(-1.0f);
        minMax2.add(5.0f);
        minMax.add(minMax2);
        MatcherAssert.assertThat((Object)minMax.min(), (Matcher)CoreMatchers.is((Object)Float.valueOf(-1.0f)));
        MatcherAssert.assertThat((Object)minMax.max(), (Matcher)CoreMatchers.is((Object)Float.valueOf(5.0f)));
    }

    @Test
    public void shouldNormaliseValue() {
        MatcherAssert.assertThat((Object)new MinMax(-5.0f, 5.0f).normalise(0.0f), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.5f)));
        MatcherAssert.assertThat((Object)new MinMax(0.0f, 10.0f).normalise(0.0f), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((Object)new MinMax(0.0f, 10.0f).normalise(10.0f), (Matcher)CoreMatchers.is((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((Object)new MinMax(0.0f, 10.0f).normalise(5.0f), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.5f)));
    }

    @Test
    public void shouldReturnNullOnNormaliseWithoutMinMax() {
        MatcherAssert.assertThat((Object)new MinMax().normalise(0.0f), (Matcher)CoreMatchers.nullValue());
    }
}

