/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import se.prediktera.breeze.frontend.common.util.BreezeUserManager;

public class ModelLogHelper {
    public static void Log(File file, String string, Action action) {
        ModelLogHelper.Log(file, string, action, -1);
    }

    public static void Log(File file, String string, Action action, int n) {
        LogFileData logFileData;
        Object object;
        File file2 = new File(file, "log.yaml");
        if (file2.exists()) {
            object = new Yaml((BaseConstructor)new Constructor(LogFileData.class, new LoaderOptions()));
            logFileData = (LogFileData)object.load(Files.readString(file2.toPath()));
        } else {
            logFileData = new LogFileData();
        }
        if (logFileData.metadata == null) {
            logFileData.metadata = new LogMetaData();
        }
        if (logFileData.entries == null) {
            logFileData.entries = new ArrayList<LogEntry>(1);
        }
        if (action == Action.ARCHIVE) {
            logFileData.metadata.restoredFromHistoricVersion = null;
        } else if (action == Action.REVERT) {
            logFileData.metadata.restoredFromHistoricVersion = n;
        }
        object = new LogEntry();
        object.timeStamp = Instant.now().getEpochSecond();
        object.username = BreezeUserManager.getBreezeUser().getUsername();
        object.message = string;
        object.action = action;
        logFileData.entries.add((LogEntry)object);
        try (FileWriter fileWriter = new FileWriter(file2);){
            DumperOptions dumperOptions = new DumperOptions();
            Representer representer = new Representer(dumperOptions);
            representer.addClassTag(LogFileData.class, Tag.MAP);
            Yaml yaml = new Yaml(representer, dumperOptions);
            yaml.dump((Object)logFileData, (Writer)fileWriter);
        }
    }

    public static LogFileData getLogFileData(File file) {
        File file2 = new File(file, "log.yaml");
        if (!file2.exists()) {
            LogFileData logFileData = new LogFileData();
            logFileData.entries = new ArrayList<LogEntry>(0);
            return logFileData;
        }
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(LogFileData.class, new LoaderOptions()));
        LogFileData logFileData = (LogFileData)yaml.load(Files.readString(file2.toPath()));
        logFileData.entries.sort(Comparator.comparingLong(logEntry -> logEntry.timeStamp).reversed());
        return logFileData;
    }

    public static enum Action {
        REMOVE,
        ARCHIVE,
        REVERT,
        CREATED;

    }

    public static class LogFileData {
        public LogMetaData metadata;
        public List<LogEntry> entries;
    }

    public static class LogMetaData {
        public List<String> changes;
        public Integer restoredFromHistoricVersion;
    }

    public static class LogEntry {
        public long timeStamp;
        public String username;
        public String message;
        public Action action;
    }
}

