/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.UniqueUID;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.ModelInformation;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.util.ModelLogHelper;
import se.prediktera.breeze.util.ZipManager;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.ModelManager;

public class ModelVersionHelper {
    private static final Set<String> files = new HashSet<String>(Arrays.asList("model.map", "model.xml", "model.onnx"));
    private static final Pattern pattern = Pattern.compile("model_(?<serial>\\d+)\\.zip");

    public static void archiveModelFiles(Analyse analyse, BreezeProgressManager breezeProgressManager) {
        Object object;
        File file2 = analyse.getFolder();
        File file3 = new File(file2, "versions");
        int n = analyse.getVersionIndex();
        if (!file3.exists()) {
            if (!file3.mkdir()) {
                Logg.warn((String)"Failed to create versions folder", (Object[])new Object[0]);
            }
        } else {
            object = ModelVersionHelper.getVersionFiles(file3);
            if (object != null) {
                int n2 = Arrays.stream(object).mapToInt(ModelVersionHelper::getVersionFromFile).max().orElse(((File[])object).length);
                n = Math.max(n, n2) + 1;
            }
        }
        object = new ArrayList();
        ((ArrayList)object).addAll(Arrays.asList(Objects.requireNonNull(file2.listFiles((file, string) -> files.contains(string)))));
        if (((ArrayList)object).size() == 1) {
            ModelLogHelper.Log(file2, "New model created", ModelLogHelper.Action.CREATED, n);
            return;
        }
        File file4 = new File(file3, "model_" + n + ".zip");
        ZipManager zipManager = new ZipManager(file4);
        ((ArrayList)object).forEach(zipManager::addFile);
        zipManager.perform(breezeProgressManager);
        ModelLogHelper.Log(file2, "Model archived, version number: " + n, ModelLogHelper.Action.ARCHIVE, n);
        analyse.setVersionIndex(n);
        analyse.setVersion(UniqueUID.getUniqueId());
    }

    public static File createReducedModel(File file, BreezeProgressManager breezeProgressManager) {
        File file2 = new File(file, "model.map");
        File file3 = new File(file, "model_reduced.map");
        ArrayList arrayList = new ArrayList();
        ModelManager.collectModels((ProgressManager)breezeProgressManager, (File)file2, arrayList);
        if (arrayList.size() > 0) {
            AbstractModel abstractModel = (AbstractModel)arrayList.get(0);
            abstractModel.saveModel((ProgressManager)breezeProgressManager, null, file3, AbstractModel.SaveType.REDUCED);
        }
        return file3;
    }

    public static void unpackModelFiles(File file, BreezeProgress breezeProgress, int n) {
        File file2 = new File(file, "versions");
        if (!file2.exists()) {
            return;
        }
        File file3 = new File(file2, "model_" + n + ".zip");
        if (!file3.exists()) {
            throw new ErrorHandler.WarningMessageException("Model archive file not found");
        }
        ZipManager zipManager = new ZipManager(file3);
        zipManager.extractAll(breezeProgress, file.toPath(), true);
        ToastHandler.getInstance().showToast("Model reverted to version " + n);
        ModelLogHelper.Log(file, "Reverted to previous model version: " + n, ModelLogHelper.Action.REVERT, n);
    }

    public static String compareVersions(File file, int n, int n2) {
        String string;
        File file2 = new File(file, "versions");
        if (!file2.exists()) {
            return "No changes";
        }
        Analyse analyse = ModelVersionHelper.getAnalysisFromVersion(file, n);
        Analyse analyse2 = ModelVersionHelper.getAnalysisFromVersion(file, n2);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!analyse.getModelMethod().getMethod().equals(analyse2.getModelMethod().getMethod())) {
            arrayList.add("Method");
        }
        if (!analyse.getTopRuntimeMLResults().equals(analyse2.getTopRuntimeMLResults())) {
            arrayList.add("ML training results");
        }
        ModelInformation modelInformation = analyse.getModelInformation();
        ModelInformation modelInformation2 = analyse2.getModelInformation();
        if (modelInformation != null && !(string = modelInformation.getDiff(modelInformation2)).isEmpty()) {
            arrayList.add(string);
        }
        return arrayList.isEmpty() ? "" : String.join((CharSequence)",", arrayList);
    }

    public static Analyse getAnalysisFromVersion(File file, int n) {
        Analyse analyse;
        File file2 = ModelVersionHelper.getAvailableVersions(file, false).stream().filter(versionFile -> versionFile.version == n).map(VersionFile::getModelZipFile).findFirst().orElse(file);
        if (file2 == file) {
            analyse = new Analyse(file);
            analyse.getEntryData().setName("Current");
        } else {
            ZipManager zipManager = new ZipManager(file2);
            File file3 = zipManager.extractSpecificFile("model.xml");
            try {
                Files.move(file3.toPath(), file3.getParentFile().toPath().resolve("model.xml"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            analyse = new Analyse(file3.getParentFile());
            analyse.getEntryData().setName("Version " + n);
        }
        return analyse;
    }

    public static void deleteModelArchive(File file) {
        ModelVersionHelper.deleteModelArchive(file, false);
    }

    public static void deleteModelArchive(File file, boolean bl) {
        if (!file.delete()) {
            Logg.warn((String)"Error deleting file", (Object[])new Object[0]);
        }
        if (bl) {
            int n = ModelVersionHelper.getVersionFromFile(file);
            ModelLogHelper.Log(file.getParentFile().getParentFile(), "Removed previous model version: " + n, ModelLogHelper.Action.REMOVE);
        }
    }

    private static File[] getVersionFiles(File file2) {
        return file2.listFiles((file, string) -> pattern.matcher(string).matches());
    }

    public static List<VersionFile> getAvailableVersions(File file, boolean bl) {
        File file2 = new File(file, "versions");
        if (!file2.exists()) {
            return new ArrayList<VersionFile>(List.of(new VersionFile(file, -1, "No changes", "")));
        }
        ArrayList<File> arrayList = new ArrayList<File>(List.of(ModelVersionHelper.getVersionFiles(file2)));
        arrayList.add(file);
        ArrayList<VersionFile> arrayList2 = new ArrayList<VersionFile>(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            File file3 = arrayList.get(i);
            int n = ModelVersionHelper.getVersionFromFile(file3);
            String string = "No changes";
            if (bl && i - 1 >= 0) {
                int n2 = ModelVersionHelper.getVersionFromFile(arrayList.get(i - 1));
                string = ModelVersionHelper.compareVersions(file, n, n2);
            }
            long l = file3.isDirectory() && file3.listFiles() != null ? Arrays.stream(Objects.requireNonNull(file3.listFiles())).filter(File::isFile).mapToLong(File::length).sum() : file3.length();
            arrayList2.add(new VersionFile(file3, n, string, FileUtils.byteCountToDisplaySize((long)l)));
        }
        arrayList2.sort(Comparator.comparing(versionFile -> versionFile.modelZipFile.lastModified()).reversed());
        return arrayList2;
    }

    private static int getVersionFromFile(File file) {
        Matcher matcher = pattern.matcher(file.getName());
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group("serial"));
        }
        return -1;
    }

    public static class VersionFile {
        private final File modelZipFile;
        private final int version;
        private final String changes;
        private final String fileSizeString;

        @Generated
        public VersionFile(File file, int n, String string, String string2) {
            this.modelZipFile = file;
            this.version = n;
            this.changes = string;
            this.fileSizeString = string2;
        }

        @Generated
        public File getModelZipFile() {
            return this.modelZipFile;
        }

        @Generated
        public int getVersion() {
            return this.version;
        }

        @Generated
        public String getChanges() {
            return this.changes;
        }

        @Generated
        public String getFileSizeString() {
            return this.fileSizeString;
        }

        @Generated
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof VersionFile)) {
                return false;
            }
            VersionFile versionFile = (VersionFile)object;
            if (!versionFile.canEqual(this)) {
                return false;
            }
            if (this.getVersion() != versionFile.getVersion()) {
                return false;
            }
            File file = this.getModelZipFile();
            File file2 = versionFile.getModelZipFile();
            if (file == null ? file2 != null : !((Object)file).equals(file2)) {
                return false;
            }
            String string = this.getChanges();
            String string2 = versionFile.getChanges();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            String string3 = this.getFileSizeString();
            String string4 = versionFile.getFileSizeString();
            return !(string3 == null ? string4 != null : !string3.equals(string4));
        }

        @Generated
        protected boolean canEqual(Object object) {
            return object instanceof VersionFile;
        }

        @Generated
        public int hashCode() {
            int n = 1;
            n = n * 59 + this.getVersion();
            File file = this.getModelZipFile();
            n = n * 59 + (file == null ? 43 : ((Object)file).hashCode());
            String string = this.getChanges();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            String string2 = this.getFileSizeString();
            n = n * 59 + (string2 == null ? 43 : string2.hashCode());
            return n;
        }

        @Generated
        public String toString() {
            return "ModelVersionHelper.VersionFile(modelZipFile=" + String.valueOf(this.getModelZipFile()) + ", version=" + this.getVersion() + ", changes=" + this.getChanges() + ", fileSizeString=" + this.getFileSizeString() + ")";
        }
    }
}

