/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import se.prediktera.breeze.common.util.IntHolder;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.util.RetryOnIOException;

public class RetryOnExceptionTest {
    @Test
    public void itShouldRunOnceOnSuccess() throws IOException {
        IntHolder intHolder = new IntHolder(0);
        new RetryOnIOException(() -> intHolder.add(1)).tryAndThrowLast(new Time.MilliSeconds(10L), new Time.MilliSeconds(1L));
        MatcherAssert.assertThat((String)"callback executed one time", (Object)intHolder.getValue(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void itShouldRetryWithinTimeoutByIntervalOnException() {
        IntHolder intHolder = new IntHolder(0);
        try {
            new RetryOnIOException(() -> {
                intHolder.add(1);
                throw new IOException();
            }).tryAndThrowLast(new Time.MilliSeconds(20L), new Time.MilliSeconds(2L));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        MatcherAssert.assertThat((String)("callback executed about 10 times, actual times: " + intHolder.getValue()), (intHolder.getValue() > 0 && intHolder.getValue() < 15 ? 1 : 0) != 0);
    }

    @Test
    public void itShouldRetryWithinDifferentTimeoutByIntervalOnException() {
        IntHolder intHolder = new IntHolder(0);
        try {
            new RetryOnIOException(() -> {
                intHolder.add(1);
                throw new IOException();
            }).tryAndThrowLast(new Time.MilliSeconds(10L), new Time.MilliSeconds(2L));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        MatcherAssert.assertThat((String)("callback executed about 10 times, actual times: " + intHolder.getValue()), (intHolder.getValue() > 0 && intHolder.getValue() < 10 ? 1 : 0) != 0);
    }

    @Test
    public void itShouldTimeoutAfterSpecificTime() {
        long l = System.currentTimeMillis();
        try {
            new RetryOnIOException(() -> {
                throw new IOException();
            }).tryAndThrowLast(new Time.MilliSeconds(10L), new Time.MilliSeconds(1L));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        MatcherAssert.assertThat((String)("time taken is about 10 ms, actual time: " + l3), (l3 > 0L && l3 < 50L ? 1 : 0) != 0);
    }

    @Test
    public void itShouldThrowLastExceptionOnTimeout() {
        try {
            new RetryOnIOException(() -> {
                throw new IOException("secret message");
            }).tryAndThrowLast(new Time.MilliSeconds(10L), new Time.MilliSeconds(1L));
            Assert.fail((String)"Should throw");
        }
        catch (Exception exception) {
            MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)"secret message"));
        }
    }
}

