/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util;

import java.io.IOException;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;

public class RetryOnIOException {
    private final IOExceptionAction action;

    public RetryOnIOException(IOExceptionAction iOExceptionAction) {
        this.action = iOExceptionAction;
    }

    public void tryAndThrowLast(Time time, Time time2) throws IOException {
        long l = System.currentTimeMillis();
        while (true) {
            try {
                this.action.doOrThrow();
                return;
            }
            catch (IOException iOException) {
                if (this.timeRanOut(l, time)) {
                    throw iOException;
                }
                ThreadUtil.sleep(time2);
                continue;
            }
            break;
        }
    }

    private boolean timeRanOut(long l, Time time) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        return l3 > time.ms;
    }

    public static interface IOExceptionAction {
        public void doOrThrow() throws IOException;
    }
}

