/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SortedFileList
implements Iterable<File> {
    private final File folder;
    private final FileFilter filter;

    public SortedFileList(File file2) {
        this(file2, file -> true);
    }

    public SortedFileList(File file, FileFilter fileFilter) {
        this.folder = file;
        this.filter = fileFilter;
    }

    @Override
    public Iterator<File> iterator() {
        return this.getFiles().iterator();
    }

    public List<File> getFiles() {
        if (this.folder.exists()) {
            List<File> list;
            block9: {
                Stream<Path> stream = Files.list(this.folder.toPath());
                try {
                    Stream<Path> stream2 = stream.sorted();
                    Stream<File> stream3 = stream2.map(Path::toFile);
                    Stream<File> stream4 = stream3.filter(file -> this.filter.accept((File)file));
                    list = stream4.collect(Collectors.toList());
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                }
                stream.close();
            }
            return list;
        }
        return new ArrayList<File>();
    }

    public static class SortedFolderList
    extends SortedFileList {
        public SortedFolderList(File file) {
            super(file, File::isDirectory);
        }
    }
}

