/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.common.util.Time;

public class TimeTest {
    @Test
    public void shouldCreateNiceCompactimeString() {
        MatcherAssert.assertThat((Object)new Time.MilliSeconds(100L).toCompactNiceString(), (Matcher)CoreMatchers.is((Object)"100ms"));
        MatcherAssert.assertThat((Object)new Time.MilliSeconds(1099L).toCompactNiceString(), (Matcher)CoreMatchers.is((Object)"1s:099ms"));
        MatcherAssert.assertThat((Object)new Time.MilliSeconds(1999L).toCompactNiceString(), (Matcher)CoreMatchers.is((Object)"1s:999ms"));
        MatcherAssert.assertThat((Object)new Time.MilliSeconds(5001L).toCompactNiceString(), (Matcher)CoreMatchers.is((Object)"5s"));
        MatcherAssert.assertThat((Object)new Time.Seconds(10.0).toCompactNiceString(), (Matcher)CoreMatchers.is((Object)"10s"));
        MatcherAssert.assertThat((Object)new Time.Seconds(65.0).toCompactNiceString(), (Matcher)CoreMatchers.is((Object)"1m:05s"));
        MatcherAssert.assertThat((Object)new Time.Seconds(100.0).toCompactNiceString(), (Matcher)CoreMatchers.is((Object)"1m:40s"));
        MatcherAssert.assertThat((Object)new Time.Minutes(20.0).toCompactNiceString(), (Matcher)CoreMatchers.is((Object)"20m"));
        MatcherAssert.assertThat((Object)new Time.Minutes(100.0).toCompactNiceString(), (Matcher)CoreMatchers.is((Object)"1h:40m"));
        MatcherAssert.assertThat((Object)new Time.Seconds(3661.0).toCompactNiceString(), (Matcher)CoreMatchers.is((Object)"1h:01m"));
        MatcherAssert.assertThat((Object)new Time.Hours(12.0).toCompactNiceString(), (Matcher)CoreMatchers.is((Object)"12h"));
        MatcherAssert.assertThat((Object)new Time.Hours(12.5).toCompactNiceString(), (Matcher)CoreMatchers.is((Object)"12h:30m"));
        MatcherAssert.assertThat((Object)new Time.Hours(12.1).toCompactNiceString(), (Matcher)CoreMatchers.is((Object)"12h:06m"));
        MatcherAssert.assertThat((Object)new Time.Days(5.0).toCompactNiceString(), (Matcher)CoreMatchers.is((Object)"5d"));
        MatcherAssert.assertThat((Object)new Time.Days(5.5).toCompactNiceString(), (Matcher)CoreMatchers.is((Object)"5d:12h"));
    }

    @Test
    public void maxTime() {
        MatcherAssert.assertThat((Object)Time.max(new Time.MilliSeconds(10L), new Time.MilliSeconds(5L)), (Matcher)CoreMatchers.is((Object)new Time.MilliSeconds(10L)));
        MatcherAssert.assertThat((Object)Time.max(new Time.MilliSeconds(5L), new Time.MilliSeconds(10L)), (Matcher)CoreMatchers.is((Object)new Time.MilliSeconds(10L)));
    }

    @Test
    public void toFps() {
        MatcherAssert.assertThat((Object)Float.valueOf(new Time.MilliSeconds(10L).toFps()), (Matcher)CoreMatchers.is((Object)Float.valueOf(100.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(new Time.Seconds(10.0).toFps()), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.1f)));
        MatcherAssert.assertThat((Object)Float.valueOf(new Time.MilliSeconds(0L).toFps()), (Matcher)CoreMatchers.is((Object)Float.valueOf(1000.0f)));
    }
}

