/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.util.UserFriendlyString;
import se.prediktera.map.common.error.ErrorHandler;

public class UserFriendlyExceptionString {
    private final Throwable exception;

    public UserFriendlyExceptionString(Throwable throwable) {
        this.exception = throwable;
    }

    public String getFirst(int n) {
        return new UserFriendlyString(this.toString()).getFirst(n);
    }

    public String getFirstLine() {
        String string;
        int n = (string = this.toString()).indexOf("\n");
        return string.substring(0, n >= 0 ? n : string.length());
    }

    public String toString() {
        if (this.sourceExceptionIsNPE(this.exception)) {
            return this.stackTraceString();
        }
        if (this.exception instanceof ErrorHandler.MessageException) {
            if (this.exception.getCause() != null && this.exception.getCause().getMessage() != null) {
                return this.exception.getMessage() + "\n\nCause: " + this.exception.getCause().getMessage();
            }
            return this.exception.getMessage();
        }
        if (this.exception.getClass().equals(RuntimeException.class)) {
            return this.exception.getMessage() != null ? this.exception.getMessage() : "Runtime exception without message";
        }
        return StringHelper.formatLabel(this.exception.getClass().getSimpleName()) + (String)(this.exception.getMessage() != null ? ": " + this.exception.getMessage() : "");
    }

    public String stackTraceString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.exception.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private boolean sourceExceptionIsNPE(Throwable throwable) {
        if (throwable.getCause() != null) {
            return this.sourceExceptionIsNPE(throwable.getCause());
        }
        return throwable instanceof NullPointerException;
    }
}

