/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.util.UserFriendlyExceptionString;

public class UserFriendlyExceptionStringTest {
    @Test
    public void testMessageEmpty() {
        MatcherAssert.assertThat((String)"Message is empty", (Object)new UserFriendlyExceptionString(new ArithmeticException("")).getFirst(300), (Matcher)CoreMatchers.is((Object)"Arithmetic Exception: "));
    }

    @Test
    public void testMessageNull() {
        MatcherAssert.assertThat((String)"Message is null", (Object)new UserFriendlyExceptionString(new ArithmeticException(null)).getFirst(300), (Matcher)CoreMatchers.is((Object)"Arithmetic Exception"));
    }

    @Test
    public void testMessageNormal() {
        MatcherAssert.assertThat((String)"Message is normal", (Object)new UserFriendlyExceptionString(new ArithmeticException("2 == 2 != 3")).getFirst(300), (Matcher)CoreMatchers.is((Object)"Arithmetic Exception: 2 == 2 != 3"));
    }

    @Test
    public void runtimeExceptionShouldNotBePrinted() {
        MatcherAssert.assertThat((String)"Message is normal", (Object)new UserFriendlyExceptionString(new RuntimeException("normal", null)).getFirst(300), (Matcher)CoreMatchers.is((Object)"normal"));
    }

    @Test
    public void testRuntimeExceptionWithoutMessage() {
        MatcherAssert.assertThat((String)"Message is null", (Object)new UserFriendlyExceptionString(new RuntimeException(null, null)).getFirst(300), (Matcher)CoreMatchers.is((Object)"Runtime exception without message"));
    }

    @Test
    public void testMessageToLong() {
        MatcherAssert.assertThat((String)"Message is to long", (Object)new UserFriendlyExceptionString(new ArithmeticException("message is to long")).getFirst(30), (Matcher)CoreMatchers.is((Object)"Arithmetic Exception: message ..."));
    }
}

