/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.swing.filechooser.FileTools;

public class ZipManager {
    private final List<EntryPath> files = new ArrayList<EntryPath>();
    private final File file;

    public ZipManager(File file) {
        this.file = file;
    }

    public boolean addFile(File file) {
        if (this.files.stream().anyMatch(entryPath -> entryPath.path().equals(file.getName()))) {
            return false;
        }
        this.files.add(new EntryPath(file, file.getName()));
        return true;
    }

    public boolean addFile(File file, String string) {
        return this.addFile(file, string, file.getName());
    }

    public boolean addFile(File file, String string, String string2) {
        return this.addFile(file, string, string2, false);
    }

    public boolean addFile(File file, String string, String string2, boolean bl) {
        String string3 = string + "/" + string2;
        boolean bl2 = false;
        if (bl) {
            bl2 = this.files.removeIf(entryPath -> entryPath.path().equals(string3));
        } else if (this.files.stream().anyMatch(entryPath -> entryPath.path().equals(string3))) {
            return false;
        }
        this.files.add(new EntryPath(file, string3));
        return bl2;
    }

    public void addFolder(File file, String string) {
        String string2 = (String)(string != null ? string + "/" : "") + file.getName();
        for (File file2 : Objects.requireNonNull(file.listFiles())) {
            if (file2.isDirectory()) {
                this.addFolder(file2, string2);
                continue;
            }
            this.addFile(file2, string2);
        }
    }

    public void perform(BreezeProgress breezeProgress) {
        this.perform(breezeProgress, 0);
    }

    public void perform(BreezeProgress breezeProgress, int n) {
        int n2 = breezeProgress.setGroupMaximumAndReset(this.files.size());
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)));){
            zipOutputStream.setLevel(n);
            byte[] byArray = new byte[0xA00000];
            for (EntryPath entryPath : this.files) {
                breezeProgress.setMaximumAndReset((int)(entryPath.file.length() / (long)byArray.length));
                zipOutputStream.putNextEntry(new ZipEntry(entryPath.path()));
                try (FileInputStream fileInputStream = new FileInputStream(entryPath.file());){
                    int n3;
                    while ((n3 = fileInputStream.read(byArray)) > 0) {
                        zipOutputStream.write(byArray, 0, n3);
                        breezeProgress.incStep();
                    }
                }
                breezeProgress.incStepGroup(n2);
                if (!breezeProgress.isAborted()) continue;
                break;
            }
        }
        catch (IOException iOException) {
            Logg.warn((String)"Error while adding to archive", (Object[])new Object[]{iOException});
        }
    }

    public File extractSpecificFile(String string) {
        File file = FileHelper.createTempFileInWorkspace(FileTools.getExtension((String)string));
        try (ZipFile zipFile = new ZipFile(this.file);){
            ZipEntry zipEntry = zipFile.getEntry(string);
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));){
                Files.copy(bufferedInputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return file;
    }

    public List<File> extractAll(BreezeProgress breezeProgress, Path path, boolean bl) {
        int n = breezeProgress.setGroupMaximumAndReset(this.getNumberOfFiles());
        ArrayList<File> arrayList = new ArrayList<File>();
        try (ZipFile zipFile = new ZipFile(this.file);){
            byte[] byArray = new byte[8192];
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                File file = new File(path.toFile(), zipEntry.getName());
                if (bl || !file.exists()) {
                    if (zipEntry.isDirectory()) {
                        file.mkdirs();
                    } else {
                        file.getParentFile().mkdirs();
                        breezeProgress.setMaximumAndReset((int)zipEntry.getSize());
                        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), byArray.length);){
                            int n2;
                            while ((n2 = bufferedInputStream.read(byArray)) > 0) {
                                bufferedOutputStream.write(byArray, 0, n2);
                                breezeProgress.incStep(n2);
                            }
                        }
                        catch (ZipException zipException) {
                            arrayList.add(file);
                        }
                    }
                }
                breezeProgress.incStepGroup(n);
            }
        }
        return arrayList;
    }

    public List<File> extractAllShowWarning(BreezeFrame breezeFrame, BreezeProgress breezeProgress, Path path, boolean bl, String string, int n) {
        ArrayList<File> arrayList = new ArrayList<File>();
        List<String> list = ZipManager.getValidFileEntries(this.file, string, n);
        if (!list.isEmpty()) {
            List<File> list2 = new ZipManager(this.file).extractAll(breezeProgress, path, bl);
            if (!list2.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("There was a problem extracting these files:");
                stringBuilder.append("\n");
                for (File file : list2) {
                    stringBuilder.append("\n");
                    stringBuilder.append(file);
                }
                BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.WARNING_OPTION, "Warning", stringBuilder.toString(), null, null);
            }
            for (String string2 : list) {
                File file;
                file = new File(path.toFile(), string2);
                if (!file.exists()) continue;
                arrayList.add(file);
            }
        }
        return arrayList;
    }

    private int getNumberOfFiles() {
        int n = 0;
        try (ZipFile zipFile = new ZipFile(this.file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ++n;
                enumeration.nextElement();
            }
        }
        return n;
    }

    public static List<String> getValidFileEntries(File file, String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                String string2 = zipEntry.getName();
                int n2 = string2.split("/").length;
                if (!string2.endsWith(string) || n2 != n) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public static List<String> getSubdirectoriesInFolder(File file, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.getName();
                if (!string2.startsWith(string + "/") || string2.length() <= (string + "/").length()) continue;
                int n = (string + "/").length();
                int n2 = string2.indexOf("/", n);
                if (n2 == -1) {
                    arrayList.add(string2.substring(n));
                    continue;
                }
                String string3 = string2.substring(n, n2);
                if (arrayList.contains(string3)) continue;
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    private record EntryPath(File file, String path) {
    }
}

