/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.appcenter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import se.prediktera.breeze.InitClass;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.util.thread.BreezeThread;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.util.appcenter.Device;
import se.prediktera.breeze.util.appcenter.ErrorAttachmentLog;
import se.prediktera.breeze.util.appcenter.Exception;
import se.prediktera.breeze.util.appcenter.Log;
import se.prediktera.breeze.util.appcenter.LogContainer;
import se.prediktera.breeze.util.appcenter.ManagedErrorLog;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.ErrorUploader;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.IniManager;

public class AppCenterUploader
implements ErrorUploader {
    public static final Gson customGson = new GsonBuilder().registerTypeHierarchyAdapter(byte[].class, (Object)new ByteArrayToBase64TypeAdapter()).setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").disableHtmlEscaping().create();
    private final int licenseId;
    private final String emailAddress;
    private final String licenseUac;
    private final CloseableHttpClient client;
    private final boolean shouldUploadErrors;
    private final UpdateHelper.UpdateVersion version;

    public AppCenterUploader(int n, String string, String string2) {
        this(n, string, string2, AppCenterUploader.createHttpClient(), se.prediktera.map.InitClass.isReleaseVersion(), InitClass.getBreezeVersion());
    }

    public AppCenterUploader(int n, String string, String string2, CloseableHttpClient closeableHttpClient, boolean bl, UpdateHelper.UpdateVersion updateVersion) {
        this.licenseId = n;
        this.emailAddress = string;
        this.client = closeableHttpClient;
        this.licenseUac = string2;
        this.shouldUploadErrors = bl;
        this.version = updateVersion;
    }

    private static CloseableHttpClient createHttpClient() {
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).build();
    }

    public void uploadThrowable(ErrorHandler.ProductType productType, String string, File file, Throwable throwable) {
        if (!this.shouldUploadErrors) {
            Logg.info((String)"Skipping error upload for development version", (Object[])new Object[0]);
            return;
        }
        Logg.info((String)"Uploading error to AppCenter", (Object[])new Object[0]);
        String string2 = this.createMetadataString(string);
        BreezeThread breezeThread = new BreezeThread("UploadAppCenterThread", () -> {
            try {
                this.uploadErrorReport((java.lang.Exception)throwable, string2, file, productType);
            }
            catch (Throwable throwable2) {
                Logg.error((String)"Exception occurred while uploading error", (Throwable)throwable2);
                Logg.error((String)"Exception that was reported when error happened was", (Throwable)throwable);
            }
        });
        breezeThread.start();
    }

    private void uploadErrorReport(java.lang.Exception exception, String string, File file, ErrorHandler.ProductType productType) {
        Object object;
        Object object2;
        HttpPost httpPost = new HttpPost("https://in.appcenter.ms/logs?Api-Version=1.0.0");
        httpPost.addHeader("Content-Type", "Application/json");
        if (productType == ErrorHandler.ProductType.BREEZE) {
            if (this.version.build == 0) {
                httpPost.addHeader("App-Secret", "26e7f2b9-5157-42bf-b09f-8570675a846e");
            } else {
                httpPost.addHeader("App-Secret", "25f1e94d-8f75-4f04-9529-37b163ac77b6");
            }
        } else {
            httpPost.addHeader("App-Secret", "7d2eea21-832f-4304-a4f8-3503649e3fae");
        }
        httpPost.addHeader("Install-ID", "00000000-0000-0000-0000-000000000000".substring(0, 36 - String.valueOf(this.licenseId).length()) + this.licenseId);
        int n = ZonedDateTime.now(ZoneId.systemDefault()).getOffset().getTotalSeconds() / 60;
        Device device = new Device().sdkName("appcenter.custom").sdkVersion("1.0.0").wrapperSdkName("custom.java").appNamespace(AppCenterUploader.getPackageName(productType)).appVersion(this.version.format(true)).appBuild("release-" + this.version.build).osName(SystemUtils.OS_NAME).osVersion(SystemUtils.OS_VERSION).locale("en-US").timeZoneOffset(n).model(StringUtils.capitalize((String)productType.toString()));
        LogContainer logContainer = new LogContainer();
        UUID uUID = UUID.randomUUID();
        Date date = new Date(Instant.now().toEpochMilli());
        Log log = new ManagedErrorLog().exception(new Exception(exception)).architecture(System.getProperty("os.arch")).appLaunchTimestamp(BreezeFrame.getInstance() == null ? null : new Date(BreezeFrame.getInstance().getLaunchDate().toInstant().toEpochMilli())).fatal(false).id(uUID).processName(productType == ErrorHandler.ProductType.BREEZE ? "Breeze.exe" : "Evince.exe").device(device).userId(this.emailAddress).timestamp(date).type("handledError");
        String string2 = productType == ErrorHandler.ProductType.BREEZE ? "Breeze" : "Evince";
        Path path = Paths.get(IniManager.getPredikteraPath(), string2).resolve("error.log");
        Path path2 = Paths.get(IniManager.getPredikteraPath(), string2).resolve("debug.log");
        try {
            logContainer.addLogsItem(new ErrorAttachmentLog().contentType("application/octet-stream").data(Files.readAllBytes(path)).fileName("Error.log").errorId(uUID).id(UUID.randomUUID()).timestamp(date).type("errorAttachment").device(device));
            logContainer.addLogsItem(new ErrorAttachmentLog().contentType("application/octet-stream").data(Files.readAllBytes(path2)).fileName("Debug.log").errorId(uUID).id(UUID.randomUUID()).timestamp(date).type("errorAttachment").device(device));
        }
        catch (IOException iOException) {
            Logg.warn((String)"Failed to read evince error log", (Object[])new Object[]{iOException});
        }
        if (productType == ErrorHandler.ProductType.BREEZE) {
            try {
                object2 = WorkspaceManager.getBreezeRuntimeLogFile().toPath();
                logContainer.addLogsItem(new ErrorAttachmentLog().contentType("application/octet-stream").data(Files.readAllBytes((Path)object2)).fileName("BreezeRuntime.log").errorId(uUID).id(UUID.randomUUID()).timestamp(date).type("errorAttachment").device(device));
            }
            catch (IOException iOException) {
                Logg.warn((String)"Failed to read Breeze Runtime log", (Object[])new Object[]{iOException});
            }
        }
        object2 = new ErrorAttachmentLog().data(string.getBytes()).contentType("text/plain").errorId(uUID).id(UUID.randomUUID()).timestamp(date).type("errorAttachment").device(device);
        logContainer.addLogsItem(log).addLogsItem((Log)object2);
        if (file != null) {
            try {
                object = new ErrorAttachmentLog().data(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]))).fileName("screenshot.png").contentType("image/png").errorId(uUID).id(UUID.randomUUID()).timestamp(date).device(device).type("errorAttachment");
                logContainer.addLogsItem((Log)object);
            }
            catch (IOException iOException) {
                Logg.warn((String)"Failed to attach screenshot to error report", (Object[])new Object[0]);
            }
        }
        try {
            httpPost.setEntity((HttpEntity)new StringEntity(customGson.toJson((Object)logContainer)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logg.error((String)"Error will serializing json data", (Throwable)unsupportedEncodingException);
        }
        try {
            object = this.client.execute((HttpUriRequest)httpPost);
            try {
                int n2 = object.getStatusLine().getStatusCode();
                if (n2 < 200 || n2 >= 300) {
                    Logg.warn((String)"Could not submit error report to AppCenter. StatusCode: {}, Response: \n{}", (Object[])new Object[]{n2, EntityUtils.toString((HttpEntity)object.getEntity())});
                }
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private String createMetadataString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Message: ").append(string);
        stringBuilder.append("\nJava version: ").append(System.getProperty("java.version"));
        Runtime runtime = Runtime.getRuntime();
        stringBuilder.append("\nTotal Memory: ").append(FileUtils.byteCountToDisplaySize((long)runtime.totalMemory()));
        stringBuilder.append("\nFree Memory: ").append(FileUtils.byteCountToDisplaySize((long)runtime.freeMemory()));
        stringBuilder.append("\nUAC: ").append(this.licenseUac);
        return stringBuilder.toString();
    }

    private static String getPackageName(ErrorHandler.ProductType productType) {
        HashMap<ErrorHandler.ProductType, String> hashMap = new HashMap<ErrorHandler.ProductType, String>();
        hashMap.put(ErrorHandler.ProductType.BREEZE, "se.prediktera.breeze");
        hashMap.put(ErrorHandler.ProductType.EVINCE, "se.prediktera.evince");
        return (String)hashMap.get(productType);
    }

    private static class ByteArrayToBase64TypeAdapter
    implements JsonSerializer<byte[]>,
    JsonDeserializer<byte[]> {
        private ByteArrayToBase64TypeAdapter() {
        }

        public byte[] deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return Base64.getDecoder().decode(jsonElement.getAsString());
        }

        public JsonElement serialize(byte[] byArray, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(Base64.getEncoder().encodeToString(byArray));
        }
    }
}

