/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.appcenter;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import se.prediktera.breeze.util.appcenter.StackFrame;

public class Exception {
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="stackTrace")
    private String stackTrace = null;
    @SerializedName(value="frames")
    private List<StackFrame> frames = null;
    @SerializedName(value="innerExceptions")
    private List<Exception> innerExceptions = null;
    @SerializedName(value="wrapperSdkName")
    private String wrapperSdkName = null;

    public Exception(java.lang.Exception exception) {
        this.setType(exception.getClass().getTypeName());
        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
            this.addFramesItem(new StackFrame(stackTraceElement));
        }
        this.setMessage(exception.getMessage());
    }

    public Exception type(String string) {
        this.type = string;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public Exception message(String string) {
        this.message = string;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public Exception stackTrace(String string) {
        this.stackTrace = string;
        return this;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String string) {
        this.stackTrace = string;
    }

    public Exception frames(List<StackFrame> list) {
        this.frames = list;
        return this;
    }

    public Exception addFramesItem(StackFrame stackFrame) {
        if (this.frames == null) {
            this.frames = new ArrayList<StackFrame>();
        }
        this.frames.add(stackFrame);
        return this;
    }

    public List<StackFrame> getFrames() {
        return this.frames;
    }

    public void setFrames(List<StackFrame> list) {
        this.frames = list;
    }

    public Exception innerExceptions(List<Exception> list) {
        this.innerExceptions = list;
        return this;
    }

    public Exception addInnerExceptionsItem(Exception exception) {
        if (this.innerExceptions == null) {
            this.innerExceptions = new ArrayList<Exception>();
        }
        this.innerExceptions.add(exception);
        return this;
    }

    public List<Exception> getInnerExceptions() {
        return this.innerExceptions;
    }

    public void setInnerExceptions(List<Exception> list) {
        this.innerExceptions = list;
    }

    public Exception wrapperSdkName(String string) {
        this.wrapperSdkName = string;
        return this;
    }

    public String getWrapperSdkName() {
        return this.wrapperSdkName;
    }

    public void setWrapperSdkName(String string) {
        this.wrapperSdkName = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Exception exception = (Exception)object;
        return Objects.equals(this.type, exception.type) && Objects.equals(this.message, exception.message) && Objects.equals(this.stackTrace, exception.stackTrace) && Objects.equals(this.frames, exception.frames) && Objects.equals(this.innerExceptions, exception.innerExceptions) && Objects.equals(this.wrapperSdkName, exception.wrapperSdkName);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.message, this.stackTrace, this.frames, this.innerExceptions, this.wrapperSdkName);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class Exception {\n");
        stringBuilder.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        stringBuilder.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        stringBuilder.append("    stackTrace: ").append(this.toIndentedString(this.stackTrace)).append("\n");
        stringBuilder.append("    frames: ").append(this.toIndentedString(this.frames)).append("\n");
        stringBuilder.append("    innerExceptions: ").append(this.toIndentedString(this.innerExceptions)).append("\n");
        stringBuilder.append("    wrapperSdkName: ").append(this.toIndentedString(this.wrapperSdkName)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

