/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.appcenter;

import java.util.Objects;

public class StackFrame {
    private String address = null;
    private String code = null;
    private String className = null;
    private String methodName = null;
    private Integer lineNumber = null;
    private String fileName = null;

    public StackFrame(StackTraceElement stackTraceElement) {
        this.className(stackTraceElement.getClassName());
        this.fileName(stackTraceElement.getFileName());
        this.lineNumber(stackTraceElement.getLineNumber());
        this.methodName(stackTraceElement.getMethodName());
    }

    public StackFrame address(String string) {
        this.address = string;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public StackFrame code(String string) {
        this.code = string;
        return this;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String string) {
        this.code = string;
    }

    public StackFrame className(String string) {
        this.className = string;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public StackFrame methodName(String string) {
        this.methodName = string;
        return this;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String string) {
        this.methodName = string;
    }

    public StackFrame lineNumber(Integer n) {
        this.lineNumber = n;
        return this;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(Integer n) {
        this.lineNumber = n;
    }

    public StackFrame fileName(String string) {
        this.fileName = string;
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StackFrame stackFrame = (StackFrame)object;
        return Objects.equals(this.address, stackFrame.address) && Objects.equals(this.code, stackFrame.code) && Objects.equals(this.className, stackFrame.className) && Objects.equals(this.methodName, stackFrame.methodName) && Objects.equals(this.lineNumber, stackFrame.lineNumber) && Objects.equals(this.fileName, stackFrame.fileName);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.code, this.className, this.methodName, this.lineNumber, this.fileName);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class StackFrame {\n");
        stringBuilder.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        stringBuilder.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        stringBuilder.append("    className: ").append(this.toIndentedString(this.className)).append("\n");
        stringBuilder.append("    methodName: ").append(this.toIndentedString(this.methodName)).append("\n");
        stringBuilder.append("    lineNumber: ").append(this.toIndentedString(this.lineNumber)).append("\n");
        stringBuilder.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

