/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.automation;

import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.util.automation.RippedSwingTestUtil;

public class GuiComponentFinder {
    public static final Time DEFAULT_AWAIT_TIMEOUT = Time.FifteenSeconds;

    public static <T extends Component> T awaitComponent(Container container, Class<T> clazz) {
        return GuiComponentFinder.awaitComponent(container, clazz, DEFAULT_AWAIT_TIMEOUT);
    }

    public static <T extends Component> T awaitComponent(Container container, Class<T> clazz, Time time) {
        return GuiComponentFinder.awaitComponent(container, clazz, time, "Timeout while waiting for component of class " + clazz.getSimpleName());
    }

    public static <T extends Component> T awaitComponent(Container container, Class<T> clazz, Time time, String string) {
        return (T)GuiComponentFinder.genericComponentWait(() -> GuiComponentFinder.getComponent(container, clazz), time, string);
    }

    public static <T extends Component> T getComponent(Container container, Class<T> clazz) {
        List<JComponent> list = RippedSwingTestUtil.getComponents(container, clazz);
        return (T)(list.size() > 0 ? (Component)list.get(0) : null);
    }

    public static <T extends Component> T awaitComponent(Container container, String string, Class<T> clazz) {
        return GuiComponentFinder.awaitComponent(container, string, clazz, DEFAULT_AWAIT_TIMEOUT);
    }

    public static <T extends Component> T awaitComponent(Container container, String string, Class<T> clazz, Time time) {
        return GuiComponentFinder.awaitComponent(container, string, clazz, time, "timeout waiting for component with name: " + string + " and class " + clazz.getSimpleName());
    }

    public static <T extends Component> T awaitComponent(Container container, String string, Class<T> clazz, Time time, String string2) {
        return (T)GuiComponentFinder.genericComponentWait(() -> GuiComponentFinder.getComponent(container, string, clazz), time, "Timeout while waiting for component of class " + clazz.getSimpleName() + " with name " + string);
    }

    public static <T extends Component> T awaitShownComponent(Container container, String string, Class<T> clazz, Time time) {
        return (T)GuiComponentFinder.genericComponentWait(() -> {
            Object t = GuiComponentFinder.getComponent(container, string, clazz);
            if (t != null && ((Component)t).isShowing()) {
                return t;
            }
            return null;
        }, time, "Timeout while waiting for SHOWN component of class " + clazz.getSimpleName() + " with name " + string);
    }

    public static <T extends Component> T getComponent(Container container, String string, Class<T> clazz) {
        ComponentFilter componentFilter = component -> {
            boolean bl = clazz.isInstance(component);
            return bl && string.equals(component.getName());
        };
        return GuiComponentFinder.getComponent(container, componentFilter, clazz);
    }

    public static <T extends Component> T awaitComponent(Container container, ComponentFilter componentFilter, Class<T> clazz) {
        return GuiComponentFinder.awaitComponent(container, componentFilter, clazz, DEFAULT_AWAIT_TIMEOUT);
    }

    public static <T extends Component> T awaitComponent(Container container, ComponentFilter componentFilter, Class<T> clazz, Time time) {
        return (T)GuiComponentFinder.genericComponentWait(() -> GuiComponentFinder.getComponent(container, componentFilter, clazz), time, "Timeout while waiting for component with custom filter");
    }

    public static <T extends Component> T getComponent(Container container, ComponentFilter componentFilter, Class<T> clazz) {
        for (Component component : container.getComponents()) {
            T t;
            if (componentFilter.filter(component)) {
                return (T)component;
            }
            if (!(component instanceof Container) || (t = GuiComponentFinder.getComponent((Container)component, componentFilter, clazz)) == null) continue;
            return t;
        }
        return null;
    }

    public static BreezeButton awaitButton(Container container, String string) {
        return GuiComponentFinder.awaitComponent(container, string, BreezeButton.class);
    }

    public static JButton awaitJButton(Container container, String string) {
        return GuiComponentFinder.awaitComponent(container, string, JButton.class);
    }

    public static boolean awaitComponentTreeContainsText(Container container, String ... stringArray) {
        return GuiComponentFinder.awaitComponentTreeContainsText(container, DEFAULT_AWAIT_TIMEOUT, stringArray);
    }

    public static boolean awaitComponentTreeContainsText(Container container, Time time, String ... stringArray) {
        GuiComponentFinder.genericComponentWait(() -> GuiComponentFinder.getComponentContainingText(container, stringArray), time, "Timeout while waiting for component contains text " + String.valueOf(stringArray));
        return true;
    }

    public static Component getComponentContainingText(Container container, String ... stringArray) {
        ComponentFilter componentFilter = component -> {
            if (component instanceof JLabel) {
                return GuiComponentFinder.labelContainsText((JLabel)component, stringArray);
            }
            if (component instanceof JTextComponent) {
                return GuiComponentFinder.textComponentContainsText((JTextComponent)component, stringArray);
            }
            return false;
        };
        return GuiComponentFinder.getComponent(container, componentFilter, Component.class);
    }

    public static boolean labelContainsText(JLabel jLabel, String ... stringArray) {
        String string = jLabel.getText();
        if (string == null) {
            return false;
        }
        return GuiComponentFinder.stringContainsAllStrings(string, stringArray);
    }

    public static boolean textComponentContainsText(JTextComponent jTextComponent, String ... stringArray) {
        String string = jTextComponent.getText();
        if (string == null) {
            return false;
        }
        return GuiComponentFinder.stringContainsAllStrings(string, stringArray);
    }

    private static boolean stringContainsAllStrings(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (string.contains(string2)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Component> T genericComponentWait(FindComponentCallback<T> findComponentCallback, Time time, String string) {
        GuiComponentFinder.waitForGuiState(() -> {
            Object t = findComponentCallback.callback();
            return t != null;
        }, time, string);
        return findComponentCallback.callback();
    }

    public static void waitForGuiState(GuiStateCallback guiStateCallback) {
        GuiComponentFinder.waitForGuiState(guiStateCallback, "timeout waiting for custom gui state callback");
    }

    public static void waitForGuiState(GuiStateCallback guiStateCallback, String string) {
        GuiComponentFinder.waitForGuiState(guiStateCallback, DEFAULT_AWAIT_TIMEOUT, string);
    }

    public static void waitForGuiState(GuiStateCallback guiStateCallback, Time time) {
        GuiComponentFinder.waitForGuiState(guiStateCallback, time, "timeout waiting for custom gui state callback");
    }

    public static void waitForGuiState(GuiStateCallback guiStateCallback, Time time, String string) {
        ThreadUtil.awaitOrThrow(() -> guiStateCallback.guiIsInState(), time, string);
    }

    public static interface FindComponentCallback<T extends Component> {
        public T callback();
    }

    public static interface ComponentFilter {
        public boolean filter(Component var1);
    }

    public static interface GuiStateCallback {
        public boolean guiIsInState();
    }
}

