/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.automation;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;

public class GuiComponentTreePrinter {
    public static void debugPrintAwtTree(Container container) {
        System.out.println("----");
        GuiComponentTreePrinter.debugPrintAwtTree(container, 0);
        System.out.println("----");
    }

    public static void debugPrintAwtTree(Container container, int n) {
        String string = GuiComponentTreePrinter.indentString(' ', n);
        System.out.print(string);
        GuiComponentTreePrinter.debugPrintComponent(container);
        for (Component component : container.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            GuiComponentTreePrinter.debugPrintAwtTree((JComponent)component, n + 1);
        }
    }

    private static void debugPrintComponent(Container container) {
        JComponent jComponent;
        String string = container.getClass().getSimpleName();
        if (string.trim().equals("")) {
            string = container.getClass().getName();
        }
        System.out.print(string);
        if (container.getName() != null) {
            System.out.print(":" + container.getName());
        }
        if (container instanceof JLabel) {
            jComponent = (JLabel)container;
            System.out.print(" - text: '" + ((JLabel)jComponent).getText() + "'");
        }
        if (container instanceof JTextComponent) {
            jComponent = (JTextComponent)container;
            System.out.print(" - text: '" + ((JTextComponent)jComponent).getText() + "'");
        }
        System.out.println("");
    }

    private static String indentString(char c, int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append(String.valueOf(c).repeat(Math.max(0, n * 4)));
        return stringBuilder.toString();
    }
}

