/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.automation;

import java.awt.AWTException;
import java.awt.Container;
import java.awt.Point;
import java.awt.Robot;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.BoolHolder;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.cache.StudyList;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.PostProcessingPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeButtonInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeDescriptionButton;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeList;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinnerInputPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.BreezeTree;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeTogglePanel;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewList;
import se.prediktera.breeze.frontend.main.MainPanel;
import se.prediktera.breeze.util.automation.GuiComponentFinder;
import se.prediktera.map.common.NiceDataFormat;

public class GuiNavigationHelper {
    public static void awaitAndClickDialogOk(Container container) {
        GuiNavigationHelper.awaitAndClickDialog(container, "ok", GuiComponentFinder.DEFAULT_AWAIT_TIMEOUT);
    }

    public static void awaitAndClickDialogCancel(Container container) {
        GuiNavigationHelper.awaitAndClickDialog(container, "cancel", GuiComponentFinder.DEFAULT_AWAIT_TIMEOUT);
    }

    public static void awaitAndClickDialog(Container container, String string, Time time) {
        BreezeButton breezeButton = GuiComponentFinder.awaitComponent(container, string, BreezeButton.class, time);
        try {
            SwingUtilities.invokeAndWait(breezeButton::doClick);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void mainScreenGotoStudies(BreezeFrame breezeFrame) {
        GuiNavigationHelper.mainScreenGoto(breezeFrame, BreezeType.Project);
    }

    public static void mainScreenGotoModels(BreezeFrame breezeFrame) {
        BreezeMasterCache.clearInstance();
        GuiNavigationHelper.mainScreenGoto(breezeFrame, BreezeType.Analyse);
    }

    public static void mainScreenGotoModelsChooseStudyContext(BreezeFrame breezeFrame) {
        MainPanel mainPanel = GuiComponentFinder.awaitComponent(breezeFrame, MainPanel.class);
        mainPanel.chooseStudyContextBeforeOpen(BreezeType.Analyse);
    }

    public static void mainScreenGotoPlays(BreezeFrame breezeFrame) {
        GuiNavigationHelper.mainScreenGoto(breezeFrame, BreezeType.Workflow);
    }

    public static void mainScreenGotoPlaysChooseStudyContext(BreezeFrame breezeFrame) {
        MainPanel mainPanel = GuiComponentFinder.awaitComponent(breezeFrame, MainPanel.class);
        mainPanel.chooseStudyContextBeforeOpen(BreezeType.Workflow);
    }

    public static void mainScreenGotoSettings(BreezeFrame breezeFrame) {
        GuiNavigationHelper.mainScreenGoto(breezeFrame, BreezeType.Settings);
    }

    public static void mainScreenGotoConnect(BreezeFrame breezeFrame) {
        GuiNavigationHelper.mainScreenGoto(breezeFrame, BreezeType.Connect);
    }

    public static void mainScreenGoto(BreezeFrame breezeFrame, BreezeType breezeType) {
        MainPanel mainPanel = GuiComponentFinder.awaitComponent(breezeFrame, MainPanel.class);
        mainPanel.openPanel(breezeType, GuiNavigationHelper.getDefaultContext(), null);
    }

    private static Workflow getDefaultContext() {
        try {
            StudyList studyList;
            if (BreezeMasterCache.isInstanceMasterCache() && (studyList = BreezeMasterCache.getInstance().getStudyList()).size() > 0) {
                return (Workflow)studyList.get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void awaitModelChooserSelectTabAndClickOk(BreezeFrame breezeFrame, String string) {
        GuiNavigationHelper.awaitModelChooserSelectTabAndClickOk(breezeFrame, string, null);
    }

    public static void awaitModelChooserSelectTabAndClickOk(BreezeFrame breezeFrame, String string, String string2) {
        GuiComponentFinder.awaitComponent((Container)breezeFrame, string, BreezeTogglePanel.TogglePanel.class).doClick();
        if (string2 != null) {
            GuiComponentFinder.awaitComponent(breezeFrame, BreezeTogglePanel.class).setSelectedType(string2);
        }
        GuiNavigationHelper.awaitAndClickDialogOk(breezeFrame);
    }

    public static void awaitAndClickButton(Container container, String string) {
        GuiNavigationHelper.awaitAndClickButton(container, string, GuiComponentFinder.DEFAULT_AWAIT_TIMEOUT);
    }

    public static void awaitAndClickButton(Container container, String string, Time time) {
        GuiNavigationHelper.doClick(GuiComponentFinder.awaitShownComponent(container, string, BreezeButton.class, time));
    }

    public static void awaitAndClickDescriptionButton(Container container, String string) {
        GuiNavigationHelper.doClick(GuiComponentFinder.awaitComponent(container, string, BreezeDescriptionButton.class));
    }

    public static void doClick(BreezeButtonInterface breezeButtonInterface) {
        if (breezeButtonInterface != null) {
            try {
                SwingUtilities.invokeAndWait(breezeButtonInterface::doClick);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static void doClick(JButton jButton) {
        if (jButton != null) {
            try {
                SwingUtilities.invokeAndWait(jButton::doClick);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static void awaitApplyChanges(BreezeMainPanel breezeMainPanel) {
        BoolHolder boolHolder = new BoolHolder(false);
        BreezeProgressDialog.onNextActionFinish(() -> boolHolder.setTrue());
        GuiNavigationHelper.awaitAndClickButton(breezeMainPanel, "applychanges");
        ThreadUtil.awaitOrThrow(() -> boolHolder.getValue(), GuiComponentFinder.DEFAULT_AWAIT_TIMEOUT, "waiting for apply changes to run");
    }

    public static void awaitEnabledButtonAndClickAwaitFinish(BreezeMainPanel breezeMainPanel, BreezeButton breezeButton) {
        GuiNavigationHelper.awaitEnabledButtonAndClickAwaitFinish(breezeMainPanel, breezeButton, GuiComponentFinder.DEFAULT_AWAIT_TIMEOUT);
    }

    public static void awaitEnabledButtonAndClickAwaitFinish(BreezeMainPanel breezeMainPanel, BreezeButton breezeButton, Time time) {
        GuiNavigationHelper.awaitEnabledButtonAndClick(breezeButton, time);
        GuiComponentFinder.waitForGuiState(() -> !breezeMainPanel.getFrame().hasPage(breezeMainPanel), time, "timeout waiting for panel (name = " + GuiNavigationHelper.getName(breezeMainPanel) + ") to finish");
    }

    public static void awaitEnabledButtonAndClick(BreezeButton breezeButton) {
        GuiNavigationHelper.awaitEnabledButtonAndClick(breezeButton, GuiComponentFinder.DEFAULT_AWAIT_TIMEOUT);
    }

    public static void awaitEnabledButtonAndClick(BreezeButton breezeButton, Time time) {
        GuiNavigationHelper.awaitEnabledButton(breezeButton, time);
        GuiNavigationHelper.doClick(breezeButton);
    }

    public static void awaitEnabledButton(JComponent jComponent, Time time) {
        GuiComponentFinder.waitForGuiState(jComponent::isEnabled, time, "timeout waiting for button (name = " + GuiNavigationHelper.getName(jComponent) + ") to enable again");
    }

    private static String getName(JComponent jComponent) {
        String string = jComponent.getName();
        String string2 = jComponent.getClass().getSimpleName();
        if (string != null && string.length() > 0) {
            return string + ":" + string2;
        }
        return string2;
    }

    public static void awaitEnabledButtonAndClick(JButton jButton) {
        GuiNavigationHelper.awaitEnabledButtonAndClick(jButton, GuiComponentFinder.DEFAULT_AWAIT_TIMEOUT);
    }

    public static void awaitEnabledButtonAndClick(JButton jButton, Time time) {
        GuiNavigationHelper.awaitEnabledButton(jButton, time);
        GuiNavigationHelper.doClick(jButton);
    }

    public static void clickComponent_Robot(JComponent jComponent, boolean bl) {
        SwingUtilities.invokeLater(() -> {
            try {
                Robot robot = new Robot();
                Point point = jComponent.getLocationOnScreen();
                robot.mouseMove(point.x + 5, point.y + 5);
                if (bl) {
                    robot.keyPress(17);
                }
                robot.mousePress(1024);
                robot.mouseRelease(1024);
                if (bl) {
                    robot.keyRelease(17);
                }
            }
            catch (AWTException aWTException) {
                throw new RuntimeException(aWTException);
            }
        });
    }

    public static AbstractViewPanel selectViewAndWait(EntryMainPanel entryMainPanel, String string) {
        ViewList viewList = GuiComponentFinder.awaitComponent((Container)entryMainPanel, "viewList", ViewList.class);
        int n = viewList.getIndexOf(string);
        if (n < 0) {
            throw new RuntimeException(String.format("No view found with name '%s' in panel '%s", string, entryMainPanel));
        }
        GuiComponentFinder.waitForGuiState(() -> {
            Object object = viewList.getList().getItemAt(n);
            try {
                viewList.setSelectedValue(object, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return object == entryMainPanel.getViewClass();
        }, "timeout waiting for view list to switch to view with name: " + string);
        return entryMainPanel.getViewClass().getPanel();
    }

    public static void awaitListAndSelect(Container container, String string, String string2) {
        BreezeList breezeList = GuiComponentFinder.awaitComponent(container, string, BreezeList.class);
        try {
            SwingUtilities.invokeAndWait(() -> breezeList.setSelectedIndex(breezeList.getIndexOf(string2)));
        }
        catch (InterruptedException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void awaitPostProcessingButtonAndSelect(Container container, String string) {
        PostProcessingPanel.PostProcessingButton postProcessingButton = GuiComponentFinder.awaitComponent(container, "pp" + string, PostProcessingPanel.PostProcessingButton.class);
        SwingUtilities.invokeAndWait(postProcessingButton::open);
    }

    public static void awaitAndSetTextFieldValue(Container container, String string, double d) {
        BreezeTextField breezeTextField = GuiComponentFinder.awaitComponent(container, string, BreezeTextField.class);
        breezeTextField.setTextAndTrigger(NiceDataFormat.toString((double)d));
    }

    public static void awaitAndSetTextFieldValue(Container container, String string, String string2) {
        BreezeTextField breezeTextField = GuiComponentFinder.awaitComponent(container, string, BreezeTextField.class);
        breezeTextField.setTextAndTrigger(string2);
    }

    public static void awaitAndSetEditableComboBoxValue(Container container, String string, Object object) {
        JComboBox jComboBox = GuiComponentFinder.awaitComponent(container, string, JComboBox.class);
        jComboBox.getEditor().setItem(object);
    }

    public static void awaitAndSetInputFieldValueAndClickEnter(Container container, String string, double d) {
        BreezeInputField breezeInputField = GuiComponentFinder.awaitComponent(container, string, BreezeInputField.class);
        try {
            SwingUtilities.invokeAndWait(() -> breezeInputField.setTextAndTrigger(NiceDataFormat.toString((double)d)));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void awaitAndSetSpinnerInputFieldValueAndClickEnter(Container container, String string, double d) {
        BreezeSpinnerInputPanel breezeSpinnerInputPanel = GuiComponentFinder.awaitComponent(container, string, BreezeSpinnerInputPanel.class);
        try {
            SwingUtilities.invokeAndWait(() -> breezeSpinnerInputPanel.setValue(d));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void awaitAndSetInputFieldValueAndClickEnter(Container container, String string, String string2) {
        BreezeInputField breezeInputField = GuiComponentFinder.awaitComponent(container, string, BreezeInputField.class);
        try {
            SwingUtilities.invokeAndWait(() -> breezeInputField.setTextAndTrigger(string2));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void awaitAndSelectValue(Container container, String string, Object object) {
        JComboBox jComboBox = GuiComponentFinder.awaitComponent(container, string, JComboBox.class);
        GuiNavigationHelper.selectValueInComboBox(jComboBox, object);
    }

    public static void selectValueInComboBox(JComboBox jComboBox, Object object) {
        GuiComponentFinder.waitForGuiState(() -> GuiNavigationHelper.setComboBoxItemByText(jComboBox, object.toString()), "timeout waiting for selecting item + " + String.valueOf(object) + " in combobox");
    }

    private static boolean setComboBoxItemByText(JComboBox jComboBox, String string) {
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            if (!jComboBox.getItemAt(i).toString().equals(string)) continue;
            int n = i;
            try {
                SwingUtilities.invokeAndWait(() -> jComboBox.setSelectedIndex(n));
            }
            catch (InterruptedException | InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
            return true;
        }
        return false;
    }

    public static void awaitAndSelectTree(Container container, String string, String string2) {
        GuiNavigationHelper.selectTree(GuiComponentFinder.awaitComponent(container, string, BreezeTree.class), string2);
    }

    public static void selectEntry(EntryMainPanel entryMainPanel, String string) {
        GuiNavigationHelper.selectTree(entryMainPanel.getEntryList(), string);
    }

    private static void selectTree(BreezeTree breezeTree, String string) {
        breezeTree.setSelectedValueByName(string);
    }

    public static void awaitAndCheckBox(Container container, String string, boolean bl) {
        JCheckBox jCheckBox = GuiComponentFinder.awaitComponent(container, string, JCheckBox.class);
        jCheckBox.setSelected(bl);
    }

    public static void awaitAndComboBox(Container container, String string, Object object) {
        JComboBox jComboBox = GuiComponentFinder.awaitComponent(container, string, JComboBox.class);
        jComboBox.setSelectedItem(object);
    }

    public static void awaitAndRadioButton(Container container, String string, boolean bl) {
        JRadioButton jRadioButton = GuiComponentFinder.awaitComponent(container, string, JRadioButton.class);
        jRadioButton.setSelected(bl);
    }

    public static void awaitAndChangeSlider(Container container, String string, int n) {
        try {
            SwingUtilities.invokeAndWait(() -> {
                JSlider jSlider = GuiComponentFinder.awaitComponent(container, string, JSlider.class);
                jSlider.setValue(n);
            });
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void dragMouse_Robot(Robot robot, int n, int n2, int n3, int n4) {
        robot.mouseMove(n, n2);
        robot.mousePress(1024);
        ThreadUtil.sleep(50L);
        robot.mouseMove(n3, n4);
        robot.mouseRelease(1024);
        ThreadUtil.sleep(50L);
    }

    public static void awaitAndSetFileInFileChooser(FileChooserPanel fileChooserPanel, File file) {
        GuiNavigationHelper.awaitAndSetFileInFileChooser(fileChooserPanel, new File[]{file});
    }

    public static void awaitAndSetFileInFileChooser(FileChooserPanel fileChooserPanel, File[] fileArray) {
        try {
            SwingUtilities.invokeAndWait(() -> fileChooserPanel.setSelectedFiles(fileArray));
        }
        catch (InterruptedException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
        GuiComponentFinder.waitForGuiState(() -> {
            List<File> list = fileChooserPanel.getSelectedFiles();
            if (list.size() == fileArray.length) {
                for (File file : list) {
                    if (!fileArray[0].equals(file)) continue;
                    return true;
                }
            }
            return false;
        }, "timeout waiting for file selection panel to select file");
    }
}

