/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.automation;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import se.prediktera.breeze.util.automation.RippedSwingUtil;

public class RippedSwingTestUtil {
    public static void clickButton(AbstractButton abstractButton) {
        RippedSwingUtil.invokeAndWait(() -> abstractButton.doClick());
    }

    public static void setText(JTextField jTextField, String string) {
        RippedSwingUtil.invokeAndWait(() -> jTextField.setText(string));
    }

    public static JFrame getOnlyVisibleFrame() {
        JFrame jFrame = null;
        for (Window window : Window.getWindows()) {
            if (!(window instanceof JFrame) || !window.isShowing()) continue;
            if (jFrame != null) {
                throw new IllegalStateException("num frames > 1");
            }
            jFrame = (JFrame)window;
        }
        return jFrame;
    }

    public static JDialog getOnlyVisibleDialog(Window window) {
        JDialog jDialog = null;
        for (Window window2 : Window.getWindows()) {
            if (!(window2 instanceof JDialog) || !window2.isShowing() || ((JDialog)window2).getOwner() != window) continue;
            if (jDialog != null) {
                throw new IllegalStateException("num dialogs > 1");
            }
            jDialog = (JDialog)window2;
        }
        return jDialog;
    }

    public static JDialog getVisibleDialog(Window window, String string) {
        for (Window window2 : Window.getWindows()) {
            if (!(window2 instanceof JDialog) || !window2.isShowing() || ((JDialog)window2).getOwner() != window || !((JDialog)window2).getTitle().equals(string)) continue;
            return (JDialog)window2;
        }
        return null;
    }

    public static JMenuItem getMenuItem(JMenuBar jMenuBar, String string) {
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            JMenuItem jMenuItem = RippedSwingTestUtil.getMenuItem(jMenuBar.getMenu(i), string);
            if (jMenuItem == null) continue;
            return jMenuItem;
        }
        return null;
    }

    private static JMenuItem getMenuItem(JMenu jMenu, String string) {
        for (Component component : jMenu.getMenuComponents()) {
            if (component instanceof JMenu) {
                JMenuItem jMenuItem = RippedSwingTestUtil.getMenuItem((JMenu)component, string);
                if (jMenuItem == null) continue;
                return jMenuItem;
            }
            if (!(component instanceof JMenuItem) || !((JMenuItem)component).getText().equals(string)) continue;
            return (JMenuItem)component;
        }
        return null;
    }

    public static JButton getButton(Container container, String string) {
        return (JButton)RippedSwingTestUtil.getAbstractButton(container, string);
    }

    public static JCheckBox getCheckBox(Container container, String string) {
        return (JCheckBox)RippedSwingTestUtil.getAbstractButton(container, string);
    }

    public static JRadioButton getRadioButton(Container container, String string) {
        return (JRadioButton)RippedSwingTestUtil.getAbstractButton(container, string);
    }

    public static JMenuItem getMenuItem(Container container, String string) {
        return (JMenuItem)RippedSwingTestUtil.getAbstractButton(container, string);
    }

    private static AbstractButton getAbstractButton(Container container, String string) {
        for (Component component : container.getComponents()) {
            AbstractButton abstractButton;
            if (component instanceof AbstractButton && ((AbstractButton)component).getText() != null && ((AbstractButton)component).getText().equals(string)) {
                return (AbstractButton)component;
            }
            if (!(component instanceof JComponent) || (abstractButton = RippedSwingTestUtil.getAbstractButton((JComponent)component, string)) == null) continue;
            return abstractButton;
        }
        return null;
    }

    public static JTextField getTextFieldWithName(Container container, String string) {
        return (JTextField)RippedSwingTestUtil.getComponentWithName(container, string, JTextField.class);
    }

    public static JButton getButtonWithName(Container container, String string) {
        return (JButton)RippedSwingTestUtil.getComponentWithName(container, string, JButton.class);
    }

    public static JComponent getComponentWithName(Container container, String string, Class<?> clazz) {
        for (Component component : container.getComponents()) {
            JComponent jComponent;
            if (clazz.isInstance(component) && ((JComponent)component).getName() != null && ((JComponent)component).getName().equals(string)) {
                return (JComponent)component;
            }
            if (!(component instanceof JComponent) || (jComponent = RippedSwingTestUtil.getComponentWithName((JComponent)component, string, clazz)) == null) continue;
            return jComponent;
        }
        return null;
    }

    public static String getAllText(Container container) {
        StringBuilder stringBuilder = new StringBuilder();
        for (JComponent jComponent : RippedSwingTestUtil.getComponents(container, JTextComponent.class)) {
            stringBuilder.append(((JTextComponent)jComponent).getText()).append("");
        }
        for (JComponent jComponent : RippedSwingTestUtil.getComponents(container, JLabel.class)) {
            stringBuilder.append(((JLabel)jComponent).getText()).append("");
        }
        for (JComponent jComponent : RippedSwingTestUtil.getComponents(container, AbstractButton.class)) {
            stringBuilder.append(((AbstractButton)jComponent).getText()).append("");
        }
        return stringBuilder.toString();
    }

    public static JTextField getOnlyTextField(Container container) {
        return (JTextField)RippedSwingTestUtil.getOnlyComponent(container, JTextField.class);
    }

    public static JList<?> getOnlyList(Container container) {
        return (JList)RippedSwingTestUtil.getOnlyComponent(container, JList.class);
    }

    public static JButton getOnlyButton(Container container) {
        return (JButton)RippedSwingTestUtil.getOnlyComponent(container, JButton.class);
    }

    public static JPopupMenu getOnlyPopupMenu(Container container) {
        return (JPopupMenu)RippedSwingTestUtil.getOnlyComponent(container, JPopupMenu.class);
    }

    public static JSpinner getOnlySpinner(Container container) {
        return (JSpinner)RippedSwingTestUtil.getOnlyComponent(container, JSpinner.class);
    }

    public static JCheckBox getOnlyCheckBox(Container container) {
        return (JCheckBox)RippedSwingTestUtil.getOnlyComponent(container, JCheckBox.class);
    }

    public static JComboBox<?> getOnlyComboBox(Container container) {
        return RippedSwingTestUtil.getOnlyComboBox(container, false);
    }

    public static JComboBox<?> getOnlyComboBox(Container container, boolean bl) {
        return (JComboBox)RippedSwingTestUtil.getOnlyComponent(container, JComboBox.class, bl);
    }

    private static JComponent getOnlyComponent(Container container, Class<?> clazz) {
        return RippedSwingTestUtil.getOnlyComponent(container, clazz, false);
    }

    private static JComponent getOnlyComponent(Container container, Class<?> clazz, boolean bl) {
        List<JComponent> list = RippedSwingTestUtil.getComponents(container, clazz, bl);
        if (list.size() != 1) {
            throw new IllegalStateException("num " + (bl ? "visible " : "") + "compounds found " + list.size());
        }
        return list.get(0);
    }

    public static List<JComponent> getComponents(Container container, Class<?> clazz) {
        return RippedSwingTestUtil.getComponents(container, clazz, false);
    }

    public static List<JComponent> getComponents(Container container, Class<?> clazz, boolean bl) {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        for (Component component : container.getComponents()) {
            if (clazz.isInstance(component) && (!bl || component.isShowing())) {
                arrayList.add((JComponent)component);
                continue;
            }
            if (!(component instanceof JComponent)) continue;
            arrayList.addAll(RippedSwingTestUtil.getComponents((JComponent)component, clazz, bl));
        }
        return arrayList;
    }

    public static void clickList_Robot(JList<?> jList, int n) {
        RippedSwingTestUtil.clickList(jList, n, false);
    }

    public static void clickList(JList<?> jList, int n, boolean bl) {
        try {
            SwingUtilities.invokeAndWait(() -> {
                try {
                    Robot robot = new Robot(RippedSwingUtil.getGraphicsDevice(RippedSwingUtil.getScreen((Window)jList.getTopLevelAncestor())));
                    Point point = jList.getLocationOnScreen();
                    Point point2 = jList.indexToLocation(n);
                    robot.mouseMove(point.x + point2.x, point.y + point2.y);
                    robot.mouseMove(point.x + point2.x + 10, point.y + point2.y + 10);
                    if (bl) {
                        robot.keyPress(17);
                    }
                    robot.mousePress(1024);
                    robot.mouseRelease(1024);
                    if (bl) {
                        robot.keyRelease(17);
                    }
                }
                catch (AWTException aWTException) {
                    throw new RuntimeException(aWTException);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void moveToList(JList<?> jList, int n) {
        try {
            Robot robot = new Robot(RippedSwingUtil.getGraphicsDevice(RippedSwingUtil.getScreen((Window)jList.getTopLevelAncestor())));
            Point point = jList.getLocationOnScreen();
            Point point2 = jList.indexToLocation(n);
            robot.mouseMove(point.x + point2.x + 5, point.y + point2.y + 5);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void pressKey(Frame frame, int n, boolean bl, boolean bl2) {
        try {
            Robot robot = new Robot(RippedSwingUtil.getGraphicsDevice(RippedSwingUtil.getScreen(frame)));
            if (bl) {
                robot.keyPress(17);
            }
            if (bl2) {
                robot.keyPress(18);
            }
            robot.keyPress(n);
            robot.keyRelease(n);
            if (bl2) {
                robot.keyRelease(18);
            }
            if (bl) {
                robot.keyRelease(17);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void clickXButton(JComponent jComponent) {
        try {
            Robot robot = new Robot(RippedSwingUtil.getGraphicsDevice(RippedSwingUtil.getScreen((Window)jComponent.getTopLevelAncestor())));
            Point point = jComponent.getLocationOnScreen();
            robot.mouseMove(point.x + 5, point.y + 5);
            RippedSwingTestUtil.waitForGUI();
            robot.mousePress(1024);
            robot.mouseRelease(1024);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static JFileChooser getFileChooser() {
        for (Window window : Window.getWindows()) {
            if (!(window instanceof JDialog) || !window.isShowing() || !(((JDialog)window).getContentPane().getComponent(0) instanceof JFileChooser)) continue;
            return (JFileChooser)((JDialog)window).getContentPane().getComponent(0);
        }
        throw new IllegalStateException("no file chooser found!");
    }

    public static void waitForGUI() {
        for (int i = 0; i < 20; ++i) {
            RippedSwingUtil.waitForAWTEventThread(5L);
        }
    }
}

