/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.automation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import se.prediktera.map.common.error.Logg;

public class RippedSwingUtil {
    private static GraphicsEnvironment ge = null;
    private static GraphicsDevice[] gs = null;
    private static HashMap<Component, MouseListener[]> ml;
    private static HashMap<Component, MouseWheelListener[]> mw;
    private static HashMap<Component, MouseMotionListener[]> mm;

    public static int getNumMonitors() {
        if (gs == null) {
            return 0;
        }
        return gs.length;
    }

    public static Dimension getScreenSize() {
        return RippedSwingUtil.getScreenSize(0);
    }

    public static int getLargestScreen() {
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < RippedSwingUtil.getNumMonitors(); ++i) {
            Dimension dimension = RippedSwingUtil.getScreenSize(i);
            int n3 = dimension.width * dimension.height;
            if (n != -1 && n2 >= n3) continue;
            n = i;
            n2 = n3;
        }
        return n;
    }

    public static Dimension getScreenSize(int n) {
        if (gs == null) {
            return new Dimension(0, 0);
        }
        try {
            DisplayMode displayMode = gs[n].getDisplayMode();
            return new Dimension(displayMode.getWidth(), displayMode.getHeight());
        }
        catch (Exception exception) {
            Logg.error((String)("could not get screen size for screen: " + n), (Throwable)exception);
            return Toolkit.getDefaultToolkit().getScreenSize();
        }
    }

    public static Point getScreenLocation(int n) {
        if (gs == null) {
            return new Point(0, 0);
        }
        try {
            Rectangle rectangle = gs[n].getConfigurations()[0].getBounds();
            return new Point(rectangle.x, rectangle.y);
        }
        catch (Exception exception) {
            Logg.error((String)("could not get screen location for screen: " + n), (Throwable)exception);
            return new Point(0, 0);
        }
    }

    public static GraphicsDevice getGraphicsDevice(int n) {
        if (gs == null) {
            return null;
        }
        return gs[n];
    }

    public static int getScreen(Window window) {
        if (gs == null) {
            return 0;
        }
        try {
            int n = 0;
            for (GraphicsDevice graphicsDevice : gs) {
                if (graphicsDevice.getConfigurations()[0].getBounds().contains(window.getLocation())) {
                    return n;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return 0;
    }

    public static void centerWindowsOnScreen() {
        RippedSwingUtil.centerWindowsOnScreen(Window.getWindows());
    }

    public static void centerWindowsOnScreen(Window ... windowArray) {
        RippedSwingUtil.centerWindowsOnScreen(windowArray, RippedSwingUtil.getLargestScreen());
    }

    public static void centerWindowsOnScreen(Window[] windowArray, int n) {
        Serializable serializable2;
        int n2 = 0;
        int n3 = 0;
        for (Serializable serializable2 : windowArray) {
            if (!serializable2.isVisible()) continue;
            n2 += serializable2.getSize().width;
            n3 = Math.max(n3, serializable2.getSize().height);
        }
        Dimension dimension = RippedSwingUtil.getScreenSize(n);
        int n4 = Math.max(0, (dimension.width - n2) / 2);
        int n5 = Math.max(0, (dimension.height - n3) / 2);
        serializable2 = RippedSwingUtil.getScreenLocation(n);
        n2 = 0;
        for (Window window : windowArray) {
            if (!window.isVisible()) continue;
            window.setLocation(((Point)serializable2).x + n2 + n4, ((Point)serializable2).y + n5);
            n2 += window.getWidth();
        }
    }

    public static void centerOnScreen(Window window, int n) {
        Dimension dimension = RippedSwingUtil.getScreenSize(n);
        int n2 = Math.max(0, (dimension.width - window.getSize().width) / 2);
        int n3 = Math.max(0, (dimension.height - window.getSize().height) / 2);
        Point point = RippedSwingUtil.getScreenLocation(n);
        window.setLocation(point.x + n2, point.y + n3);
    }

    public static boolean isMouseInside(Component component) {
        Point point = MouseInfo.getPointerInfo().getLocation();
        Point point2 = component.getLocationOnScreen();
        return point.x >= point2.x && point.y >= point2.y && point.x <= point2.x + component.getWidth() && point.y <= point2.y + component.getHeight();
    }

    public static void waitWhileVisible(Window window) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new Error("do not wait in awt event thread");
        }
        while (window.isVisible()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    public static void waitWhileWindowsVisible() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new Error("do not wait in awt event thread");
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            for (Window window : Window.getWindows()) {
                if (!window.isVisible()) continue;
                bl = true;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    public static void loadingLabel(JLabel jLabel) {
        String[] stringArray = new String[]{"Loading... ", "Loading.. .", "Loading. ..", "Loading ..."};
        jLabel.setText(stringArray[0]);
        Thread thread = new Thread(() -> {
            int n = 0;
            while (jLabel.getText().startsWith("Loading")) {
                if (++n == stringArray.length) {
                    n = 0;
                }
                jLabel.setText(stringArray[n]);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
            }
        });
        thread.start();
    }

    public static void addClickLink(JComponent jComponent, final String string) {
        jComponent.setToolTipText(string);
        jComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    Desktop.getDesktop().browse(new URI(string));
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
    }

    public static <T> T selectFromListWithDialog(List<T> list, T t, String string, JFrame jFrame) {
        return RippedSwingUtil.selectFromListWithDialog(list, t, string, jFrame, null);
    }

    public static <T> T selectFromListWithDialog(List<T> list, T t, String string, JFrame jFrame, ListCellRenderer listCellRenderer) {
        Object object2;
        JDialog jDialog = new JDialog((Frame)jFrame, string);
        jDialog.setModal(jFrame != null);
        DefaultListModel<T> defaultListModel = new DefaultListModel<T>();
        JList jList = new JList(defaultListModel);
        for (Object object2 : list) {
            defaultListModel.addElement(object2);
        }
        if (listCellRenderer != null) {
            jList.setCellRenderer(listCellRenderer);
        }
        jList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(jList);
        object2 = new JPanel(new BorderLayout(10, 10));
        ((Container)object2).add(jScrollPane);
        JButton jButton = new JButton("Select");
        JButton jButton2 = new JButton("Cancel");
        ActionListener actionListener = actionEvent -> {
            if (actionEvent.getSource() != jButton) {
                jList.clearSelection();
            }
            jDialog.setVisible(false);
        };
        jList.setSelectedValue(t, true);
        jList.addListSelectionListener(listSelectionEvent -> jButton.setEnabled(jList.getSelectedIndex() != -1));
        jButton.addActionListener(actionListener);
        jButton.setEnabled(jList.getSelectedIndex() != -1);
        jButton2.addActionListener(actionListener);
        ((JComponent)object2).setBorder(new EmptyBorder(10, 10, 10, 10));
        jDialog.getContentPane().add((Component)object2);
        jDialog.pack();
        jDialog.setLocationRelativeTo(jFrame);
        jDialog.setVisible(true);
        if (!jDialog.isModal()) {
            RippedSwingUtil.waitWhileVisible(jDialog);
        }
        return (T)jList.getSelectedValue();
    }

    public static String toTmpFile(JComponent jComponent) {
        return RippedSwingUtil.toTmpFile(jComponent, null);
    }

    public static String toTmpFile(JComponent jComponent, Dimension dimension) {
        try {
            File file = File.createTempFile("pic", "png");
            return RippedSwingUtil.toFile(file.getPath(), jComponent, dimension);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static BufferedImage thresholdImage(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 10);
        bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, null);
        WritableRaster writableRaster = bufferedImage2.getRaster();
        int[] nArray = new int[bufferedImage.getWidth()];
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            writableRaster.getPixels(0, i, bufferedImage.getWidth(), 1, nArray);
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = nArray[j] < n ? 0 : 255;
            }
            writableRaster.setPixels(0, i, bufferedImage.getWidth(), 1, nArray);
        }
        return bufferedImage2;
    }

    public static String toFile(String string, JComponent jComponent, Dimension dimension) {
        JFrame jFrame = new JFrame();
        jFrame.add(jComponent);
        if (dimension != null) {
            jComponent.setPreferredSize(dimension);
            jComponent.setSize(dimension);
        }
        jFrame.pack();
        jFrame.pack();
        jFrame.setVisible(true);
        SwingUtilities.invokeLater(() -> {
            BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            jComponent.paint(graphics2D);
            graphics2D.dispose();
            try {
                ImageIO.write((RenderedImage)bufferedImage, "png", new File(string));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            jFrame.setVisible(false);
        });
        RippedSwingUtil.waitWhileVisible(jFrame);
        return string;
    }

    public static void removeMouseListeners(Component component, boolean bl) {
        ml.put(component, component.getMouseListeners());
        mm.put(component, component.getMouseMotionListeners());
        mw.put(component, component.getMouseWheelListeners());
        for (MouseListener eventListener : component.getMouseListeners()) {
            component.removeMouseListener(eventListener);
        }
        for (EventListener eventListener : component.getMouseMotionListeners()) {
            component.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        for (EventListener eventListener : component.getMouseWheelListeners()) {
            component.removeMouseWheelListener((MouseWheelListener)eventListener);
        }
        if (bl && component instanceof Container) {
            for (int i = 0; i < ((Container)component).getComponentCount(); ++i) {
                RippedSwingUtil.removeMouseListeners(((Container)component).getComponent(i), true);
            }
        }
    }

    public static void restoreMouseListeners(Component component, boolean bl) {
        if (ml.containsKey(component)) {
            for (EventListener eventListener : ml.get(component)) {
                component.addMouseListener((MouseListener)eventListener);
            }
        }
        if (mm.containsKey(component)) {
            for (EventListener eventListener : mm.get(component)) {
                component.addMouseMotionListener((MouseMotionListener)eventListener);
            }
        }
        if (mw.containsKey(component)) {
            for (EventListener eventListener : mw.get(component)) {
                component.addMouseWheelListener((MouseWheelListener)eventListener);
            }
        }
        if (bl && component instanceof Container) {
            for (int i = 0; i < ((Container)component).getComponentCount(); ++i) {
                RippedSwingUtil.restoreMouseListeners(((Container)component).getComponent(i), true);
            }
        }
    }

    public static void setDebugBorder(JComponent jComponent) {
        RippedSwingUtil.setDebugBorder(jComponent, Color.RED);
    }

    public static void setDebugBorder(JComponent jComponent, Color color) {
        jComponent.setBorder(new CompoundBorder(new LineBorder(color, 3), jComponent.getBorder()));
    }

    public static void removeDebugBorder(JComponent jComponent) {
        jComponent.setBorder(((CompoundBorder)jComponent.getBorder()).getInsideBorder());
    }

    public static void waitForAWTEventThread() {
        RippedSwingUtil.waitForAWTEventThread(10L);
    }

    public static void waitForAWTEventThread(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        SwingUtilities.invokeLater(() -> stringBuilder.append("clear"));
        while (!stringBuilder.toString().equals("clear")) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    public static void invokeAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static void checkNoAWTEventThread() throws IllegalStateException {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("not allowed in awt-event thread : " + Thread.currentThread().getName());
        }
    }

    public static void checkIsAWTEventThread() throws IllegalStateException {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("only allowed in awt-event thread : " + Thread.currentThread().getName());
        }
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    static {
        try {
            ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            gs = ge.getScreenDevices();
        }
        catch (HeadlessException headlessException) {
            throw new RuntimeException("no screen!", headlessException);
        }
        ml = new HashMap();
        mw = new HashMap();
        mm = new HashMap();
    }

    public static interface BackgroundPainter {
        public Color getColor(Object var1, int var2);
    }
}

