/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.curveseparation;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.jblas.Decompose;
import org.jblas.DoubleMatrix;
import org.jblas.Solve;
import org.jblas.ranges.IntervalRange;
import org.jblas.ranges.Range;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.common.util.image.RtPixel2D;
import se.prediktera.breeze.common.util.image.RtPixelFloat;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.sample.SamplePath;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.plot2D.scatter.FloatWindowScatter;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.map.plot.axisplot.settings.Statistics.AbstractStatisticsInfo;

public class CurveSeparationStatisticsInfo
extends AbstractStatisticsInfo {
    private CurveAreas curveAreas = new CurveAreas();
    private CurveClass selectedCurve;
    private double[] selectedCoordinate;
    private CurvePoint selectedPoint;
    private boolean editable;

    public void setProperties(Properties properties) {
        super.setProperties(properties);
        this.curveAreas = (CurveAreas)properties.get("curveAreas");
        if (properties.containsKey("editable")) {
            this.editable = (Boolean)properties.get("editable");
        }
        if (properties.containsKey("selectedCurve")) {
            this.selectedCurve = (CurveClass)properties.get("selectedCurve");
        }
    }

    public void adjustMinMax(AbstractAxisLayer abstractAxisLayer, int n, double[] dArray) {
    }

    public void calculate(AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n) {
    }

    public AbstractSettingsPanel createSettingsPanel() {
        return null;
    }

    public void draw(Graphics2D graphics2D, AbstractAxisPlot abstractAxisPlot, AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n, double d, double d2) {
        FloatWindowScatter floatWindowScatter = (FloatWindowScatter)abstractAxisPlot;
        AxisRange axisRange = floatWindowScatter.getRange(0, 0);
        AxisRange axisRange2 = floatWindowScatter.getRange(1, 0);
        double[] dArray = floatWindowScatter.translateToScreenDouble(axisRange.getMin(), axisRange2.getMax());
        double[] dArray2 = floatWindowScatter.translateToScreenDouble(axisRange.getMax(), axisRange2.getMin());
        boolean bl = axisRange.hasZoomed() || axisRange2.hasZoomed();
        this.curveAreas.onScreen(floatWindowScatter, dArray, dArray2, !bl);
        Font font = graphics2D.getFont();
        graphics2D.setFont(new Font(font.getFamily(), 1, 20));
        for (int i = 0; i < this.curveAreas.areas.size(); ++i) {
            Object object = this.curveAreas.areas.get(i);
            Rectangle rectangle = ((Area)object).getBounds();
            if (rectangle.width == 0 || rectangle.height == 0) continue;
            Color color = RtPerfectSpread.generateColor(i);
            graphics2D.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 25));
            graphics2D.fill((Shape)object);
            graphics2D.setColor(abstractAxisPlot.getForeground());
            String string = "A" + (i + 1);
            int n2 = graphics2D.getFontMetrics().stringWidth(string);
            List<RtPixel2D> list = SamplePath.getShapePixels((Shape)object, false);
            RtPixelFloat rtPixelFloat = CurveSeparationStatisticsInfo.calculateCenter(list);
            graphics2D.drawString(string, (int)(rtPixelFloat.x - (float)n2), (int)rtPixelFloat.y);
        }
        graphics2D.setFont(font);
        try {
            for (Object object : this.curveAreas) {
                graphics2D.setStroke(AbstractPaint.stroke);
                this.drawPoint(graphics2D, floatWindowScatter, ((CurveClass)object).p1);
                this.drawPoint(graphics2D, floatWindowScatter, ((CurveClass)object).p2);
                this.drawPoint(graphics2D, floatWindowScatter, ((CurveClass)object).p3);
                if (this.selectedCurve == object) {
                    graphics2D.setStroke(AbstractPaint.dashed2);
                    graphics2D.setColor(Color.gray);
                } else {
                    graphics2D.setStroke(AbstractPaint.stroke2);
                    graphics2D.setColor(abstractAxisPlot.getAxisColor());
                }
                if (((CurveClass)object).path == null) continue;
                graphics2D.draw(((CurveClass)object).path);
            }
        }
        catch (Exception exception) {
            Logg.error((String)"Cannot draw curve", (Throwable)exception);
        }
        graphics2D.setStroke(AbstractPaint.stroke);
    }

    private static RtPixelFloat calculateCenter(List<RtPixel2D> list) {
        if (list.isEmpty()) {
            return new RtPixelFloat(0.0f, 0.0f);
        }
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        for (RtPixel2D rtPixel2D : list) {
            if (rtPixel2D.x < n) {
                n = rtPixel2D.x;
            }
            if (rtPixel2D.x > n2) {
                n2 = rtPixel2D.x;
            }
            if (rtPixel2D.y < n3) {
                n3 = rtPixel2D.y;
            }
            if (rtPixel2D.y > n4) {
                n4 = rtPixel2D.y;
            }
            f2 = (float)((double)f2 + ((double)rtPixel2D.x + 0.5));
            f = (float)((double)f + ((double)rtPixel2D.y + 0.5));
        }
        return new RtPixelFloat(f2 / (float)list.size(), f / (float)list.size());
    }

    private void drawPoint(Graphics2D graphics2D, FloatWindowScatter floatWindowScatter, CurvePoint curvePoint) {
        if (curvePoint == this.selectedPoint) {
            graphics2D.setColor(Color.gray);
        } else {
            graphics2D.setColor(floatWindowScatter.getBackground());
        }
        if (curvePoint.screen != null) {
            int n = (int)curvePoint.screen[0];
            int n2 = (int)curvePoint.screen[1];
            graphics2D.fillRect(n - 5, n2 - 5, 10, 10);
            graphics2D.setColor(floatWindowScatter.getForeground());
            graphics2D.drawRect(n - 5, n2 - 5, 10, 10);
        }
    }

    public void drawInBg(Graphics2D graphics2D, AbstractAxisPlot abstractAxisPlot, AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n, double d, double d2) {
    }

    protected int hasStatisticAt(double d, double d2, AbstractAxisPlot abstractAxisPlot) {
        if (this.editable) {
            AxisRange axisRange = abstractAxisPlot.getRange(0, 0);
            AxisRange axisRange2 = abstractAxisPlot.getRange(1, 0);
            double[] dArray = new double[2];
            this.selectedPoint = null;
            this.selectedCurve = null;
            this.selectedCoordinate = null;
            for (CurveClass curveClass : this.curveAreas) {
                abstractAxisPlot.translateToScreenDouble(dArray, curveClass.p1.x, curveClass.p1.y, axisRange, axisRange2);
                if (dArray[0] - 5.0 <= d && dArray[0] + 5.0 >= d && dArray[1] - 5.0 <= d2 && dArray[1] + 5.0 >= d2) {
                    this.selectedPoint = curveClass.p1;
                    this.selectedCurve = curveClass;
                    return 2;
                }
                abstractAxisPlot.translateToScreenDouble(dArray, curveClass.p2.x, curveClass.p2.y, axisRange, axisRange2);
                if (dArray[0] - 5.0 <= d && dArray[0] + 5.0 >= d && dArray[1] - 5.0 <= d2 && dArray[1] + 5.0 >= d2) {
                    this.selectedPoint = curveClass.p2;
                    this.selectedCurve = curveClass;
                    return 2;
                }
                abstractAxisPlot.translateToScreenDouble(dArray, curveClass.p3.x, curveClass.p3.y, axisRange, axisRange2);
                if (dArray[0] - 5.0 <= d && dArray[0] + 5.0 >= d && dArray[1] - 5.0 <= d2 && dArray[1] + 5.0 >= d2) {
                    this.selectedPoint = curveClass.p3;
                    this.selectedCurve = curveClass;
                    return 2;
                }
                double d3 = curveClass.getY(d);
                if (!(d3 - 5.0 <= d2) || !(d3 + 5.0 >= d2)) continue;
                this.selectedCoordinate = ((FloatWindowPlot2D)abstractAxisPlot).getPlotGrid().translateToPlot(d, d3, 0);
                this.selectedCurve = curveClass;
                return 2;
            }
        }
        return -1;
    }

    public void setValue(int n, double[] dArray, FloatWindowPlot2D floatWindowPlot2D, boolean bl) {
        if (this.editable) {
            AxisRange axisRange = floatWindowPlot2D.getRange(0, 0);
            AxisRange axisRange2 = floatWindowPlot2D.getRange(1, 0);
            if (this.selectedPoint != null) {
                this.selectedPoint.setLocation(this.checkValue(dArray[0], axisRange), this.checkValue(dArray[1], axisRange2));
            } else if (this.selectedCurve != null && this.selectedCoordinate != null) {
                double d = dArray[0] - this.selectedCoordinate[0];
                double d2 = dArray[1] - this.selectedCoordinate[1];
                this.selectedCurve.move(d, d2);
                this.selectedCoordinate[0] = dArray[0];
                this.selectedCoordinate[1] = dArray[1];
            }
        }
    }

    private boolean isMoveInside(CurveClass curveClass, double d, double d2, AxisRange axisRange, AxisRange axisRange2) {
        return this.isMoveInside(curveClass.p1, d, d2, axisRange, axisRange2) && this.isMoveInside(curveClass.p2, d, d2, axisRange, axisRange2) && this.isMoveInside(curveClass.p3, d, d2, axisRange, axisRange2);
    }

    private boolean isMoveInside(CurvePoint curvePoint, double d, double d2, AxisRange axisRange, AxisRange axisRange2) {
        double d3 = curvePoint.x + d;
        double d4 = curvePoint.y + d2;
        return d3 >= axisRange.getMin() && d3 < axisRange.getMax() && d4 >= axisRange2.getMin() && d4 < axisRange2.getMax();
    }

    private double checkValue(double d, AxisRange axisRange) {
        if (d < axisRange.getMin()) {
            return axisRange.getMin();
        }
        if (d > axisRange.getMax()) {
            return axisRange.getMax();
        }
        return d;
    }

    public void load(MapProperty mapProperty) {
    }

    public void save(RandomOutputStream randomOutputStream) {
    }

    public boolean supportData(DataTreeInterface dataTreeInterface) {
        FloatWindowScatter floatWindowScatter;
        DataTreeInterface dataTreeInterface2;
        if (dataTreeInterface instanceof FloatWindowScatter && (dataTreeInterface2 = (floatWindowScatter = (FloatWindowScatter)dataTreeInterface).getPlotInit().getDataTreeInterface()) instanceof ModelMatrix) {
            ModelMatrix modelMatrix = (ModelMatrix)dataTreeInterface2;
            if (dataTreeInterface2.toString().equals("xres")) {
                AbstractModel abstractModel = modelMatrix.getModel();
                return abstractModel != null && abstractModel.getComponentsInt() == 0;
            }
        }
        return false;
    }

    public String toNiceString() {
        return "CurveSeparation";
    }

    public String toString() {
        return "[CURVESEPARATION]";
    }

    protected int getType() {
        return 30;
    }

    public static class CurveAreas
    extends ArrayList<CurveClass> {
        public List<Area> areas = new ArrayList<Area>();
        private double minScreenX;
        private final CurveComparator compatrator = new CurveComparator();

        public CurveAreas() {
        }

        public CurveAreas(File file) {
            this.load(file);
        }

        private static double[] parseArray(String string) {
            String[] stringArray = string.split(";");
            double[] dArray = new double[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                dArray[i - 1] = RtDataFormat.toNumber(stringArray[i]);
            }
            return dArray;
        }

        public CurveAreas(Node node) {
            List<Node> list;
            if (node != null && (list = XmlParserHelper.getNodeList(node, "curves")).size() > 0) {
                for (Node node2 : XmlParserHelper.getNodeList(list.get(0), "curve")) {
                    this.add(new CurveClass(node2));
                }
            }
        }

        public void setCallback(CurveCallback curveCallback) {
            for (CurveClass curveClass : this) {
                curveClass.setCallback(curveCallback);
            }
        }

        public int getArea(double d, double d2) {
            int n = this.size();
            if (n > 0) {
                int n2 = ((CurveClass)this.get(0)).isAbove(d, d2) ? 0 : n;
                for (int i = 1; i < n; ++i) {
                    if (!((CurveClass)this.get(i)).isUnder(d, d2)) continue;
                    ++n2;
                }
                return n2;
            }
            return 0;
        }

        public void onScreen(FloatWindowScatter floatWindowScatter, double[] dArray, double[] dArray2, boolean bl) {
            this.minScreenX = dArray[0];
            for (CurveClass curveClass : this) {
                curveClass.onScreen(floatWindowScatter, dArray, dArray2);
            }
            if (bl) {
                this.sort(this.compatrator);
            }
            this.areas.clear();
            if (this.size() > 0) {
                Object object = new boolean[this.size()];
                this.createAreaRecursive(0, (boolean[])object);
            }
        }

        private void createAreaRecursive(int n, boolean[] blArray) {
            if (n == blArray.length) {
                Area area = new Area(((CurveClass)this.get(0)).getArea(blArray[0]));
                for (int i = 1; i < blArray.length; ++i) {
                    area.subtract(((CurveClass)this.get(i)).getArea(!blArray[i]));
                }
                this.areas.add(area);
            } else {
                blArray[n] = true;
                this.createAreaRecursive(n + 1, blArray);
                blArray[n] = false;
                this.createAreaRecursive(n + 1, blArray);
            }
        }

        public void polyfit() {
            for (CurveClass curveClass : this) {
                curveClass.polyfit();
            }
        }

        public void save(Element element) {
            Element element2 = XmlParserHelper.addElement(element, "curves");
            for (CurveClass curveClass : this) {
                curveClass.save(element2);
            }
        }

        public void save(File file) {
            try {
                PrintWriter printWriter = new PrintWriter(file);
                for (int i = 0; i < this.size(); ++i) {
                    CurveClass curveClass = (CurveClass)this.get(i);
                    if (i > 0) {
                        printWriter.println();
                    }
                    printWriter.print("X" + (i + 1));
                    printWriter.print(";");
                    printWriter.print(curveClass.p1.x);
                    printWriter.print(";");
                    printWriter.print(curveClass.p2.x);
                    printWriter.print(";");
                    printWriter.print(curveClass.p3.x);
                    printWriter.println();
                    printWriter.print("Y" + (i + 1));
                    printWriter.print(";");
                    printWriter.print(curveClass.p1.y);
                    printWriter.print(";");
                    printWriter.print(curveClass.p2.y);
                    printWriter.print(";");
                    printWriter.print(curveClass.p3.y);
                }
                printWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void load(File file) {
            try {
                List<String> list = Files.readAllLines(file.toPath());
                for (int i = 0; i < list.size(); i += 2) {
                    double[] dArray = CurveAreas.parseArray(list.get(i));
                    double[] dArray2 = CurveAreas.parseArray(list.get(i + 1));
                    this.add(new CurveClass(dArray[0], dArray2[0], dArray[1], dArray2[1], dArray[2], dArray2[2], null));
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        private class CurveComparator
        implements Comparator<CurveClass> {
            private CurveComparator() {
            }

            @Override
            public int compare(CurveClass curveClass, CurveClass curveClass2) {
                return Double.compare(curveClass2.getY(CurveAreas.this.minScreenX), curveClass.getY(CurveAreas.this.minScreenX));
            }
        }
    }

    public static class CurveClass {
        public CurvePoint p1;
        public CurvePoint p2;
        public CurvePoint p3;
        public double[] polyfit;
        private GeneralPath path;
        private Area areaAbove;
        private Area areaUnder;

        public CurveClass(double d, double d2, double d3, double d4, double d5, double d6, CurveCallback curveCallback) {
            this.p1 = new CurvePoint(this, curveCallback, d, d2);
            this.p2 = new CurvePoint(this, curveCallback, d3, d4);
            this.p3 = new CurvePoint(this, curveCallback, d5, d6);
        }

        public CurveClass(MinMax minMax, MinMax minMax2, int n) {
            double d;
            double d2;
            double d3 = minMax.abs().doubleValue() / 4.0;
            double d4 = minMax.min().doubleValue() + d3;
            if (n == 0) {
                d2 = minMax2.abs().doubleValue() / 4.0;
                d = minMax2.min().doubleValue() + d2;
            } else if (n == 1) {
                d2 = -minMax2.abs().doubleValue() / 4.0;
                d = minMax2.max().doubleValue() + d2;
            } else if (n == 2) {
                d2 = 0.0;
                d = minMax2.min().doubleValue() + minMax2.abs().doubleValue() / 2.0;
            } else {
                d2 = minMax2.abs().doubleValue() / 8.0;
                d = minMax2.min().doubleValue() + minMax2.abs().doubleValue() / 2.65;
            }
            this.p1 = new CurvePoint(this, null, d4, d);
            this.p2 = new CurvePoint(this, null, d4 += d3, d += d2);
            this.p3 = new CurvePoint(this, null, d4 += d3, d += d2);
        }

        public CurveClass(Node node) {
            List<Node> list = XmlParserHelper.getNodeList(node, "point");
            this.p1 = new CurvePoint(this, list.get(0));
            this.p2 = new CurvePoint(this, list.get(1));
            this.p3 = new CurvePoint(this, list.get(2));
        }

        public void move(double d, double d2) {
            this.p1.Move(d, d2);
            this.p2.Move(d, d2);
            this.p3.Move(d, d2);
        }

        public Area getArea(boolean bl) {
            if (bl) {
                return this.areaAbove;
            }
            return this.areaUnder;
        }

        public void setCallback(CurveCallback curveCallback) {
            this.p1.setCallback(curveCallback);
            this.p2.setCallback(curveCallback);
            this.p3.setCallback(curveCallback);
        }

        public void polyfit() {
            this.polyfit = CurveClass.polyfit(new double[]{this.p1.x, this.p2.x, this.p3.x}, new double[]{this.p1.y, this.p2.y, this.p3.y}, 2);
        }

        public static double[] polyfit(double[] dArray, double[] dArray2, int n) {
            DoubleMatrix doubleMatrix = new DoubleMatrix(dArray.length, n + 1);
            for (int i = 0; i < doubleMatrix.rows; ++i) {
                for (int j = 0; j <= n; ++j) {
                    doubleMatrix.put(i, j, Math.pow(dArray[i], j));
                }
            }
            DoubleMatrix doubleMatrix2 = new DoubleMatrix(dArray2);
            Decompose.QRDecomposition qRDecomposition = Decompose.qr((DoubleMatrix)doubleMatrix);
            DoubleMatrix doubleMatrix3 = ((DoubleMatrix)qRDecomposition.r).get((Range)new IntervalRange(0, n + 1), (Range)new IntervalRange(0, n + 1));
            DoubleMatrix doubleMatrix4 = Solve.pinv((DoubleMatrix)doubleMatrix3);
            DoubleMatrix doubleMatrix5 = doubleMatrix.mmul(doubleMatrix4);
            DoubleMatrix doubleMatrix6 = doubleMatrix5.transpose().mmul(doubleMatrix2);
            DoubleMatrix doubleMatrix7 = doubleMatrix4.mmul(doubleMatrix6);
            double[] dArray3 = new double[doubleMatrix7.rows];
            for (int i = 0; i < doubleMatrix7.rows; ++i) {
                dArray3[i] = doubleMatrix7.get(i);
            }
            return dArray3;
        }

        public double getY(double d) {
            if (this.polyfit != null) {
                return this.polyfit[0] + d * this.polyfit[1] + this.polyfit[2] * d * d;
            }
            return 0.0;
        }

        public boolean isAbove(double d, double d2) {
            return d2 >= this.getY(d);
        }

        public boolean isUnder(double d, double d2) {
            return d2 < this.getY(d);
        }

        public String toString() {
            return "Curve (" + String.valueOf(this.p1) + ", " + String.valueOf(this.p2) + ", " + String.valueOf(this.p3) + ")";
        }

        public void onScreen(FloatWindowScatter floatWindowScatter, double[] dArray, double[] dArray2) {
            this.p1.onScreen(floatWindowScatter);
            this.p2.onScreen(floatWindowScatter);
            this.p3.onScreen(floatWindowScatter);
            this.polyfit = CurveClass.polyfit(new double[]{this.p1.screen[0], this.p2.screen[0], this.p3.screen[0]}, new double[]{this.p1.screen[1], this.p2.screen[1], this.p3.screen[1]}, 2);
            this.path = new GeneralPath();
            for (double d = dArray[0]; d <= dArray2[0]; d += 1.0) {
                double d2 = this.polyfit[0] + d * this.polyfit[1] + this.polyfit[2] * d * d;
                if (d2 > dArray2[1]) {
                    d2 = dArray2[1];
                }
                if (d2 < dArray[1]) {
                    d2 = dArray[1];
                }
                if (this.path.getCurrentPoint() == null) {
                    this.path.moveTo(d, d2);
                    continue;
                }
                this.path.lineTo(d, d2);
            }
            GeneralPath generalPath = (GeneralPath)this.path.clone();
            generalPath.lineTo(dArray2[0], dArray[1]);
            generalPath.lineTo(dArray[0], dArray[1]);
            generalPath.closePath();
            this.areaAbove = new Area(generalPath);
            GeneralPath generalPath2 = (GeneralPath)this.path.clone();
            generalPath2.lineTo(dArray2[0], dArray2[1]);
            generalPath2.lineTo(dArray[0], dArray2[1]);
            generalPath2.closePath();
            this.areaUnder = new Area(generalPath2);
        }

        public void save(Element element) {
            Element element2 = XmlParserHelper.addElement(element, "curve");
            this.p1.save(element2);
            this.p2.save(element2);
            this.p3.save(element2);
        }
    }

    public static class CurvePoint {
        private final CurveClass curveClass;
        private CurveCallback callback;
        public double x;
        public double y;
        public double[] screen;

        public CurvePoint(CurveClass curveClass, CurveCallback curveCallback, double d, double d2) {
            this.curveClass = curveClass;
            this.callback = curveCallback;
            this.x = d;
            this.y = d2;
        }

        public CurvePoint(CurveClass curveClass, Node node) {
            this.curveClass = curveClass;
            this.x = XmlParserHelper.getDoubleAttribute(node, "x", 0.0);
            this.y = XmlParserHelper.getDoubleAttribute(node, "y", 0.0);
        }

        public void setCallback(CurveCallback curveCallback) {
            this.callback = curveCallback;
        }

        public void setLocation(double d, double d2) {
            this.x = d;
            this.y = d2;
            if (this.callback != null) {
                this.callback.changed(this.curveClass, this);
            }
        }

        public void Move(double d, double d2) {
            this.setLocation(this.x + d, this.y + d2);
        }

        public String toString() {
            return NiceDataFormat.toString((double)this.x, (int)3, (boolean)false) + ", " + NiceDataFormat.toString((double)this.y, (int)3, (boolean)false);
        }

        public void onScreen(FloatWindowScatter floatWindowScatter) {
            this.screen = floatWindowScatter.translateToScreenDouble(this.x, this.y);
        }

        public void save(Element element) {
            Element element2 = XmlParserHelper.addElement(element, "point");
            element2.setAttribute("x", String.valueOf(this.x));
            element2.setAttribute("y", String.valueOf(this.y));
        }

        public double[] array() {
            return new double[]{this.x, this.y};
        }
    }

    public static interface CurveCallback {
        public void changed(CurveClass var1, CurvePoint var2);
    }
}

