/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.mat;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.base.mdarray.MDByteArray;
import ch.systemsx.cisd.base.mdarray.MDDoubleArray;
import ch.systemsx.cisd.base.mdarray.MDFloatArray;
import ch.systemsx.cisd.base.mdarray.MDShortArray;
import ch.systemsx.cisd.hdf5.HDF5FloatStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5ObjectReadWriteInfoProviderHandler;
import ch.systemsx.cisd.hdf5.IHDF5StringWriter;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import com.jmatio.io.MatFileWriter;
import com.jmatio.types.MLChar;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import se.prediktera.breeze.common.frame.ByteFrame;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.ShortFrame;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.map.dataexport.matlab.ExportMAT;
import se.prediktera.map.dataexport.matlab.Mat73FileWriterCustom;

public class MatExport {
    private final File file;

    public MatExport(File file) {
        this.file = file;
    }

    public void export(BreezeProgress breezeProgress, List<? extends Frame> list, String string) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.file);){
            FileChannel fileChannel = fileOutputStream.getChannel();
            File file = File.createTempFile("temp", ".tmp");
            this.writeMatrix(breezeProgress, file, list, string, 0);
            Mat73FileWriterCustom.writeMatlabHeader((WritableByteChannel)fileChannel);
            Mat73FileWriterCustom.updateBaseAddress((File)file);
            Mat73FileWriterCustom.appendHDFData((File)file, (WritableByteChannel)fileChannel);
            file.delete();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void writeMatrix(BreezeProgress breezeProgress, File file, List<? extends Frame> list, String string, int n) {
        IHDF5Writer iHDF5Writer = Mat73FileWriterCustom.getHDFWriter((File)file);
        String string2 = "/" + ExportMAT.getCorrectVariableName((String)string);
        IHDF5ObjectReadWriteInfoProviderHandler iHDF5ObjectReadWriteInfoProviderHandler = iHDF5Writer.object();
        iHDF5ObjectReadWriteInfoProviderHandler.delete("/__DATA_TYPES__");
        long[] lArray = this.getDimensions(list);
        if (lArray[0] * lArray[1] * lArray[2] < 250000000L) {
            this.writeObjectPathAndArray(iHDF5Writer, string2, this.createMdArray(breezeProgress, list, lArray));
        }
        iHDF5Writer.close();
    }

    private void writeObjectPathAndArray(IHDF5Writer iHDF5Writer, String string, MDAbstractArray mDAbstractArray) {
        String string2 = "";
        if (mDAbstractArray instanceof MDDoubleArray) {
            iHDF5Writer.float64().writeMDArray(string, (MDDoubleArray)mDAbstractArray, HDF5FloatStorageFeatures.createDeflation((int)3));
            string2 = "double";
        } else if (mDAbstractArray instanceof MDFloatArray) {
            iHDF5Writer.float32().writeMDArray(string, (MDFloatArray)mDAbstractArray, HDF5FloatStorageFeatures.createDeflation((int)3));
            string2 = "float";
        } else if (mDAbstractArray instanceof MDShortArray) {
            iHDF5Writer.int16().writeMDArray(string, (MDShortArray)mDAbstractArray, HDF5IntStorageFeatures.createDeflation((int)3));
            string2 = "short";
        } else if (mDAbstractArray instanceof MDByteArray) {
            iHDF5Writer.int8().writeMDArray(string, (MDByteArray)mDAbstractArray, HDF5IntStorageFeatures.createDeflation((int)3));
            string2 = "byte";
        }
        IHDF5StringWriter iHDF5StringWriter = iHDF5Writer.string();
        iHDF5StringWriter.setAttr(string, "MATLAB_class", string2);
    }

    private long[] getDimensions(List<? extends Frame> list) {
        Frame frame = list.get(0);
        long l = list.size();
        long l2 = frame.getRows().value;
        long l3 = frame.getColumns().value;
        return new long[]{l2, l3, l};
    }

    private MDAbstractArray createMdArray(BreezeProgress breezeProgress, List<? extends Frame> list, long[] lArray) {
        Frame frame = list.get(0);
        switch (frame.getType()) {
            case BYTE_1: {
                MDByteArray mDByteArray = new MDByteArray(lArray);
                for (int i = 0; i < list.size(); ++i) {
                    ByteFrame byteFrame = (ByteFrame)list.get(i);
                    for (int j = 0; j < byteFrame.getColumns().value; ++j) {
                        for (int k = 0; k < byteFrame.getRows().value; ++k) {
                            mDByteArray.set(byteFrame.getFrameValueNative(k, j), k, j, i);
                        }
                    }
                    breezeProgress.incStep();
                }
                return mDByteArray;
            }
            case SHORT_2: {
                MDShortArray mDShortArray = new MDShortArray(lArray);
                for (int i = 0; i < list.size(); ++i) {
                    ShortFrame shortFrame = (ShortFrame)list.get(i);
                    for (int j = 0; j < shortFrame.getColumns().value; ++j) {
                        for (int k = 0; k < shortFrame.getRows().value; ++k) {
                            mDShortArray.set(shortFrame.getFrameValueNative(k, j), k, j, i);
                        }
                    }
                    breezeProgress.incStep();
                }
                return mDShortArray;
            }
            case FLOAT_4: {
                MDFloatArray mDFloatArray = new MDFloatArray(lArray);
                for (int i = 0; i < list.size(); ++i) {
                    Frame frame2 = list.get(i);
                    for (int j = 0; j < frame2.getColumns().value; ++j) {
                        for (int k = 0; k < frame2.getRows().value; ++k) {
                            mDFloatArray.set(frame2.getFrameValue(k, j), k, j, i);
                        }
                    }
                    breezeProgress.incStep();
                }
                return mDFloatArray;
            }
            case DOUBLE_8: {
                MDDoubleArray mDDoubleArray = new MDDoubleArray(lArray);
                for (int i = 0; i < list.size(); ++i) {
                    Frame frame3 = list.get(i);
                    for (int j = 0; j < frame3.getColumns().value; ++j) {
                        for (int k = 0; k < frame3.getRows().value; ++k) {
                            mDDoubleArray.set((double)frame3.getFrameValue(k, j), k, j, i);
                        }
                    }
                    breezeProgress.incStep();
                }
                return mDDoubleArray;
            }
        }
        throw new RuntimeException("Data type not supported: " + String.valueOf((Object)frame.getType()));
    }

    public static void writeBandNames(BandNames bandNames, File file) {
        try {
            new MatFileWriter().write(file, List.of(new MLChar("Wavelength", bandNames.toArray(), 30)));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

