/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.mat;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import se.prediktera.breeze.Breeze;
import se.prediktera.breeze.common.util.raw.FrameCube;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.util.mat.MatExport;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataexport.matlab.ExportMAT;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.main.script.EvinceScriptCommands;

public class MatExportTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testMatExport() {
        File file = new File(this.tempFolder.getRoot(), "file.mat");
        MatExport matExport = new MatExport(file);
        FrameCube frameCube = new FrameCube(new BandCount(5), new PixelWidth(10), new FrameCount(8), DataSize.FLOAT_4);
        for (int i = 0; i < frameCube.getLines().value; ++i) {
            for (int j = 0; j < frameCube.getWidth().value; ++j) {
                for (int k = 0; k < frameCube.getBandCount().value; ++k) {
                    frameCube.setValue(i, k, j, (float)i + (float)j * 0.1f + (float)k * 0.01f);
                }
            }
        }
        matExport.export(BreezeProgressManager.createEmpty(), frameCube.getFrameList(), "test");
        MatcherAssert.assertThat((Object)file.exists(), (Matcher)Matchers.is((Object)true));
        Breeze.initForTest();
        DataSet dataSet = (DataSet)EvinceScriptCommands.load((ProgressManager)BreezeProgressManager.createEmpty(), (String)file.getAbsolutePath());
        LayerMatrix layerMatrix = (LayerMatrix)dataSet.getOriginalMatrix();
        MatcherAssert.assertThat((Object)frameCube.getBandCount().value, (Matcher)Matchers.is((Object)layerMatrix.getMatrixCount()));
        AbstractDataMatrix abstractDataMatrix = layerMatrix.getMatrixAt(0);
        MatcherAssert.assertThat((Object)frameCube.getWidth().value, (Matcher)Matchers.is((Object)abstractDataMatrix.getK()));
        MatcherAssert.assertThat((Object)frameCube.getLines().value, (Matcher)Matchers.is((Object)abstractDataMatrix.getN()));
        for (int i = 0; i < layerMatrix.getMatrixCount(); ++i) {
            AbstractDataMatrix abstractDataMatrix2 = layerMatrix.getMatrixAt(i);
            for (int j = 0; j < abstractDataMatrix2.getN(); ++j) {
                for (int k = 0; k < abstractDataMatrix2.getK(); ++k) {
                    MatcherAssert.assertThat((Object)Float.valueOf((float)abstractDataMatrix2.getValue(j, k)), (Matcher)Matchers.is((Object)Float.valueOf(frameCube.getValue(j, i, k))));
                }
            }
        }
    }

    @Test
    public void testCorrectVariableName() {
        MatcherAssert.assertThat((Object)ExportMAT.getCorrectVariableName((String)"37-39 secondary_1_1.mat"), (Matcher)Matchers.is((Object)"X_37_39_secondary_1_1_mat"));
        MatcherAssert.assertThat((Object)ExportMAT.getCorrectVariableName((String)"0.25.mat"), (Matcher)Matchers.is((Object)"X_0_25_mat"));
        MatcherAssert.assertThat((Object)ExportMAT.getCorrectVariableName((String)"0.5-1.mat"), (Matcher)Matchers.is((Object)"X_0_5_1_mat"));
    }
}

