/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.performance;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import se.prediktera.breeze.Breeze;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.plot.axisplot.windows.FloatTextWindow;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class DiagnosticHelper {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");

    public static File getDefaultFolder() {
        return new File(System.getProperty("user.home"), "breeze-runtime-statistics");
    }

    public static File formatFile(File file) {
        return DiagnosticHelper.formatFile(file.getParentFile(), file.getName());
    }

    public static File formatFile(File file, String string) {
        return new File(new File(file, string + "_" + DiagnosticHelper.getTimestamp()), "data.csv");
    }

    public static String getTimestamp() {
        return sdf.format(new Date());
    }

    public static void createEvincePlots(ProgressManager progressManager, File file) {
        AbstractPlotLayout abstractPlotLayout;
        Properties properties = new Properties();
        properties.put("autoidentify", "false");
        properties.put("removezerovariance", "false");
        properties.put("autoexclude", "false");
        properties.put("primaryrow", "1");
        properties.put("forcerowdata", "true");
        DataSet dataSet = (DataSet)EvinceScriptCommands.load((ProgressManager)progressManager, (String)file.getAbsolutePath(), (Double[])new Double[0], (Double[])new Double[]{1.0}, (Properties)properties);
        AbstractDataMatrix abstractDataMatrix = dataSet.getMatrix(0);
        System.out.println("Diagnostic data has " + abstractDataMatrix.getN() + " observations");
        if (abstractDataMatrix.getN() == 0) {
            return;
        }
        if (abstractDataMatrix.getN() > 2000) {
            abstractPlotLayout = new Double[2000];
            for (int i = 0; i < ((AbstractPlotLayout)abstractPlotLayout).length; ++i) {
                abstractPlotLayout[i] = Double.valueOf((double)i + 1.0);
            }
            dataSet.exclude(progressManager, "obs", (Double[])abstractPlotLayout);
        }
        abstractPlotLayout = (AbstractPlotLayout)EvinceScriptCommands.createPlot((ProgressManager)progressManager, (String)"Scatter2D", (DataTreeInterface)abstractDataMatrix);
        abstractPlotLayout.show("borders", Double.valueOf(0.0));
        abstractPlotLayout.setColor(new Object[]{"density"});
        abstractPlotLayout.setSize(new Object[]{"fixed", 2.0});
        FloatTextWindow floatTextWindow = (FloatTextWindow)abstractPlotLayout.addTextArea("Text", "free");
        floatTextWindow.setBackgroundColor(Color.white);
        floatTextWindow.setFontColor(Color.black);
        floatTextWindow.setFont(new Font("calibri", 1, 15));
        Properties properties2 = new Properties();
        properties2.put("width", "1");
        floatTextWindow.setBorder("rectangular", "black", properties2);
        String string = file.getParentFile().getName();
        Description description = abstractDataMatrix.getColumnDescription();
        for (int i = 3; i < description.getRows(); ++i) {
            double d = 0.0;
            MinMax minMax = new MinMax();
            for (int j = 0; j < abstractDataMatrix.getN(); ++j) {
                double d2 = abstractDataMatrix.getValue(j, i);
                d += d2;
                minMax.add((float)d2);
            }
            double d3 = d / (double)abstractDataMatrix.getN();
            double d4 = 0.0;
            for (int j = 0; j < abstractDataMatrix.getN(); ++j) {
                double d5 = d3 - abstractDataMatrix.getValue(j, i);
                d4 += d5 * d5;
            }
            double d6 = Math.sqrt(d4 / (double)(abstractDataMatrix.getN() - 1));
            floatTextWindow.set("text", "Average: " + RtDataFormat.toString(d3, 4) + ", StdDev: " + RtDataFormat.toString(d6, 4) + "\nMin: " + RtDataFormat.toString(minMax.min().floatValue(), 4) + ", max: " + RtDataFormat.toString(minMax.max().floatValue(), 4));
            floatTextWindow.setPosition(Double.valueOf(100.0), Double.valueOf(100.0));
            DiagnosticHelper.createSave(progressManager, abstractPlotLayout, i, file.getParentFile(), string, description.getValue(i, 0).toString(), true);
        }
    }

    private static void createSave(ProgressManager progressManager, AbstractPlotLayout abstractPlotLayout, int n, File file, String string, String string2, boolean bl) {
        abstractPlotLayout.setTitle(string + "\n" + string2);
        abstractPlotLayout.setDataRange(new Object[]{"x", "value", 2.0});
        abstractPlotLayout.setDataRange(new Object[]{"y", "value", (double)(n + 1)});
        if (!bl) {
            abstractPlotLayout.show("autorescale", Double.valueOf(0.0));
            abstractPlotLayout.show("ymin", Double.valueOf(-100.0));
            abstractPlotLayout.show("ymax", Double.valueOf(1000.0));
        }
        abstractPlotLayout.save(progressManager, new File(file, string2 + ".png").getAbsolutePath(), "png", Double.valueOf(1024.0), Double.valueOf(768.0));
    }

    public static void main(String[] stringArray) {
        Breeze.initForTest();
        File file = new File("C:\\Users\\Oskar\\breeze-runtime-statistics\\FX50_D3E_20191106-095947\\data.csv");
        DiagnosticHelper.createEvincePlots((ProgressManager)ProgressManager.createEmpty(), file);
        System.exit(0);
    }
}

