/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.performance;

import se.prediktera.map.common.NiceDataFormat;

public class PerformanceCounter {
    private final String name;
    private final int printEveryCount;
    private final QueueSizeCallback queueSizeCallback;
    private int counter = 0;
    private long totalTimeNano = 0L;
    private long startTime;
    private long lastPrintTime;

    public PerformanceCounter(String string, int n, QueueSizeCallback queueSizeCallback) {
        this.name = string;
        this.printEveryCount = n;
        this.queueSizeCallback = queueSizeCallback;
        this.lastPrintTime = System.currentTimeMillis();
    }

    public PerformanceCounter(String string, int n) {
        this(string, n, null);
    }

    public void frameStart() {
        this.startTime = System.nanoTime();
    }

    public void frameEnd(int n) {
        this.totalTimeNano += System.nanoTime() - this.startTime;
        this.counter += n;
        if (this.counter >= this.printEveryCount) {
            double d = (double)this.totalTimeNano / 1000000.0;
            int n2 = (int)((double)this.counter / d * 1000.0);
            int n3 = this.computeActualFps();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.name);
            stringBuffer.append("\tframe time: ");
            stringBuffer.append(NiceDataFormat.toString((double)(d / (double)this.counter), (int)3));
            stringBuffer.append(" msek");
            stringBuffer.append("\tactual fps: ");
            stringBuffer.append(n3);
            stringBuffer.append("\tmax theory fps: ");
            stringBuffer.append(n2);
            if (this.queueSizeCallback != null) {
                stringBuffer.append(", queue size: ");
                stringBuffer.append(this.queueSizeCallback.getQueueSize());
            }
            System.out.println(stringBuffer);
            this.counter -= this.printEveryCount;
            this.totalTimeNano = 0L;
            this.lastPrintTime = System.currentTimeMillis();
        }
    }

    private int computeActualFps() {
        return (int)((double)this.counter / ((double)(System.currentTimeMillis() - this.lastPrintTime) / 1000.0));
    }

    public static interface QueueSizeCallback {
        public int getQueueSize();
    }
}

