/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.performance;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.Breeze;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.performance.TasklistProcess;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.util.performance.DiagnosticHelper;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.update.UpdateHelper;

public class PredictionStatistics {
    private final List<PredictionLineStat> list = new ArrayList<PredictionLineStat>();
    private int memUsage;
    private long lastMemUsageTime = 0L;
    private boolean running = true;

    public PredictionStatistics() {
        Thread thread = new Thread(() -> {
            while (this.running) {
                long l = System.currentTimeMillis();
                if (l - this.lastMemUsageTime <= 1000L) continue;
                try {
                    this.memUsage = new TasklistProcess("BreezeRuntime.exe").getMemUsage();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.lastMemUsageTime = l;
            }
        });
        thread.start();
    }

    public PredictionStatistics(File file) {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string = "";
            String[] stringArray = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (stringArray == null) {
                    stringArray = string.split(";");
                    continue;
                }
                this.list.add(new PredictionLineStat(stringArray, string.split(";")));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void add(long l, long l2, long l3) {
        this.list.add(new PredictionLineStat(this.memUsage, l, l2, l3));
    }

    public void saveInFolder(ProgressManager progressManager, File file, String string) {
        DiagnosticHelper.createEvincePlots(progressManager, this.save(new File(file, string + "_(" + this.calcSummary().toString() + ")_" + DiagnosticHelper.getTimestamp())));
    }

    public SummaryStat calcSummary() {
        return new SummaryStat(this.list);
    }

    public File save(File file) {
        file.mkdirs();
        File file2 = new File(file, "data.csv");
        try (PrintWriter printWriter = new PrintWriter(file2, StandardCharsets.ISO_8859_1);){
            printWriter.println("Line;FrameNumber;MemUsage;Delta(Out-In);In Diff;Out Diff;DroppedFrames");
            int n = 1;
            PredictionLineStat predictionLineStat = null;
            for (PredictionLineStat predictionLineStat2 : this.list) {
                printWriter.print(n++);
                printWriter.print(";");
                printWriter.print(predictionLineStat2.frameNumber);
                printWriter.print(";");
                printWriter.print(predictionLineStat2.memUsage);
                printWriter.print(";");
                printWriter.print(this.format(predictionLineStat2.inTime, predictionLineStat2.outTime));
                printWriter.print(";");
                if (predictionLineStat != null) {
                    printWriter.print(this.format(predictionLineStat.inTime, predictionLineStat2.inTime));
                    printWriter.print(";");
                    printWriter.print(this.format(predictionLineStat.outTime, predictionLineStat2.outTime));
                    printWriter.print(";");
                    printWriter.print(predictionLineStat2.frameNumber - (predictionLineStat.frameNumber + 1L));
                } else {
                    printWriter.print(0);
                    printWriter.print(";");
                    printWriter.print(0);
                    printWriter.print(";");
                    printWriter.print(0);
                }
                printWriter.println();
                predictionLineStat = predictionLineStat2;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            this.running = false;
        }
        return file2;
    }

    private String format(long l, long l2) {
        double d = (double)(l2 - l) / 10000.0;
        return RtDataFormat.toString(d);
    }

    public static void main(String[] stringArray) {
        Breeze.initForTest();
        File file = new File("C:\\data\\statistics\\PePpPlay21janv19_(47,5_1,68_3)_20190228-135622\\data.csv");
        PredictionStatistics predictionStatistics = new PredictionStatistics(file);
        System.out.println(predictionStatistics.calcSummary());
        DiagnosticHelper.createEvincePlots((ProgressManager)ProgressManager.createEmpty(), file);
        System.exit(0);
    }

    private static class PredictionLineStat {
        private final int memUsage;
        private final long inTime;
        private final long outTime;
        private final long frameNumber;
        private final long delta;

        public PredictionLineStat(int n, long l, long l2, long l3) {
            this.memUsage = n;
            this.inTime = l;
            this.outTime = l2;
            this.frameNumber = l3;
            this.delta = l2 - l;
        }

        public PredictionLineStat(String[] stringArray, String[] stringArray2) {
            this.outTime = 0L;
            this.inTime = 0L;
            this.frameNumber = 0L;
            this.memUsage = Integer.parseInt(stringArray2[1]);
            this.delta = (long)(RtDataFormat.toNumber(stringArray2[3]) * 10000.0);
        }

        public long deltaTime() {
            return this.delta;
        }
    }

    public static class SummaryStat {
        private double average;
        private final double averageFps;
        private double stdev;
        private int spikes;
        private int maxMemUsage;
        private FrameRate frameRate;

        public SummaryStat(List<PredictionLineStat> list) {
            List<PredictionLineStat> list2 = list.subList(Math.min(list.size(), 1000), list.size());
            double d = 0.0;
            double d2 = 0.0;
            this.maxMemUsage = 0;
            for (int i = 0; i < list2.size(); ++i) {
                PredictionLineStat predictionLineStat = list2.get(i);
                d += (double)predictionLineStat.deltaTime();
                if (i > 0) {
                    d2 += (double)Math.abs(predictionLineStat.outTime - list2.get((int)(i - 1)).outTime);
                }
                this.maxMemUsage = Math.max(this.maxMemUsage, predictionLineStat.memUsage);
            }
            this.average = d / (double)list2.size();
            double d3 = d2 / (double)list2.size();
            this.averageFps = 1000.0 / (d3 / 10000.0);
            double d4 = 0.0;
            for (PredictionLineStat predictionLineStat : list2) {
                d4 += Math.pow((double)predictionLineStat.deltaTime() - this.average, 2.0);
            }
            this.stdev = Math.sqrt(d4 /= (double)(list2.size() - 1));
            this.spikes = 0;
            boolean bl = false;
            double d5 = this.average + this.stdev * 5.0;
            double d6 = this.average + this.stdev;
            for (PredictionLineStat predictionLineStat : list2) {
                if (bl) {
                    bl = (double)predictionLineStat.deltaTime() > d6;
                    continue;
                }
                if (!((double)predictionLineStat.deltaTime() > d5)) continue;
                ++this.spikes;
                bl = true;
            }
            this.average /= 10000.0;
            this.stdev /= 10000.0;
        }

        public double getAverage() {
            return this.average;
        }

        public double getStdev() {
            return this.stdev;
        }

        public int getSpikes() {
            return this.spikes;
        }

        public double getAverageFps() {
            return this.averageFps;
        }

        public int getMaxMemUsage() {
            return this.maxMemUsage;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(RtDataFormat.toString(this.average, 4));
            stringBuilder.append("_");
            stringBuilder.append(RtDataFormat.toString(this.stdev, 4));
            stringBuilder.append("_");
            stringBuilder.append(this.spikes);
            stringBuilder.append("_");
            stringBuilder.append(RtDataFormat.toString(this.averageFps, 4));
            stringBuilder.append("fps_");
            stringBuilder.append(UpdateHelper.formatSize((long)this.maxMemUsage));
            return stringBuilder.toString().replace(".", ",");
        }

        public void setFrameRate(FrameRate frameRate) {
            this.frameRate = frameRate;
        }

        public FrameRate getFrameRate() {
            return this.frameRate;
        }
    }
}

