/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.raw;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.util.raw.RawHeader;

public class ByteListFromRaw
extends ArrayList<byte[]> {
    public ByteListFromRaw(File file) {
        super(ByteListFromRaw.readFrames(file));
    }

    private static List<byte[]> readFrames(File file) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        RawHeader rawHeader = RawHeader.findByRaw(file);
        int n = rawHeader.bandCount().value * rawHeader.pixelWidth().value * rawHeader.dataSize().size;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            FileChannel fileChannel = fileInputStream.getChannel();
            for (int i = 0; i < rawHeader.frameCount().value; ++i) {
                fileChannel.read(byteBuffer);
                arrayList.add((byte[])byteBuffer.array().clone());
                byteBuffer.clear();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return arrayList;
    }
}

