/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.raw;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.frame.DoubleFrame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.mat.FloatMatrixArrayFromFrames;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.RawFileWriter;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.util.raw.HySpexHelper;
import se.prediktera.map.common.error.Logg;

public class HySpexHeader
extends HySpexHelper {
    public File file;
    public String name;
    public int headerSize;
    public int serialNumber;
    public String configFile;
    public String settingFile;
    public double scalingFactor;
    public int numberOfBackground;
    public int spectralSize;
    public int spatialSize;
    public double[] background;
    public double[] backgroundLast;
    public double maxFramerate;
    public int numberOfFrames;
    public int integrationtime;
    public double[] QE;
    public double[] RE;
    public int electronics;
    public int comsettingsElectronics;
    public String comportElectronics;
    public int fanSpeed;
    public int backTemperature;
    public int Pback;
    public int Iback;
    public int Dback;
    public String comport;
    public String detectstring;
    public String sensor;
    public double temperature_end;
    public double temperature_start;
    public double temperature_calibration;
    public String framegrabber;
    public String ID;
    public String supplier;
    public String leftGain;
    public String rightGain;
    public String comment;
    public String backgroundFile;
    public String recordHD;
    public int unknownPOINTER;
    public int serverIndex;
    public int comsettings;
    public int binning;
    public int detected;
    public int frameperiod;
    public int defaultR;
    public int defaultG;
    public int defaultB;
    public int bitshift;
    public int temperatureOffset;
    public int shutter;
    public int backgroundPresent;
    public int power;
    public int current;
    public int bias;
    public int bandwidth;
    public int vin;
    public int vref;
    public int sensorVin;
    public int sensorVref;
    public int coolingTemperature;
    public int windowStart;
    public int windowStop;
    public int readoutTime;
    public int p;
    public int i;
    public int d;
    public int nobp;
    public int dw;
    public int mEQ;
    public int lens;
    public int FOVexp;
    public int scanningMode;
    public int calibAvailable;
    public int numberOfAvg;
    public double SF;
    public double apertureSize;
    public double pixelSizeX;
    public double pixelSizeY;
    public double temperature;
    public int spectralCalibPOINTER;
    public int REPOINTER;
    public int QEPOINTER;
    public int backgroundPOINTER;
    public int badPixelsPOINTER;
    public int imageFormat;
    public int[] badPixels;
    public double[] spectralCalib;
    private static final int extensionMarker = 48879;
    public int extensionVersion;
    public byte[] availableMatrices;
    public byte[] methodUsed;
    public byte[] reservedParameters;
    public int resampled_spectral_size;
    public int resampled_spatial_size;
    public double[] spectral_fwhm;
    public double[] spectral_fwhm_all;
    public double[] spectral_calibration_matrix;
    public double[] qe_all;
    public double[] temperature_compensation;
    public double[] sensormodel;
    public double[] spatial_calibration_matrix;
    public double[] resampled_central_pixels;
    public double[] resampled_central_wavelengths;
    public double[] first_background_std_deviation;
    public double[] second_background_std_deviation;
    public double[] spectral_calib_delta;
    public double[] resampled_central_wavelengths_delta;
    public double[] spectral_calibration_matrix_delta;
    public float dataIgnoreValue;
    public byte alongTrackBinning;
    public byte acrossTrackBinning;
    public byte spectralBinning;
    public byte lowgain;
    public byte hsnr;
    public byte relativeRoi;
    public int framesSkippedAtStart;
    public int framesSkippedAtEnd;

    public HySpexHeader(File file) {
        block10: {
            this.maxFramerate = 5000.0;
            this.integrationtime = 10000;
            this.availableMatrices = new byte[32];
            this.methodUsed = new byte[16];
            this.file = file;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                FileChannel fileChannel = fileInputStream.getChannel();
                ByteBuffer byteBuffer = HySpexHeader.readBuffer(fileChannel, 8);
                this.name = HySpexHeader.readString(byteBuffer, 8);
                if (this.name.startsWith("HYSPEX")) {
                    ByteBuffer byteBuffer2 = HySpexHeader.readBuffer(fileChannel, 4);
                    this.headerSize = HySpexHeader.readInt(byteBuffer2);
                    byteBuffer = HySpexHeader.readBuffer(fileChannel, this.headerSize - 12);
                    this.parseHySpexBuffer(byteBuffer);
                    break block10;
                }
                if (this.name.equals("NOFIMA S") || this.name.equals("NOFIMA C")) {
                    ByteBuffer byteBuffer3 = HySpexHeader.readBuffer(fileChannel, 40);
                    this.spectralSize = HySpexHeader.readInt(byteBuffer3);
                    this.spatialSize = HySpexHeader.readInt(byteBuffer3);
                    HySpexHeader.readDouble(byteBuffer3);
                    HySpexHeader.readDouble(byteBuffer3);
                    ByteBuffer byteBuffer4 = HySpexHeader.readBuffer(fileChannel, (this.spectralSize * 2 + this.spectralSize * this.spatialSize * 2) * 8);
                    HySpexHeader.readDouble(byteBuffer4, this.spectralSize);
                    HySpexHeader.readDouble(byteBuffer4, this.spectralSize);
                    HySpexHeader.readDouble(byteBuffer4, this.spectralSize * this.spatialSize);
                    this.background = HySpexHeader.readDouble(byteBuffer4, this.spectralSize * this.spatialSize);
                    break block10;
                }
                if (this.name.equals("NOFIMA R")) {
                    break block10;
                }
                throw new UnknowHySpexFormat("Unknow HySpex header name: " + this.name);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public HySpexHeader(ByteBuffer byteBuffer) {
        block4: {
            this.maxFramerate = 5000.0;
            this.integrationtime = 10000;
            this.availableMatrices = new byte[32];
            this.methodUsed = new byte[16];
            try {
                this.parseInitialBuffer(byteBuffer);
                if (this.name.equals("NOFIMA S") || this.name.equals("NOFIMA C")) {
                    this.spectralSize = HySpexHeader.readInt(byteBuffer);
                    this.spatialSize = HySpexHeader.readInt(byteBuffer);
                    HySpexHeader.readDouble(byteBuffer);
                    HySpexHeader.readDouble(byteBuffer);
                    HySpexHeader.readDouble(byteBuffer, this.spectralSize);
                    HySpexHeader.readDouble(byteBuffer, this.spectralSize);
                    HySpexHeader.readDouble(byteBuffer, this.spectralSize * this.spatialSize);
                    this.background = HySpexHeader.readDouble(byteBuffer, this.spectralSize * this.spatialSize);
                    break block4;
                }
                if (this.name.equals("NOFIMA R")) break block4;
                if (this.name.startsWith("HYSPEX")) {
                    this.headerSize = HySpexHeader.readInt(byteBuffer);
                    this.parseHySpexBuffer(byteBuffer);
                    break block4;
                }
                throw new UnknowHySpexFormat("Unknow HySpex header name: " + this.name);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public HySpexHeader(int n, int n2, int n3) {
        this.maxFramerate = 5000.0;
        this.integrationtime = 10000;
        this.availableMatrices = new byte[32];
        this.methodUsed = new byte[16];
        this.spectralSize = n;
        this.spatialSize = n2;
        this.numberOfFrames = n3;
        this.name = "HYSPEX";
        this.serialNumber = 1234;
    }

    private void parseInitialBuffer(ByteBuffer byteBuffer) throws IOException {
        this.name = HySpexHeader.readString(byteBuffer, 8);
    }

    private void parseHySpexBuffer(ByteBuffer byteBuffer) throws IOException {
        int n;
        this.serialNumber = HySpexHeader.readInt(byteBuffer);
        this.configFile = HySpexHeader.readString(byteBuffer, 200);
        this.settingFile = HySpexHeader.readString(byteBuffer, 120);
        this.scalingFactor = HySpexHeader.readDouble(byteBuffer);
        this.electronics = HySpexHeader.readInt(byteBuffer);
        this.comsettingsElectronics = HySpexHeader.readInt(byteBuffer);
        this.comportElectronics = HySpexHeader.readString(byteBuffer, 44);
        this.fanSpeed = HySpexHeader.readInt(byteBuffer);
        this.backTemperature = HySpexHeader.readInt(byteBuffer);
        this.Pback = HySpexHeader.readInt(byteBuffer);
        this.Iback = HySpexHeader.readInt(byteBuffer);
        this.Dback = HySpexHeader.readInt(byteBuffer);
        this.comport = HySpexHeader.readString(byteBuffer, 64);
        this.detectstring = HySpexHeader.readString(byteBuffer, 200);
        this.sensor = HySpexHeader.readString(byteBuffer, 176);
        this.temperature_end = HySpexHeader.readDouble(byteBuffer);
        this.temperature_start = HySpexHeader.readDouble(byteBuffer);
        this.temperature_calibration = HySpexHeader.readDouble(byteBuffer);
        this.framegrabber = HySpexHeader.readString(byteBuffer, 200);
        this.ID = HySpexHeader.readString(byteBuffer, 200);
        byte[] byArray = HySpexHeader.readBytes(byteBuffer, 200);
        int n2 = HySpexHeader.readInt(HySpexHeader.createByteBuffer(byArray, 32, 36));
        if (n2 == 48879) {
            this.supplier = HySpexHeader.readString(byArray, 32);
            this.extensionVersion = HySpexHeader.readInt(HySpexHeader.createByteBuffer(byArray, 36, 40));
            System.arraycopy(byArray, 40, this.availableMatrices, 0, this.availableMatrices.length);
            System.arraycopy(byArray, 72, this.methodUsed, 0, this.methodUsed.length);
            this.resampled_spectral_size = HySpexHeader.readInt(HySpexHeader.createByteBuffer(byArray, 88, 92));
            this.resampled_spatial_size = HySpexHeader.readInt(HySpexHeader.createByteBuffer(byArray, 92, 96));
            this.dataIgnoreValue = HySpexHeader.readFloat(HySpexHeader.createByteBuffer(byArray, 96, 100));
            n = 100;
            if (this.extensionVersion == 2) {
                this.alongTrackBinning = byArray[n++];
                this.acrossTrackBinning = byArray[n++];
                this.spectralBinning = byArray[n++];
                this.lowgain = byArray[n++];
                this.hsnr = byArray[n++];
                this.relativeRoi = byArray[n++];
                this.framesSkippedAtStart = HySpexHeader.readInt(HySpexHeader.createByteBuffer(byArray, n, n += 4));
                this.framesSkippedAtEnd = HySpexHeader.readInt(HySpexHeader.createByteBuffer(byArray, n, n += 4));
            }
            this.reservedParameters = new byte[byArray.length - n];
            System.arraycopy(byArray, n, this.reservedParameters, 0, this.reservedParameters.length);
        } else {
            this.supplier = HySpexHeader.readString(byArray, 200);
            Arrays.fill(this.availableMatrices, 0, 6, (byte)1);
            this.reservedParameters = new byte[100];
        }
        this.leftGain = HySpexHeader.readString(byteBuffer, 32);
        this.rightGain = HySpexHeader.readString(byteBuffer, 32);
        this.comment = HySpexHeader.readString(byteBuffer, 200);
        this.backgroundFile = HySpexHeader.readString(byteBuffer, 200);
        this.recordHD = HySpexHeader.readString(byteBuffer, 1);
        this.unknownPOINTER = HySpexHeader.readInt(byteBuffer);
        this.serverIndex = HySpexHeader.readInt(byteBuffer);
        this.comsettings = HySpexHeader.readInt(byteBuffer);
        this.numberOfBackground = HySpexHeader.readInt(byteBuffer);
        this.spectralSize = HySpexHeader.readInt(byteBuffer);
        this.spatialSize = HySpexHeader.readInt(byteBuffer);
        this.binning = HySpexHeader.readInt(byteBuffer);
        this.detected = HySpexHeader.readInt(byteBuffer);
        this.integrationtime = HySpexHeader.readInt(byteBuffer);
        this.frameperiod = HySpexHeader.readInt(byteBuffer);
        this.defaultR = HySpexHeader.readInt(byteBuffer);
        this.defaultG = HySpexHeader.readInt(byteBuffer);
        this.defaultB = HySpexHeader.readInt(byteBuffer);
        this.bitshift = HySpexHeader.readInt(byteBuffer);
        this.temperatureOffset = HySpexHeader.readInt(byteBuffer);
        this.shutter = HySpexHeader.readInt(byteBuffer);
        this.backgroundPresent = HySpexHeader.readInt(byteBuffer);
        this.power = HySpexHeader.readInt(byteBuffer);
        this.current = HySpexHeader.readInt(byteBuffer);
        this.bias = HySpexHeader.readInt(byteBuffer);
        this.bandwidth = HySpexHeader.readInt(byteBuffer);
        this.vin = HySpexHeader.readInt(byteBuffer);
        this.vref = HySpexHeader.readInt(byteBuffer);
        this.sensorVin = HySpexHeader.readInt(byteBuffer);
        this.sensorVref = HySpexHeader.readInt(byteBuffer);
        this.coolingTemperature = HySpexHeader.readInt(byteBuffer);
        this.windowStart = HySpexHeader.readInt(byteBuffer);
        this.windowStop = HySpexHeader.readInt(byteBuffer);
        this.readoutTime = HySpexHeader.readInt(byteBuffer);
        this.p = HySpexHeader.readInt(byteBuffer);
        this.i = HySpexHeader.readInt(byteBuffer);
        this.d = HySpexHeader.readInt(byteBuffer);
        this.numberOfFrames = HySpexHeader.readInt(byteBuffer);
        this.nobp = HySpexHeader.readInt(byteBuffer);
        this.dw = HySpexHeader.readInt(byteBuffer);
        this.mEQ = HySpexHeader.readInt(byteBuffer);
        this.lens = HySpexHeader.readInt(byteBuffer);
        this.FOVexp = HySpexHeader.readInt(byteBuffer);
        this.scanningMode = HySpexHeader.readInt(byteBuffer);
        this.calibAvailable = HySpexHeader.readInt(byteBuffer);
        this.numberOfAvg = HySpexHeader.readInt(byteBuffer);
        this.SF = HySpexHeader.readDouble(byteBuffer);
        this.apertureSize = HySpexHeader.readDouble(byteBuffer);
        this.pixelSizeX = HySpexHeader.readDouble(byteBuffer);
        this.pixelSizeY = HySpexHeader.readDouble(byteBuffer);
        this.temperature = HySpexHeader.readDouble(byteBuffer);
        this.maxFramerate = HySpexHeader.readDouble(byteBuffer);
        this.spectralCalibPOINTER = HySpexHeader.readInt(byteBuffer);
        this.REPOINTER = HySpexHeader.readInt(byteBuffer);
        this.QEPOINTER = HySpexHeader.readInt(byteBuffer);
        this.backgroundPOINTER = HySpexHeader.readInt(byteBuffer);
        this.badPixelsPOINTER = HySpexHeader.readInt(byteBuffer);
        this.imageFormat = HySpexHeader.readInt(byteBuffer);
        n = 0;
        this.spectralCalib = this.readDouble(byteBuffer, this.spectralSize, n++);
        this.QE = this.readDouble(byteBuffer, this.spectralSize, n++);
        this.RE = this.readDouble(byteBuffer, this.spectralSize * this.spatialSize, n++);
        this.background = this.readDouble(byteBuffer, this.spectralSize * this.spatialSize, n++);
        if (this.availableMatrices[n++] > 0) {
            this.badPixels = HySpexHeader.readInt(byteBuffer, this.nobp);
        }
        this.backgroundLast = this.readDouble(byteBuffer, this.spectralSize * this.spatialSize, n++);
        if (this.extensionVersion == 2) {
            try {
                this.spectral_fwhm = this.readDouble(byteBuffer, this.spectralSize, n++);
                this.spectral_fwhm_all = this.readDouble(byteBuffer, this.spectralSize * this.spatialSize, n++);
                this.spectral_calibration_matrix = this.readDouble(byteBuffer, this.spectralSize * this.spatialSize, n++);
                this.qe_all = this.readDouble(byteBuffer, this.spectralSize * this.spatialSize, n++);
                this.temperature_compensation = this.readDouble(byteBuffer, 2 * this.spectralSize, n++);
                this.sensormodel = this.readDouble(byteBuffer, this.spatialSize, n++);
                this.spatial_calibration_matrix = this.readDouble(byteBuffer, this.spectralSize * this.spatialSize, n++);
                this.resampled_central_pixels = this.readDouble(byteBuffer, this.resampled_spatial_size, n++);
                this.resampled_central_wavelengths = this.readDouble(byteBuffer, this.resampled_spectral_size, n++);
                this.first_background_std_deviation = this.readDouble(byteBuffer, this.spectralSize * this.spatialSize, n++);
                this.second_background_std_deviation = this.readDouble(byteBuffer, this.spectralSize * this.spatialSize, n++);
                this.spectral_calib_delta = this.readDouble(byteBuffer, this.spectralSize, n++);
                this.resampled_central_wavelengths_delta = this.readDouble(byteBuffer, this.resampled_spectral_size, n++);
                this.spectral_calibration_matrix_delta = this.readDouble(byteBuffer, this.spectralSize * this.spatialSize, n++);
            }
            catch (Exception exception) {
                Logg.error((String)("Error parsings HySpex binary header extension version 2: " + exception.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    public void save(File file) {
        this.file = file;
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.getChannel().write(this.createHeader());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public int replace() {
        int n;
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "rw");
        try {
            ByteBuffer byteBuffer = this.createHeader();
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            randomAccessFile.write(byArray);
            n = byArray.length;
        }
        catch (Throwable throwable) {
            try {
                try {
                    randomAccessFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        randomAccessFile.close();
        return n;
    }

    public ByteBuffer createHeader() throws IOException {
        int n;
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.estimatedHeaderSize());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        HySpexHeader.putBytes(byteBuffer, this.name, 8);
        byteBuffer.putInt(this.headerSize);
        byteBuffer.putInt(this.serialNumber);
        HySpexHeader.putBytes(byteBuffer, this.configFile, 200);
        HySpexHeader.putBytes(byteBuffer, this.settingFile, 120);
        byteBuffer.putDouble(this.scalingFactor);
        byteBuffer.putInt(this.electronics);
        byteBuffer.putInt(this.comsettingsElectronics);
        HySpexHeader.putBytes(byteBuffer, this.comportElectronics, 44);
        byteBuffer.putInt(this.fanSpeed);
        byteBuffer.putInt(this.backTemperature);
        byteBuffer.putInt(this.Pback);
        byteBuffer.putInt(this.Iback);
        byteBuffer.putInt(this.Dback);
        HySpexHeader.putBytes(byteBuffer, this.comport, 64);
        HySpexHeader.putBytes(byteBuffer, this.detectstring, 200);
        HySpexHeader.putBytes(byteBuffer, this.sensor, 176);
        byteBuffer.putDouble(this.temperature_end);
        byteBuffer.putDouble(this.temperature_start);
        byteBuffer.putDouble(this.temperature_calibration);
        HySpexHeader.putBytes(byteBuffer, this.framegrabber, 200);
        HySpexHeader.putBytes(byteBuffer, this.ID, 200);
        if (this.extensionVersion > 0) {
            HySpexHeader.putBytes(byteBuffer, this.supplier, 32);
            byteBuffer.putInt(48879);
            byteBuffer.putInt(this.extensionVersion);
            HySpexHeader.putBytes(byteBuffer, this.availableMatrices);
            HySpexHeader.putBytes(byteBuffer, this.methodUsed);
            byteBuffer.putInt(this.resampled_spectral_size);
            byteBuffer.putInt(this.resampled_spatial_size);
            byteBuffer.putFloat(this.dataIgnoreValue);
            n = 100;
            if (this.extensionVersion == 2) {
                byteBuffer.put(this.alongTrackBinning);
                byteBuffer.put(this.acrossTrackBinning);
                byteBuffer.put(this.spectralBinning);
                byteBuffer.put(this.lowgain);
                byteBuffer.put(this.hsnr);
                byteBuffer.put(this.relativeRoi);
                byteBuffer.putInt(this.framesSkippedAtStart);
                byteBuffer.putInt(this.framesSkippedAtEnd);
                n -= 14;
            }
            HySpexHeader.putBytes(byteBuffer, new byte[n]);
        } else {
            HySpexHeader.putBytes(byteBuffer, this.supplier, 200);
        }
        HySpexHeader.putBytes(byteBuffer, this.leftGain, 32);
        HySpexHeader.putBytes(byteBuffer, this.rightGain, 32);
        HySpexHeader.putBytes(byteBuffer, this.comment, 200);
        HySpexHeader.putBytes(byteBuffer, this.backgroundFile, 200);
        HySpexHeader.putBytes(byteBuffer, this.recordHD, 1);
        byteBuffer.putInt(this.unknownPOINTER);
        byteBuffer.putInt(this.serverIndex);
        byteBuffer.putInt(this.comsettings);
        byteBuffer.putInt(this.numberOfBackground);
        byteBuffer.putInt(this.spectralSize);
        byteBuffer.putInt(this.spatialSize);
        byteBuffer.putInt(this.binning);
        byteBuffer.putInt(this.detected);
        byteBuffer.putInt(this.integrationtime);
        byteBuffer.putInt(this.frameperiod);
        byteBuffer.putInt(this.defaultR);
        byteBuffer.putInt(this.defaultG);
        byteBuffer.putInt(this.defaultB);
        byteBuffer.putInt(this.bitshift);
        byteBuffer.putInt(this.temperatureOffset);
        byteBuffer.putInt(this.shutter);
        byteBuffer.putInt(this.backgroundPresent);
        byteBuffer.putInt(this.power);
        byteBuffer.putInt(this.current);
        byteBuffer.putInt(this.bias);
        byteBuffer.putInt(this.bandwidth);
        byteBuffer.putInt(this.vin);
        byteBuffer.putInt(this.vref);
        byteBuffer.putInt(this.sensorVin);
        byteBuffer.putInt(this.sensorVref);
        byteBuffer.putInt(this.coolingTemperature);
        byteBuffer.putInt(this.windowStart);
        byteBuffer.putInt(this.windowStop);
        byteBuffer.putInt(this.readoutTime);
        byteBuffer.putInt(this.p);
        byteBuffer.putInt(this.i);
        byteBuffer.putInt(this.d);
        byteBuffer.putInt(this.numberOfFrames);
        byteBuffer.putInt(this.nobp);
        byteBuffer.putInt(this.dw);
        byteBuffer.putInt(this.mEQ);
        byteBuffer.putInt(this.lens);
        byteBuffer.putInt(this.FOVexp);
        byteBuffer.putInt(this.scanningMode);
        byteBuffer.putInt(this.calibAvailable);
        byteBuffer.putInt(this.numberOfAvg);
        byteBuffer.putDouble(this.SF);
        byteBuffer.putDouble(this.apertureSize);
        byteBuffer.putDouble(this.pixelSizeX);
        byteBuffer.putDouble(this.pixelSizeY);
        byteBuffer.putDouble(this.temperature);
        byteBuffer.putDouble(this.maxFramerate);
        byteBuffer.putInt(this.spectralCalibPOINTER);
        byteBuffer.putInt(this.REPOINTER);
        byteBuffer.putInt(this.QEPOINTER);
        byteBuffer.putInt(this.backgroundPOINTER);
        byteBuffer.putInt(this.badPixelsPOINTER);
        byteBuffer.putInt(this.imageFormat);
        HySpexHeader.putDoubleArray(byteBuffer, this.spectralCalib, this.spectralSize);
        HySpexHeader.putDoubleArray(byteBuffer, this.QE, this.spectralSize);
        HySpexHeader.putDoubleArray(byteBuffer, this.RE, this.spectralSize * this.spatialSize);
        HySpexHeader.putDoubleArray(byteBuffer, this.background, this.spectralSize * this.spatialSize);
        HySpexHeader.putIntArray(byteBuffer, this.badPixels, this.nobp);
        HySpexHeader.putDoubleArray(byteBuffer, this.backgroundLast, this.spectralSize * this.spatialSize);
        if (this.extensionVersion >= 2) {
            n = 6;
            this.putDoubleArray(byteBuffer, this.spectral_fwhm, this.spectralSize, n++);
            this.putDoubleArray(byteBuffer, this.spectral_fwhm_all, this.spectralSize * this.spatialSize, n++);
            this.putDoubleArray(byteBuffer, this.spectral_calibration_matrix, this.spectralSize * this.spatialSize, n++);
            this.putDoubleArray(byteBuffer, this.qe_all, this.spectralSize * this.spatialSize, n++);
            this.putDoubleArray(byteBuffer, this.temperature_compensation, 2 * this.spectralSize, n++);
            this.putDoubleArray(byteBuffer, this.sensormodel, this.spatialSize, n++);
            this.putDoubleArray(byteBuffer, this.spatial_calibration_matrix, this.spectralSize * this.spatialSize, n++);
            this.putDoubleArray(byteBuffer, this.resampled_central_pixels, this.resampled_spatial_size, n++);
            this.putDoubleArray(byteBuffer, this.resampled_central_wavelengths, this.resampled_spectral_size, n++);
            this.putDoubleArray(byteBuffer, this.first_background_std_deviation, this.spectralSize * this.spatialSize, n++);
            this.putDoubleArray(byteBuffer, this.second_background_std_deviation, this.spectralSize * this.spatialSize, n++);
            this.putDoubleArray(byteBuffer, this.spectral_calib_delta, this.spectralSize, n++);
            this.putDoubleArray(byteBuffer, this.resampled_central_wavelengths_delta, this.resampled_spectral_size, n++);
            this.putDoubleArray(byteBuffer, this.spectral_calibration_matrix_delta, this.spectralSize * this.spatialSize, n++);
            byteBuffer.put(new byte[86]);
        }
        this.headerSize = byteBuffer.position();
        byteBuffer.position(8);
        byteBuffer.putInt(this.headerSize);
        byteBuffer.rewind();
        byteBuffer.limit(this.headerSize);
        return byteBuffer;
    }

    private int estimatedHeaderSize() {
        return Math.max(10000000, this.spectralSize * this.spatialSize * 15 * 8);
    }

    public void print() {
        System.out.println("Name: " + this.name);
        System.out.println("Size: " + this.headerSize);
        System.out.println("Serial number: " + this.serialNumber);
        System.out.println("Spectral size: " + this.spectralSize);
        System.out.println("Spatial size: " + this.spatialSize);
        System.out.println("Frames: " + this.numberOfFrames);
    }

    public double[][] getBackgrounds() {
        if (this.background != null) {
            if (this.backgroundLast != null) {
                return new double[][]{this.background, this.backgroundLast};
            }
            return new double[][]{this.background};
        }
        return null;
    }

    public void saveInEnvi(BreezeProgress breezeProgress, File file, double[][] dArray, BandNames bandNames) {
        ArrayList<RawFrame> arrayList = this.createFrames(dArray);
        RawFrame rawFrame = arrayList.get(0);
        RawHeader rawHeader = new RawHeader(new FrameCount(arrayList.size()), rawFrame.rows, rawFrame.columns, rawFrame.getType());
        rawHeader.setBandNames(bandNames);
        RawFileWriter.writeFramesAndHeader(file, arrayList, rawHeader, "Created by Breeze");
    }

    public ArrayList<RawFrame> createFrames(double[][] dArray) {
        ArrayList<RawFrame> arrayList = new ArrayList<RawFrame>();
        for (int i = 0; i < dArray.length; ++i) {
            arrayList.add(this.createFrame(dArray[i], null));
        }
        return arrayList;
    }

    public FloatMatrix createMatrixBp(double[] dArray, RtFramePredictor.RefSettings refSettings) {
        DoubleFrame doubleFrame = this.createFrame(dArray, refSettings);
        HySpexHeader.applyBadPixels(this.getBadPixelMap(), doubleFrame);
        return new FloatMatrixArrayFromFrames(List.of(doubleFrame)).array()[0];
    }

    public DoubleFrame createFrame(double[] dArray, RtFramePredictor.RefSettings refSettings) {
        BandNames bandNames = this.getBandNames();
        if (refSettings != null) {
            if (refSettings.bounds != null && refSettings.bounds.width < this.spatialSize) {
                return HySpexHeader.createFrame(dArray, this.spectralSize, refSettings.bounds.width, refSettings.reduce, bandNames);
            }
            return HySpexHeader.createFrame(dArray, this.spectralSize, this.spatialSize, refSettings.reduce, bandNames);
        }
        return HySpexHeader.createFrame(dArray, this.spectralSize, this.spatialSize, FrameListFromRaw.Reduce.Original, bandNames);
    }

    public BandNames getBandNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.spectralCalib.length; ++i) {
            arrayList.add(RtDataFormat.toString(this.spectralCalib[i]));
        }
        return new BandNames(arrayList);
    }

    public void crop(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.spectralSize;
        int n8 = this.spatialSize;
        this.spatialSize = n4 - n3;
        this.spectralSize = n6 - n5;
        this.numberOfFrames = n2 - n;
        this.spectralCalib = HySpexHeader.crop(this.spectralCalib, n5, n6);
        this.background = HySpexHeader.crop(this.background, n5, n6, n3, n4, n7, n8);
        this.backgroundLast = HySpexHeader.crop(this.backgroundLast, n5, n6, n3, n4, n7, n8);
        this.RE = HySpexHeader.crop(this.RE, n5, n6, n3, n4, n7, n8);
        this.QE = HySpexHeader.crop(this.QE, n5, n6);
    }

    public double[] crop(double[] dArray, Rectangle rectangle) {
        if (rectangle != null && rectangle.width < this.spatialSize) {
            return HySpexHeader.crop(dArray, 0, this.spectralSize, rectangle.x, rectangle.x + rectangle.width, this.spectralSize, this.spatialSize);
        }
        return dArray;
    }

    public List<HySpexHelper.BadPixel> getBadPixelMap() {
        try {
            return HySpexHeader.getBadPixelMap(this.badPixels, this.nobp, this.spatialSize, this.spectralSize);
        }
        catch (Exception exception) {
            Logg.error((String)"Cannot create pixel map", (Object[])new Object[]{exception.getMessage()});
            return new ArrayList<HySpexHelper.BadPixel>();
        }
    }

    public double[] calcSpectralDelta() {
        if (this.spectralCalib.length <= 2) {
            return new double[0];
        }
        double[] dArray = new double[this.spectralCalib.length];
        int n = 0;
        dArray[n++] = this.spectralCalib[1] - this.spectralCalib[0];
        for (int i = 1; i < this.spectralCalib.length - 1; ++i) {
            dArray[n++] = (this.spectralCalib[i + 1] - this.spectralCalib[i - 1]) / 2.0;
        }
        dArray[n++] = this.spectralCalib[this.spectralCalib.length - 1] - this.spectralCalib[this.spectralCalib.length - 2];
        return dArray;
    }

    public double getScalingComp() {
        double d = this.pixelSizeX * this.pixelSizeY;
        double d2 = (double)this.integrationtime / 1000000.0;
        double d3 = this.apertureSize * this.apertureSize * Math.PI * d;
        return this.SF * d2 * d3 * 1.0E-9 / 1.9864458241717582E-25;
    }

    private double[] readDouble(ByteBuffer byteBuffer, int n, int n2) throws IOException {
        if (this.availableMatrices[n2] > 0) {
            return HySpexHeader.readDouble(byteBuffer, n);
        }
        return null;
    }

    private void putDoubleArray(ByteBuffer byteBuffer, double[] dArray, int n, int n2) {
        if (this.availableMatrices[n2] > 0) {
            HySpexHeader.putDoubleArray(byteBuffer, dArray, n);
        }
    }

    public void setDataFormat(RtFramePredictor.ReferenceConvertTo referenceConvertTo) {
        if (this.extensionVersion >= 0) {
            switch (referenceConvertTo) {
                case None: {
                    this.calibAvailable = 0;
                    break;
                }
                case Radiance: {
                    this.calibAvailable = 2;
                    break;
                }
                case Reflectance: {
                    this.calibAvailable = 3;
                    break;
                }
                case Absorbance: {
                    this.calibAvailable = 4;
                    break;
                }
            }
        } else {
            switch (referenceConvertTo) {
                case None: {
                    this.calibAvailable = 0;
                    break;
                }
                case Radiance: {
                    this.calibAvailable = 2;
                    break;
                }
                case Reflectance: {
                    this.calibAvailable = 7;
                    break;
                }
                case Absorbance: {
                    this.calibAvailable = 8;
                    break;
                }
            }
        }
    }

    public RtFramePredictor.ReferenceConvertTo getDataFormat() {
        if (this.extensionVersion >= 0) {
            switch (this.calibAvailable) {
                case 0: {
                    return RtFramePredictor.ReferenceConvertTo.None;
                }
                case 2: {
                    return RtFramePredictor.ReferenceConvertTo.Radiance;
                }
                case 3: {
                    return RtFramePredictor.ReferenceConvertTo.Reflectance;
                }
                case 4: {
                    return RtFramePredictor.ReferenceConvertTo.Absorbance;
                }
            }
        }
        switch (this.calibAvailable) {
            case 0: {
                return RtFramePredictor.ReferenceConvertTo.None;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return RtFramePredictor.ReferenceConvertTo.Radiance;
            }
            case 7: {
                return RtFramePredictor.ReferenceConvertTo.Reflectance;
            }
            case 8: {
                return RtFramePredictor.ReferenceConvertTo.Absorbance;
            }
        }
        return RtFramePredictor.ReferenceConvertTo.None;
    }

    public static void main(String[] stringArray) {
        File file = new File("C:\\Prediktera\\evince\\BreezeGuiTest\\src\\main\\resources\\sample-data\\SWIR640_16x17_samples\\16x16_SAMPLE_SWIR_640_SN7528_15785us_2024-08-15T150905_raw.hyspex");
        HySpexHeader hySpexHeader = new HySpexHeader(file);
        double[][] dArray = hySpexHeader.getBackgrounds();
        for (int i = 0; i < dArray[0].length; ++i) {
        }
        System.exit(0);
    }

    public static class UnknowHySpexFormat
    extends RuntimeException {
        public UnknowHySpexFormat(String string) {
            super(string);
        }
    }

    public static enum HySpexHeaderType {
        HYSPEX,
        NOFIMA_S,
        NOFIMA_C,
        NOFIMA_R,
        UNKNOWN;


        public static HySpexHeaderType fromName(String string) {
            if (string == null) {
                return UNKNOWN;
            }
            if (string.startsWith("HYSPEX")) {
                return HYSPEX;
            }
            return switch (string) {
                case "NOFIMA S" -> NOFIMA_S;
                case "NOFIMA C" -> NOFIMA_C;
                case "NOFIMA R" -> NOFIMA_R;
                default -> UNKNOWN;
            };
        }
    }
}

