/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.raw;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.RawFileFrameWriter;
import se.prediktera.breeze.common.util.raw.RawFileImpl;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.raw.RtHdrParser;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.util.raw.HySpexHeader;

public class HySpexHeaderHelper {
    public static HySpexHeader addBinaryHeader(File file) throws IOException {
        return HySpexHeaderHelper.addBinaryHeader(file, true);
    }

    public static HySpexHeader addBinaryHeader(File file, boolean bl) throws IOException {
        HySpexHeader hySpexHeader = HySpexHeaderHelper.getOrCreate(file);
        if (bl) {
            HySpexHeaderHelper.createDummyValuesV2(hySpexHeader, file);
        } else {
            HySpexHeaderHelper.createDummyValues(hySpexHeader, file);
            hySpexHeader.extensionVersion = 0;
        }
        HySpexHeaderHelper.updateBinaryHeader(file, hySpexHeader);
        return hySpexHeader;
    }

    public static void createDummyValues(HySpexHeader hySpexHeader, File file) {
        RawHeader rawHeader = RawHeader.findByRaw(file);
        hySpexHeader.pixelSizeX = 0.01;
        hySpexHeader.pixelSizeY = 0.01;
        hySpexHeader.apertureSize = 0.004815;
        hySpexHeader.SF = 0.0513;
        hySpexHeader.dw = 1;
        hySpexHeader.bitshift = 0;
        hySpexHeader.dataIgnoreValue = (float)(Math.pow(2.0, 16 - hySpexHeader.bitshift) - 1.0);
        hySpexHeader.shutter = 1;
        hySpexHeader.integrationtime = 1000;
        hySpexHeader.frameperiod = 2500;
        RgbBands rgbBands = rawHeader.rgbBands();
        hySpexHeader.defaultR = rgbBands.get(0);
        hySpexHeader.defaultG = rgbBands.get(1);
        hySpexHeader.defaultB = rgbBands.get(2);
        BandNames bandNames = rawHeader.bandNames();
        double[] dArray = hySpexHeader.spectralCalib;
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = bandNames.getValue(i);
        }
        double[] dArray2 = hySpexHeader.RE;
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = 1.01 + (double)i * 0.1;
        }
        double[] dArray3 = hySpexHeader.QE;
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = 0.4 + (double)i * 0.1;
        }
        double[] dArray4 = hySpexHeader.backgroundLast = (double[])hySpexHeader.background.clone();
        for (int i = 0; i < dArray4.length; ++i) {
            int n = i;
            dArray4[n] = dArray4[n] + (double)(50 + i);
        }
        hySpexHeader.numberOfBackground = 1;
        RtHdrParser rtHdrParser = rawHeader.getDescriptionData().getParser();
        hySpexHeader.supplier = HySpexHeaderHelper.safe(hySpexHeader.supplier, "AIM");
        hySpexHeader.ID = rtHdrParser.get("Camera type", "VNIR");
        hySpexHeader.serialNumber = RtDataFormat.toNumberInt(rtHdrParser.get("Serialnumber", "12340"));
        hySpexHeader.name = "HYSPEX\u0000";
        hySpexHeader.temperature = 20.0;
        hySpexHeader.temperature_calibration = 20.0;
        hySpexHeader.temperature_end = 20.0;
    }

    public static void createDummyValuesV2(HySpexHeader hySpexHeader, File file) {
        HySpexHeaderHelper.createDummyValues(hySpexHeader, file);
        hySpexHeader.extensionVersion = 2;
        hySpexHeader.supplier = "AIM";
        hySpexHeader.name = "HYSPEX\u0000";
        hySpexHeader.dataIgnoreValue = 0.0f;
        Arrays.fill(hySpexHeader.availableMatrices, (byte)1);
        Arrays.fill(hySpexHeader.methodUsed, (byte)0);
        hySpexHeader.methodUsed[0] = 1;
        hySpexHeader.methodUsed[1] = 1;
        hySpexHeader.resampled_spectral_size = Math.max(1, hySpexHeader.spectralSize / 2);
        hySpexHeader.resampled_spatial_size = Math.max(1, hySpexHeader.spatialSize / 2);
        hySpexHeader.spectral_fwhm = HySpexHeaderHelper.seq(hySpexHeader.spectralSize, 1000.0);
        hySpexHeader.spectral_fwhm_all = HySpexHeaderHelper.seq(hySpexHeader.spectralSize * hySpexHeader.spatialSize, 1100.0);
        hySpexHeader.spectral_calibration_matrix = HySpexHeaderHelper.seq(hySpexHeader.spectralSize * hySpexHeader.spatialSize, 1200.0);
        hySpexHeader.qe_all = HySpexHeaderHelper.seq(hySpexHeader.spectralSize * hySpexHeader.spatialSize, 1300.0);
        hySpexHeader.temperature_compensation = HySpexHeaderHelper.seq(2 * hySpexHeader.spectralSize, 1400.0);
        hySpexHeader.sensormodel = HySpexHeaderHelper.seq(hySpexHeader.spatialSize, 1500.0);
        hySpexHeader.spatial_calibration_matrix = HySpexHeaderHelper.seq(hySpexHeader.spectralSize * hySpexHeader.spatialSize, 1600.0);
        hySpexHeader.resampled_central_pixels = HySpexHeaderHelper.seq(hySpexHeader.resampled_spatial_size, 1700.0);
        hySpexHeader.resampled_central_wavelengths = HySpexHeaderHelper.seq(hySpexHeader.resampled_spectral_size, 1800.0);
        hySpexHeader.first_background_std_deviation = HySpexHeaderHelper.seq(hySpexHeader.spectralSize * hySpexHeader.spatialSize, 1900.0);
        hySpexHeader.second_background_std_deviation = HySpexHeaderHelper.seq(hySpexHeader.spectralSize * hySpexHeader.spatialSize, 2000.0);
        hySpexHeader.spectral_calib_delta = HySpexHeaderHelper.seq(hySpexHeader.spectralSize, 2100.0);
        hySpexHeader.resampled_central_wavelengths_delta = HySpexHeaderHelper.seq(hySpexHeader.resampled_spectral_size, 2200.0);
        hySpexHeader.spectral_calibration_matrix_delta = HySpexHeaderHelper.seq(hySpexHeader.spectralSize * hySpexHeader.spatialSize, 2300.0);
        hySpexHeader.dataIgnoreValue = -9999.0f;
        hySpexHeader.alongTrackBinning = 1;
        hySpexHeader.acrossTrackBinning = 1;
        hySpexHeader.spectralBinning = 1;
        hySpexHeader.lowgain = 0;
        hySpexHeader.hsnr = 0;
        hySpexHeader.relativeRoi = 0;
        hySpexHeader.framesSkippedAtStart = 0;
        hySpexHeader.framesSkippedAtEnd = 0;
        hySpexHeader.nobp = 0;
        hySpexHeader.badPixels = null;
        hySpexHeader.comment = HySpexHeaderHelper.safe(hySpexHeader.comment, "Created by Breeze (dummy v2 header)");
        hySpexHeader.leftGain = HySpexHeaderHelper.safe(hySpexHeader.leftGain, "1x");
        hySpexHeader.rightGain = HySpexHeaderHelper.safe(hySpexHeader.rightGain, "1x");
        hySpexHeader.recordHD = HySpexHeaderHelper.safe(hySpexHeader.recordHD, "0");
    }

    public static void updateBinaryHeader(File file, HySpexHeader hySpexHeader) throws IOException {
        ByteBuffer byteBuffer = hySpexHeader.createHeader();
        int n = byteBuffer.remaining();
        RawFileImpl rawFileImpl = new RawFileImpl(file);
        FrameListFromRaw frameListFromRaw = rawFileImpl.readFrames();
        RawHeader rawHeader = rawFileImpl.header();
        try (RawFileFrameWriter rawFileFrameWriter = new RawFileFrameWriter(file, rawHeader.bandCount(), rawHeader.pixelWidth(), rawHeader.dataSize());){
            rawFileFrameWriter.writeHeader(byteBuffer);
            rawFileFrameWriter.writeFrames(frameListFromRaw);
        }
        rawHeader.setHeaderOffset(n);
        rawHeader.save();
    }

    public static HySpexHeader getOrCreate(File file) {
        RawHeader rawHeader = RawHeader.findByRaw(file);
        if (rawHeader.getHeaderOffset() > 0L) {
            // empty if block
        }
        int n = rawHeader.bandCount().value;
        int n2 = rawHeader.pixelWidth().value;
        HySpexHeader hySpexHeader = new HySpexHeader(n, n2, rawHeader.frameCount().value);
        hySpexHeader.file = file;
        hySpexHeader.spectralCalib = new double[n];
        hySpexHeader.RE = new double[n * n2];
        hySpexHeader.QE = new double[n];
        hySpexHeader.background = new double[n * n2];
        hySpexHeader.backgroundLast = new double[n * n2];
        hySpexHeader.name = "HYSPEX\u0000";
        hySpexHeader.supplier = "AIM";
        return hySpexHeader;
    }

    private static double[] seq(int n, double d) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d + (double)i;
        }
        return dArray;
    }

    private static String safe(String string, String string2) {
        return string == null || string.isEmpty() ? string2 : string;
    }

    public static void checkValues(HySpexHeader hySpexHeader, RawHeader rawHeader) {
        RawHeader.DescriptionData descriptionData;
        if (hySpexHeader.temperature == 0.0) {
            hySpexHeader.temperature = hySpexHeader.temperature_calibration;
        }
        if (hySpexHeader.dataIgnoreValue == 0.0f) {
            hySpexHeader.dataIgnoreValue = 65535.0f;
        }
        if (rawHeader != null && (descriptionData = rawHeader.getDescriptionData()) != null) {
            hySpexHeader.setDataFormat(descriptionData.dataFormat);
        }
    }
}

