/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.raw;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.frame.DoubleFrame;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.AverageFrame;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.raw.ExtraHeaderValues;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.RawFileFrameWriter;
import se.prediktera.breeze.common.util.raw.RawFileImpl;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.util.raw.HySpexHeader;
import se.prediktera.breeze.util.raw.HySpexParser;

public class HySpexHelper
extends HySpexParser {
    public static double getFieldOfView(LensInfo lensInfo, double d, double d2) {
        double d3 = d * d2;
        double d4 = lensInfo.distanceCm * 10.0;
        return 2.0 * d4 * Math.tan(d3 / 2.0);
    }

    public static LensInfo getLensInfo(int n) {
        return switch (n) {
            case 0 -> new LensInfo("Plane", 0.0, 16.0);
            case 1 -> new LensInfo("30 cm", 33.562, 16.0);
            case 2 -> new LensInfo("1 m", 101.916, 16.0);
            case 3 -> new LensInfo("2.24 m", 236.0, 16.0);
            case 4 -> new LensInfo("3 m", 300.0, 16.0);
            case 5 -> new LensInfo("FoV", 0.0, 16.0);
            case 6 -> new LensInfo("Microscope", 13.0976, 0.0);
            case 7 -> new LensInfo("9-13 m", 1100.0, 16.0);
            case 8 -> new LensInfo("13.23 m", 1800.0, 16.0);
            case 9 -> new LensInfo("23-50 m", 3650.0, 16.0);
            case 10 -> new LensInfo("9-50 m", 2950.0, 16.0);
            case 11 -> new LensInfo("1.5 m", 150.0, 16.0);
            case 12 -> new LensInfo("4.5 m", 450.0, 16.0);
            case 13 -> new LensInfo("1.9 m", 190.0, 40.0);
            case 14 -> new LensInfo("1 m", 100.0, 40.0);
            case 15 -> new LensInfo("9-16 m", 1100.0, 16.0);
            default -> new LensInfo("N/A", 0.0, 16.0);
        };
    }

    public static boolean isHySpexFile(File file) {
        File file2 = RawHeader.findHeaderFileByRaw(file);
        if (FileHelper.exists(file2) && new RawHeader(file2).getHeaderOffset() > 0L) {
            return HySpexHelper.readHeaderType(file) == HySpexHeader.HySpexHeaderType.HYSPEX;
        }
        return false;
    }

    public static DoubleFrame getReFrame(File file) {
        if (HySpexHelper.isHySpexFile(file)) {
            try {
                return new HySpexHeader(file).createFrame(new HySpexHeader((File)file).RE, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void applyBadPixels(BreezeProgress breezeProgress, File file, List<BadPixel> list) {
        Object object2;
        RawFileImpl rawFileImpl = new RawFileImpl(file);
        FrameListFromRaw frameListFromRaw = rawFileImpl.readFrames();
        breezeProgress.setInfoText("Correcting bad pixels: " + FileHelper.getFileName(file));
        breezeProgress.setMaximumAndReset(frameListFromRaw.size() * 2);
        for (Object object2 : frameListFromRaw) {
            HySpexHelper.applyBadPixels(list, (Frame)object2);
            breezeProgress.incStep();
        }
        RawHeader rawHeader = rawFileImpl.header();
        object2 = rawFileImpl.readRawHeader();
        if (frameListFromRaw.size() == 0) {
            throw new RuntimeException("Cant write empty raw file");
        }
        RawFrame rawFrame = (RawFrame)frameListFromRaw.get(0);
        BandCount bandCount = rawFrame.getRows();
        PixelWidth pixelWidth = rawFrame.getColumns();
        try (RawFileFrameWriter rawFileFrameWriter = new RawFileFrameWriter(file, bandCount, pixelWidth, rawHeader.dataSize(), null);){
            rawFileFrameWriter.writeHeader((ByteBuffer)object2);
            for (Frame frame : frameListFromRaw) {
                rawFileFrameWriter.writeFrame(frame);
                breezeProgress.incStep();
            }
            rawHeader.writeByRaw(file, bandCount, pixelWidth, rawFileFrameWriter.lineCount(), rawHeader.getDescription(), new ExtraHeaderValues(rawHeader.getParser()), rawHeader.getHeaderOffset());
        }
    }

    public static void applyBadPixels(List<BadPixel> list, Frame frame) {
        if (frame instanceof DoubleFrame) {
            DoubleFrame doubleFrame = (DoubleFrame)frame;
            double[][] dArray = doubleFrame.origframe;
            for (BadPixel badPixel : list) {
                double d;
                int n = Math.abs(badPixel.y_up - badPixel.y) + Math.abs(badPixel.y_down - badPixel.y);
                dArray[badPixel.y][badPixel.x] = d = (dArray[badPixel.y_up][badPixel.x] * (double)Math.abs(badPixel.y_down - badPixel.y) + dArray[badPixel.y_down][badPixel.x] * (double)Math.abs(badPixel.y_up - badPixel.y)) / (double)n;
            }
        } else {
            for (BadPixel badPixel : list) {
                int n = Math.abs(badPixel.y_up - badPixel.y) + Math.abs(badPixel.y_down - badPixel.y);
                float f = (frame.getFrameValue(badPixel.y_up, badPixel.x) * (float)Math.abs(badPixel.y_down - badPixel.y) + frame.getFrameValue(badPixel.y_down, badPixel.x) * (float)Math.abs(badPixel.y_up - badPixel.y)) / (float)n;
                frame.setFrameValue(badPixel.y, badPixel.x, f);
            }
        }
    }

    public static List<BadPixel> getBadPixelMap(int[] nArray, int n, int n2, int n3) {
        int n4;
        ArrayList<BadPixel> arrayList = new ArrayList<BadPixel>();
        int[] nArray2 = new int[n2 * n3];
        for (n4 = 0; n4 < n; ++n4) {
            nArray2[nArray[n4] - 1] = 1;
        }
        for (n4 = 0; n4 < n; ++n4) {
            int n5;
            BadPixel badPixel = new BadPixel();
            badPixel.x = (nArray[n4] - 1) % n2;
            badPixel.y = (nArray[n4] - 1) / n2;
            int n6 = badPixel.x;
            badPixel.y_up = -1;
            for (n5 = badPixel.y - 1; n5 >= 0; --n5) {
                if (nArray2[n5 * n2 + n6] != 0) continue;
                badPixel.y_up = n5;
                break;
            }
            badPixel.y_down = -1;
            for (n5 = badPixel.y + 1; n5 < n3; ++n5) {
                if (nArray2[n5 * n2 + n6] != 0) continue;
                badPixel.y_down = n5;
                break;
            }
            n5 = badPixel.y;
            badPixel.x_left = -1;
            for (n6 = badPixel.x - 1; n6 >= 0; --n6) {
                if (nArray2[n5 * n2 + n6] != 0) continue;
                badPixel.x_left = n6;
                break;
            }
            badPixel.x_right = -1;
            for (n6 = badPixel.x + 1; n6 < n2; ++n6) {
                if (nArray2[n5 * n2 + n6] != 0) continue;
                badPixel.x_right = n6;
                break;
            }
            if (badPixel.y_up == -1 && badPixel.y_down != -1) {
                badPixel.y_up = badPixel.y_down;
            } else if (badPixel.y_down == -1 && badPixel.y_up != -1) {
                badPixel.y_down = badPixel.y_up;
            }
            if (badPixel.x_left == -1 && badPixel.x_right != -1) {
                badPixel.x_left = badPixel.x_right;
            } else if (badPixel.x_right == -1 && badPixel.x_left != -1) {
                badPixel.x_right = badPixel.x_left;
            }
            arrayList.add(badPixel);
        }
        return arrayList;
    }

    public static DoubleFrame createFrame(double[] dArray, int n, int n2, FrameListFromRaw.Reduce reduce, BandNames bandNames) {
        DoubleFrame doubleFrame = new DoubleFrame(new BandCount(n), new PixelWidth(n2 / reduce.x), bandNames);
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = doubleFrame.origframe[i];
            int n3 = 0;
            for (int j = 0; n3 < n2 && j < dArray2.length; n3 += reduce.x, ++j) {
                dArray2[j] = dArray[i * n2 + n3];
            }
        }
        return doubleFrame;
    }

    public static double[] createBackground(AverageFrame averageFrame) {
        double[] dArray = new double[averageFrame.rows.value * averageFrame.columns.value];
        int n = 0;
        for (int i = 0; i < averageFrame.rows.value; ++i) {
            int n2 = 0;
            while (n2 < averageFrame.columns.value) {
                dArray[n] = averageFrame.getFrameValue(i, n2);
                ++n2;
                ++n;
            }
        }
        return dArray;
    }

    public static boolean backgroundDifferent(HySpexHeader hySpexHeader) {
        for (int i = 0; i < hySpexHeader.background.length; ++i) {
            double d = hySpexHeader.background[i] - hySpexHeader.backgroundLast[i];
            if (d == 0.0) continue;
            return true;
        }
        return false;
    }

    public static double[] crop(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6) {
        if (dArray == null) {
            return null;
        }
        int n7 = n2 - n;
        int n8 = n4 - n3;
        double[] dArray2 = new double[n7 * n8];
        for (int i = 0; i < n7; ++i) {
            for (int j = 0; j < n8; ++j) {
                int n9 = (i + n) * n6 + (j + n3);
                int n10 = i * n8 + j;
                dArray2[n10] = dArray[n9];
            }
        }
        return dArray2;
    }

    public static double[] crop(double[] dArray, int n, int n2) {
        if (dArray == null) {
            return null;
        }
        int n3 = n2 - n;
        double[] dArray2 = new double[n3];
        System.arraycopy(dArray, n, dArray2, 0, n3);
        return dArray2;
    }

    public static HySpexHeader.HySpexHeaderType readHeaderType(File file) {
        HySpexHeader.HySpexHeaderType hySpexHeaderType;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileChannel fileChannel = fileInputStream.getChannel();
            ByteBuffer byteBuffer = HySpexHelper.readBuffer(fileChannel, 8);
            String string = HySpexHelper.readString(byteBuffer, 8);
            hySpexHeaderType = HySpexHeader.HySpexHeaderType.fromName(string);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return HySpexHeader.HySpexHeaderType.UNKNOWN;
            }
        }
        fileInputStream.close();
        return hySpexHeaderType;
    }

    public static RtFramePredictor.ReferenceConvertTo getDataFormat(File file) {
        if (HySpexHelper.isHySpexFile(file)) {
            try {
                return new HySpexHeader(file).getDataFormat();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return RtFramePredictor.ReferenceConvertTo.None;
    }

    public record LensInfo(String name, double distanceCm, double degree) {
    }

    public static class BadPixel {
        int x;
        int y;
        int x_left;
        int x_right;
        int y_up;
        int y_down;
    }
}

