/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.raw;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import se.prediktera.map.common.error.Logg;

public class HySpexParser {
    public static ByteBuffer readBuffer(FileChannel fileChannel, int n) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        fileChannel.read(byteBuffer);
        byteBuffer.position(0);
        return byteBuffer;
    }

    public static byte[] readBytes(ByteBuffer byteBuffer, int n) throws IOException {
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return byArray;
    }

    public static String readString(ByteBuffer byteBuffer, int n) throws IOException {
        return HySpexParser.readString(HySpexParser.readBytes(byteBuffer, n), n).trim();
    }

    public static String readString(byte[] byArray, int n) throws IOException {
        return new String(byArray, 0, n, StandardCharsets.UTF_8).trim();
    }

    public static int readInt(ByteBuffer byteBuffer) throws IOException {
        return byteBuffer.order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static int[] readInt(ByteBuffer byteBuffer, int n) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = byteBuffer.order(ByteOrder.LITTLE_ENDIAN).getInt();
        }
        return nArray;
    }

    public static double readDouble(ByteBuffer byteBuffer) throws IOException {
        return byteBuffer.order(ByteOrder.LITTLE_ENDIAN).getDouble();
    }

    public static float readFloat(ByteBuffer byteBuffer) {
        return byteBuffer.order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }

    public static double[] readDouble(ByteBuffer byteBuffer, int n) throws IOException {
        double[] dArray = new double[n];
        try {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = byteBuffer.order(ByteOrder.LITTLE_ENDIAN).getDouble();
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            Logg.warn((String)"HySpex header: buffer underflow", (Object[])new Object[0]);
            return null;
        }
        return dArray;
    }

    public static void putDoubleArray(ByteBuffer byteBuffer, double[] dArray, int n) {
        if (dArray == null) {
            dArray = new double[n];
        }
        for (double d : dArray) {
            byteBuffer.putDouble(d);
        }
    }

    public static void putIntArray(ByteBuffer byteBuffer, int[] nArray, int n) {
        if (nArray == null) {
            nArray = new int[n];
        }
        for (int n2 : nArray) {
            byteBuffer.putInt(n2);
        }
    }

    public static void putBytes(ByteBuffer byteBuffer, String string, int n) {
        byte[] byArray = new byte[n];
        if (string != null) {
            System.arraycopy(string.getBytes(), 0, byArray, 0, Math.min(n, string.length()));
        }
        byteBuffer.put(byArray);
    }

    public static void putBytes(ByteBuffer byteBuffer, byte[] byArray) {
        byteBuffer.put(byArray);
    }

    public static ByteBuffer createByteBuffer(byte[] byArray, int n, int n2) {
        return ByteBuffer.wrap(byArray, n, n2 - n);
    }
}

