/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.raw;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.util.BreezeProgressImpl;
import se.prediktera.breeze.common.util.ClasspathResourceFile;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.HySpexCamera;
import se.prediktera.breeze.hardware.runtime.BreezeRuntimeHelper;
import se.prediktera.breeze.hardware.tcp.Command;

public class HySpexTestManager {
    private File clallserialdllfile;
    private File clallserialdlltmpfile;
    private final List<HySpexCamera> cameras = new ArrayList<HySpexCamera>();

    public HySpexTestManager(final File file, int n) {
        int n2;
        this.clallserialdllfile = new File(BreezeRuntimeHelper.getBreezeRuntimePathForTest().getParentFile(), "clallserial.dll");
        if (this.clallserialdllfile.exists()) {
            this.clallserialdlltmpfile = new File(file, "clallserial.dll");
            this.clallserialdllfile.renameTo(this.clallserialdlltmpfile);
        }
        ClasspathResourceFile classpathResourceFile = new ClasspathResourceFile("realtime/fileReaderData/HySpex/testData.hyspex");
        HySpexTestManager.writeJsonFile(classpathResourceFile, file);
        for (n2 = 0; n2 < n; ++n2) {
            HySpexTestManager.writeSetFile(classpathResourceFile, file, n2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            HySpexCamera hySpexCamera = new HySpexCamera(this){

                @Override
                protected HySpexCamera.HySpexSettings createSettings() {
                    return new HySpexCamera.HySpexSettings(this, this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            super(remoteCamera);
                        }

                        @Override
                        protected List<Command.Argument> getListCameraNamesArguments() {
                            return List.of(new Command.Argument("SetFilePath", (Object)file.getAbsolutePath()));
                        }

                        @Override
                        public File getSettingsFile() {
                            return file;
                        }

                        @Override
                        public File getWhiteReferenceTargetFile() {
                            return new ClasspathResourceFile("realtime/fileReaderData/HySpex/reference_target.txt");
                        }

                        @Override
                        public CameraType getCameraType() {
                            return new CameraType("_OVERRIDE_1234" + this.this$1.getId());
                        }
                    };
                }

                @Override
                public boolean takeDarkAfterMeasurement() {
                    return true;
                }
            };
            hySpexCamera.setId(n2);
            hySpexCamera.connect(BreezeProgressImpl.createEmpty(), null);
            hySpexCamera.setFrameRate(new FrameRate(500.0f));
            this.cameras.add(hySpexCamera);
        }
    }

    private static void writeSetFile(File file, File file2, int n) {
        RawHeader rawHeader = RawHeader.findByRaw(file);
        try (PrintWriter printWriter = new PrintWriter(new File(file2, "VirtualCam_" + n + ".set"));){
            printWriter.println("filename = " + file.getAbsolutePath());
            printWriter.println("serialnumber = 1234" + n);
            printWriter.println("pixelsize_x = 0.2");
            printWriter.println("working_distance = 2");
            printWriter.println("background_end =");
            int n2 = rawHeader.pixelWidth().value * rawHeader.bandCount().value;
            for (int i = 0; i < n2; ++i) {
                printWriter.println("0.0");
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void writeJsonFile(File file, File file2) {
        try (PrintWriter printWriter = new PrintWriter(new File(file2, "hyspex_auxiliary.json"));){
            printWriter.println("{");
            printWriter.println("\t\"hyspex_version\": 1,");
            printWriter.println("\t\"stages\":");
            printWriter.println("\t{");
            printWriter.println("\t\t\"Virtual stage Translation\":");
            printWriter.println("\t\t{");
            printWriter.println("\t\t\t\"driver\": \"virtual\",");
            printWriter.println("\t\t\t\"type\": \"translation\",");
            printWriter.println("\t\t\t\"serialnumber\": \"1\",");
            printWriter.println("\t\t\t\"units\": \"cm\",");
            printWriter.println("\t\t\t\"maxspeed\": 100.0,");
            printWriter.println("\t\t\t\"start_position\": 0.0,");
            printWriter.println("\t\t\t\"end_position\": 200.0,");
            printWriter.println("\t\t\t\"movement_speed\": 5.0,");
            printWriter.println("\t\t\t\"acceleration\": 16.0,");
            printWriter.println("\t\t\t\"deceleration\": 20.0,");
            printWriter.println("\t\t\t\"description\": \"Virtual Stage, HySpex implementation.\"");
            printWriter.println("\t\t}");
            printWriter.println("\t}");
            printWriter.println("}");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public HySpexCamera getCamera(int n) {
        return this.cameras.get(n);
    }

    public void disconnect() {
        for (HySpexCamera hySpexCamera : this.cameras) {
            hySpexCamera.disconnect(BreezeProgressManager.createEmpty());
        }
        if (this.clallserialdlltmpfile != null) {
            this.clallserialdlltmpfile.renameTo(this.clallserialdllfile);
        }
    }
}

