/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.raw;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import se.prediktera.breeze.common.entry.measurement.MeasurementFileLocation;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawFileFrameWriter;
import se.prediktera.breeze.common.util.raw.RawFileWriter;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.entry.measurement.Measurement;

public class LiveRawFile
implements RawFile {
    private Measurement measurement;
    private final MeasurementFileLocation fileLocation;
    private final RawHeader header;
    private boolean hasBeenWritten = false;

    public LiveRawFile(RawHeader rawHeader, MeasurementFileLocation measurementFileLocation) {
        this.header = rawHeader;
        this.fileLocation = measurementFileLocation;
    }

    public LiveRawFile(Measurement measurement, MeasurementFileLocation measurementFileLocation) throws FileNotFoundException {
        this.measurement = measurement;
        this.fileLocation = measurementFileLocation;
        if (this.file() == null) {
            throw new RuntimeException("Cant create raw file from null file");
        }
        if (!this.file().exists()) {
            throw new FileNotFoundException(String.format("Cant create raw file, file not found: %s", this.file()));
        }
        this.header = RawHeader.findByRaw(this.file());
    }

    @Override
    public RawHeader header() {
        return this.header;
    }

    @Override
    public ByteBuffer readRawHeader() {
        return FrameListFromRaw.readRawHeader(this.file(), this.header());
    }

    @Override
    public List<RawFrame> readFrames() {
        return new FrameListFromRaw(this.file(), this.header());
    }

    @Override
    public File file() {
        return this.fileLocation.file(this.measurement);
    }

    public void write(Measurement measurement, List<? extends Frame> list, String string, Rectangle rectangle) {
        this.measurement = measurement;
        RawFileWriter.writeFramesAndHeader(this.file(), list, this.header(), string, rectangle, null);
        this.hasBeenWritten = true;
    }

    public void write(Measurement measurement, RawFileFrameWriter.Live live, String string) {
        this.measurement = measurement;
        LiveRawFile.writeFramesAndHeader(this.file(), live, this.header(), string);
        this.hasBeenWritten = true;
    }

    public boolean hasBeenWritten() {
        return this.hasBeenWritten;
    }

    public static void writeFramesAndHeader(File file, RawFileFrameWriter.Live live, RawHeader rawHeader, String string) {
        try {
            BandCount bandCount = live.getBandCount();
            PixelWidth pixelWidth = live.getPixelWidth();
            FrameCount frameCount = live.finish();
            Files.move(live.getFile().toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            rawHeader.writeByRaw(file, bandCount, pixelWidth, frameCount, string, null, 0L);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

