/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.raw;

import java.io.File;
import java.util.List;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.common.entry.measurement.MeasurementFileLocation;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNodeList;
import se.prediktera.breeze.common.realtime.segmentation.spatial.ManualSegmentation;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.measurement.metadata.MetaDataProperties;
import se.prediktera.breeze.entry.sample.SamplePath;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.evince.data.PixelDataHelper;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.view.preview.CropImagePanel;
import se.prediktera.breeze.frontend.common.view.preview.MeasurementPopup;
import se.prediktera.breeze.util.raw.GenericGridTiler;
import se.prediktera.breeze.util.raw.RawHelper;
import se.prediktera.map.common.progress.ProgressManager;

public class RawCropHelper {
    public static void cropMeasurementIntoGrid(BreezeFrame breezeFrame, final EntryMainPanel entryMainPanel, final Measurement measurement, final List list, final CropImagePanel cropImagePanel, final MeasurementPopup.EntryPopupCallback entryPopupCallback, final String string) {
        int n = cropImagePanel.getGridColumns();
        int n2 = cropImagePanel.getGridRows();
        BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(){

            @Override
            public void runAction() {
                1.cropMeasurementIntoGrid(this.getProgressManager(), entryMainPanel, measurement, list, cropImagePanel, string);
                entryPopupCallback.onFinished("Cropping");
                entryMainPanel.setDirty(true);
            }

            private static void cropMeasurementIntoGrid(BreezeProgressManager breezeProgressManager, EntryMainPanel entryMainPanel2, Measurement measurement2, List list2, CropImagePanel cropImagePanel2, String string2) {
                int n = cropImagePanel2.getGridColumns();
                int n8 = cropImagePanel2.getGridRows();
                int n9 = breezeProgressManager.setGroupMaximumAndReset(n * n8);
                GenericGridTiler.split(cropImagePanel2.left(), cropImagePanel2.top(), cropImagePanel2.rightPos(), cropImagePanel2.bottomPos(), n, n8, (n2, n3, n4, n5, n6, n7) -> {
                    String string2 = cropImagePanel2.hasGrid() ? String.format("%s_r%02d_c%02d", string2, n6 + 1, n7 + 1) : string2;
                    Measurement measurement2 = RawCropHelper.createMeasurement(measurement2, list2, string2);
                    RawCropHelper.cropImage(breezeProgressManager, n2, n3, n4, n5, measurement2, measurement2);
                    ApplyChanges.applyChanges(breezeProgressManager, List.of(measurement2), true);
                    if (!measurement2.equals(measurement2)) {
                        entryMainPanel2.addEntry(measurement2);
                    }
                    breezeProgressManager.incStepGroup(n9);
                });
            }
        }, "Cropping image into grids (" + n + "x" + n2 + ")");
    }

    public static Measurement createMeasurementUniqueName(Measurement measurement, List list, String string) {
        return RawCropHelper.createMeasurement(measurement, list, EntryMainHelper.getUniqueName(string, list));
    }

    public static Measurement createMeasurement(Measurement measurement, List list, String string) {
        EntryMainHelper.checkAndThrowIfExist(list, string);
        Group group = measurement.getParent();
        Measurement measurement2 = new Measurement(measurement.getFolder(), group);
        measurement2.getEntryData().setNameAndNewDate(string);
        measurement2.getEntryData().renewUid();
        measurement2.getMetaProperties().addProperty("Time", measurement2.getEntryData().getSimpleCreatedDate());
        measurement2.save();
        return measurement2;
    }

    public static void crop(BreezeFrame breezeFrame, EntryMainPanel entryMainPanel, CropImagePanel cropImagePanel, Measurement measurement, Measurement measurement2, MeasurementPopup.EntryPopupCallback entryPopupCallback) {
        RawCropHelper.crop(breezeFrame, entryMainPanel, cropImagePanel.left(), cropImagePanel.top(), cropImagePanel.rightPos(), cropImagePanel.bottomPos(), measurement, measurement2, entryPopupCallback);
    }

    public static void crop(BreezeFrame breezeFrame, final EntryMainPanel entryMainPanel, final int n, final int n2, final int n3, final int n4, final Measurement measurement, final Measurement measurement2, final MeasurementPopup.EntryPopupCallback entryPopupCallback) {
        BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(){

            @Override
            public void runAction() {
                RawCropHelper.cropImage(this.getProgressManager(), n, n2, n3, n4, measurement, measurement2);
                ApplyChanges.applyChanges(this.getProgressManager(), List.of(measurement2), true);
                if (!measurement.equals(measurement2)) {
                    entryMainPanel.addEntry(measurement2);
                }
                entryPopupCallback.onFinished("Cropping");
                entryMainPanel.setDirty(true);
            }
        }, "Cropping image");
    }

    public static void cropImage(ProgressManager progressManager, int n, int n2, int n3, int n4, Measurement measurement, Measurement measurement2) {
        progressManager.setInfoText("Cropping " + measurement.getName() + " into " + measurement2.getName());
        File file = measurement.rawFileThrowIfNotExists().file();
        int n5 = measurement.rawFile().header().pixelWidth().value;
        Double d = measurement.getMetaProperties().getMetaNumberNullIfMissing("FieldOfView");
        File file2 = new MeasurementFileLocation.Raw().file(measurement2);
        RawHelper.crop(file, n, n2, n3, n4, file2, true, true);
        ThumbnailManager.deleteAndRemoveMeasurementImageFromCache(measurement2);
        measurement2.clearCache();
        PixelDataHelper.clearSpectralMatrixCache();
        DataSetCache.clearParents(measurement2);
        RawCropHelper.moveManualSamples(measurement2.getWorkflow().getSegmentationNodes(), measurement2.getChildList(), n2, n);
        RawCropHelper.updateMetaProperties(measurement2, n5, d, measurement2.rawFile().header());
        measurement2.save();
    }

    public static void updateMetaProperties(Measurement measurement, int n, Double d, RawHeader rawHeader) {
        Double d2;
        MetaDataProperties metaDataProperties = measurement.getMetaProperties();
        int n2 = rawHeader.frameCount().value;
        metaDataProperties.addProperty("Frames", String.valueOf(n2));
        int n3 = rawHeader.pixelWidth().value;
        metaDataProperties.addProperty("PixelsPerLine", String.valueOf(n3));
        int n4 = rawHeader.bandCount().value;
        metaDataProperties.addProperty("Wavelength", String.valueOf(n4));
        if (d != null && n != n3) {
            double d3 = (double)n3 / (double)n * d;
            metaDataProperties.addProperty("FieldOfView", RtDataFormat.toString(d3));
        }
        if ((d2 = metaDataProperties.getMetaNumberNullIfMissing("Resolution")) != null) {
            metaDataProperties.addProperty("Length", String.valueOf((double)n2 * d2));
        }
    }

    public static void moveManualSamples(SegmentationNodeList segmentationNodeList, List<BasicSample> list, int n, int n2) {
        for (BasicSample basicSample : list) {
            SegmentationNode segmentationNode = segmentationNodeList.getSegmentation(basicSample.getSegmentationHashId());
            if (segmentationNode != null && segmentationNode.getFunction() instanceof ManualSegmentation) {
                for (SamplePath.SelectionPath selectionPath : basicSample.getSamplePath().getSelectionPaths()) {
                    for (int[] nArray : selectionPath.getOrCreateArrayClearContent()) {
                        nArray[0] = nArray[0] - n2;
                        nArray[1] = nArray[1] - n;
                    }
                }
            }
            RawCropHelper.moveManualSamples(segmentationNodeList, basicSample.getChildList(), n, n2);
        }
    }
}

