/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.raw;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.commons.io.FileUtils;
import se.prediktera.breeze.common.frame.DoubleFrame;
import se.prediktera.breeze.common.frame.FloatFrame;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.AverageFrame;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.measure.SpectralReferenceHelper;
import se.prediktera.breeze.common.util.raw.ExtraHeaderValues;
import se.prediktera.breeze.common.util.raw.FrameCube;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.FrameReader;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawFileFrameWriter;
import se.prediktera.breeze.common.util.raw.RawFileWriter;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.common.util.type.RtInterleave;
import se.prediktera.breeze.common.util.type.RtThreader;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.frontend.common.pp.wizard.importdata.PPImportDataHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.util.raw.HySpexHeader;
import se.prediktera.breeze.util.raw.HySpexHelper;

public class RawHelper {
    public static void extractWhite(File file, File file2, File file3, int[] nArray) {
        Object object;
        RawHeader rawHeader = RawHeader.findByRaw(file);
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = rawHeader.pixelWidth().value;
        boolean bl = nArray.length > 2 && nArray[2] >= 0 && nArray[3] - nArray[2] < n3;
        ByteBuffer byteBuffer = FrameListFromRaw.readRawHeader(file, rawHeader);
        if (byteBuffer.capacity() > 0) {
            try {
                object = new HySpexHeader(byteBuffer);
                ((HySpexHeader)object).crop(n, n2, 0, n3, 0, ((HySpexHeader)object).spectralSize);
                byteBuffer = ((HySpexHeader)object).createHeader();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = FileHelper.createTempFileInWorkspace("raw");
        int n4 = n2 - n;
        try (RawFileFrameWriter rawFileFrameWriter = new RawFileFrameWriter((File)object, rawHeader.bandCount(), rawHeader.pixelWidth(), bl ? DataSize.FLOAT_4 : rawHeader.dataSize());
             FrameReader.FrameIterator frameIterator = new FrameReader(file, rawHeader).iterator();){
            Object object2;
            rawHeader.setFile(RawHeader.findHeaderFileByRaw(file2));
            rawHeader.setFrameCount(new FrameCount(n4));
            rawHeader.setyStart(n);
            int n5 = 0;
            if (byteBuffer != null) {
                rawFileFrameWriter.writeHeader(byteBuffer);
                n5 = byteBuffer.limit();
            }
            if (bl) {
                rawHeader.setDataSize(DataSize.FLOAT_4);
            }
            frameIterator.skip(n);
            if (bl) {
                object2 = HySpexHelper.getReFrame(file);
                FloatFrame floatFrame = RawHelper.getAverageDark(file3, rawHeader);
                int n6 = nArray[2];
                int n7 = nArray[3];
                RawFrame rawFrame = RawFrame.createFrame(DataSize.FLOAT_4, rawHeader.bandCount(), rawHeader.pixelWidth(), rawHeader.bandNames());
                double[] dArray = new double[rawHeader.bandCount().value];
                for (int i = 0; i < n4 && frameIterator.hasNext(); ++i) {
                    int n8;
                    int n9;
                    RawFrame rawFrame2 = frameIterator.next();
                    for (n9 = 0; n9 < dArray.length; ++n9) {
                        for (n8 = n6; n8 < n7; ++n8) {
                            int n10 = n9;
                            dArray[n10] = dArray[n10] + (double)(rawFrame2.getFrameValue(n9, n8) - floatFrame.getFrameValue(n9, n8));
                        }
                    }
                    n9 = 0;
                    while (n9 < dArray.length) {
                        int n11 = n9++;
                        dArray[n11] = dArray[n11] / (double)(n7 - n6);
                    }
                    n9 = rawFrame2.columns.value;
                    if (object2 != null && ((Frame)object2).getRows().value == dArray.length) {
                        for (n8 = 0; n8 < dArray.length; ++n8) {
                            for (var25_31 = 0; var25_31 < n9; ++var25_31) {
                                rawFrame.setFrameValue(n8, var25_31, (float)(dArray[n8] * ((DoubleFrame)object2).getFrameValueNative(n8, var25_31) + (double)floatFrame.getFrameValue(n8, var25_31)));
                            }
                        }
                    } else {
                        for (n8 = 0; n8 < dArray.length; ++n8) {
                            for (var25_31 = 0; var25_31 < n9; ++var25_31) {
                                rawFrame.setFrameValue(n8, var25_31, (float)dArray[n8] + floatFrame.getFrameValue(n8, var25_31));
                            }
                        }
                    }
                    rawFileFrameWriter.writeFrame(rawFrame);
                }
            } else {
                for (int i = 0; i < n4 && frameIterator.hasNext(); ++i) {
                    rawFileFrameWriter.writeFrame(frameIterator.next());
                }
            }
            object2 = new ExtraHeaderValues();
            ((ExtraHeaderValues)object2).addValues(((ExtraHeaderValues)object2).updateParserGeoValues(rawHeader.getParser(), 0, n));
            rawHeader.writeByRaw(file2, rawHeader.bandCount(), rawHeader.pixelWidth(), rawFileFrameWriter.lineCount(), rawHeader.getDescription(), (ExtraHeaderValues)object2, n5);
        }
        FileHelper.moveFile((File)object, file2);
        if (file3 != null && !file3.exists()) {
            new FrameCube(rawHeader.bandCount(), rawHeader.pixelWidth(), new FrameCount(1), rawHeader.bandNames(), rawHeader.dataSize()).save(file3);
        }
    }

    private static FloatFrame getAverageDark(File file, RawHeader rawHeader) {
        if (file != null && file.exists()) {
            return new AverageFrame(new FrameListFromRaw(file));
        }
        return new FloatFrame(rawHeader.bandCount(), rawHeader.pixelWidth(), rawHeader.bandNames());
    }

    public static void crop(File file, int n, int n2, int n3, int n4, File file2, boolean bl, boolean bl2) {
        File file3 = RawHeader.findHeaderFileByRaw(file);
        RawHeader rawHeader = new RawHeader(file3);
        int n5 = rawHeader.bandCount().value;
        int n6 = RawHelper.getValueWithin(n, rawHeader.pixelWidth().value, true);
        int n7 = RawHelper.getValueWithin(n2, rawHeader.frameCount().value, true);
        int n8 = RawHelper.getValueWithin(n3, rawHeader.pixelWidth().value, false);
        int n9 = RawHelper.getValueWithin(n4, rawHeader.frameCount().value, false);
        File file4 = FileHelper.createTempFileInWorkspace("raw");
        int n10 = n9 - n7;
        ByteBuffer byteBuffer = FrameListFromRaw.readRawHeader(file, rawHeader);
        if (byteBuffer.capacity() > 0) {
            try {
                HySpexHeader hySpexHeader = new HySpexHeader(byteBuffer);
                hySpexHeader.crop(n7, n9, n6, n8, 0, hySpexHeader.spectralSize);
                byteBuffer = hySpexHeader.createHeader();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n11 = n8 - n6;
        PixelWidth pixelWidth = new PixelWidth(n11);
        try (RawFileFrameWriter rawFileFrameWriter = new RawFileFrameWriter(file4, rawHeader.bandCount(), pixelWidth, rawHeader.dataSize());
             FrameReader.FrameIterator frameIterator = new FrameReader(file, rawHeader).iterator();){
            Object object;
            rawHeader.setFrameCount(new FrameCount(n10));
            rawHeader.setxStart(n6);
            rawHeader.setyStart(n7);
            int n12 = 0;
            if (byteBuffer != null) {
                rawFileFrameWriter.writeHeader(byteBuffer);
                n12 = byteBuffer.limit();
            }
            frameIterator.skip(n7);
            if (n11 < rawHeader.pixelWidth().value || !file.equals(file2)) {
                Object object2;
                rawHeader.setPixelWidth(pixelWidth);
                object = Frame.createFrame(rawHeader.dataSize(), rawHeader.bandCount(), pixelWidth, rawHeader.bandNames());
                for (int i = 0; i < n10 && frameIterator.hasNext(); ++i) {
                    object2 = frameIterator.next();
                    int n13 = n6;
                    int n14 = 0;
                    while (n13 < n8) {
                        for (int j = 0; j < n5; ++j) {
                            ((Frame)object).setFrameValue(j, n14, ((Frame)object2).getFrameValue(j, n13));
                        }
                        ++n13;
                        ++n14;
                    }
                    rawFileFrameWriter.writeFrame((Frame)object);
                }
                File file5 = SpectralReferenceHelper.getWhiteReferenceFile(file);
                if (bl && file5.exists()) {
                    RawHelper.crop(file5, n6, 0, n8, -1, SpectralReferenceHelper.getWhiteReferenceFile(file2), false, false);
                }
                object2 = SpectralReferenceHelper.getDarkReferenceFile(file);
                if (bl2 && ((File)object2).exists()) {
                    RawHelper.crop((File)object2, n6, 0, n8, -1, SpectralReferenceHelper.getDarkReferenceFile(file2), false, false);
                }
            } else {
                for (int i = 0; i < n10 && frameIterator.hasNext(); ++i) {
                    rawFileFrameWriter.writeFrame(frameIterator.next());
                }
            }
            object = new ExtraHeaderValues();
            ((ExtraHeaderValues)object).addValues(((ExtraHeaderValues)object).updateParserGeoValues(rawHeader.getParser(), n6, n7));
            rawHeader.writeByRaw(file2, rawHeader.bandCount(), rawHeader.pixelWidth(), rawFileFrameWriter.lineCount(), rawHeader.getDescription(), (ExtraHeaderValues)object, n12);
        }
        FileHelper.moveFile(file4, file2);
    }

    private static int getValueWithin(int n, int n2, boolean bl) {
        if (n < 0 || n >= n2) {
            return bl ? 0 : n2;
        }
        return n;
    }

    public static void switchDarkReference(File file, Frame frame, File file2) {
        RawHeader rawHeader = RawHeader.findByRaw(file);
        FrameListFromRaw frameListFromRaw = new FrameListFromRaw(file, rawHeader);
        FrameListFromRaw frameListFromRaw2 = new FrameListFromRaw(file2);
        AverageFrame averageFrame = new AverageFrame(frameListFromRaw2);
        for (int i = 0; i < averageFrame.getColumns().value; ++i) {
            for (int j = 0; j < averageFrame.getRows().value; ++j) {
                float f = averageFrame.getFrameValue(j, i);
                averageFrame.setFrameValue(j, i, f - frame.getFrameValue(j, i));
            }
        }
        for (RawFrame rawFrame : frameListFromRaw) {
            for (int i = 0; i < rawFrame.getColumns().value; ++i) {
                for (int j = 0; j < rawFrame.getRows().value; ++j) {
                    float f = rawFrame.getFrameValue(j, i);
                    rawFrame.setFrameValue(j, i, f + averageFrame.getFrameValue(j, i));
                }
            }
        }
        RawFileWriter.writeFramesAndHeader(file, frameListFromRaw, rawHeader, "Created by Breeze");
    }

    public static void replacePixelsWithZero(BreezeProgress breezeProgress, File file, PPImportDataHelper.BadPixels badPixels) {
        RawHeader rawHeader = RawHeader.findByRaw(file);
        long l = rawHeader.getHeaderOffset();
        int n = rawHeader.pixelWidth().value;
        int n2 = rawHeader.bandCount().value;
        int n3 = rawHeader.dataSize().size;
        RtInterleave rtInterleave = rawHeader.interleave();
        int n4 = n * n3;
        int n5 = n2 * n4;
        byte[] byArray = new byte[n5];
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");){
            breezeProgress.setInfoText("Replacing saturated pixels with zero");
            breezeProgress.setMaximumAndReset(badPixels.list.size());
            for (PPImportDataHelper.BadPixels.BadFramePixels badFramePixels : badPixels.list) {
                long l2 = (long)badFramePixels.index * (long)n5;
                long l3 = l + l2;
                randomAccessFile.seek(l3);
                randomAccessFile.read(byArray);
                for (Integer n6 : badFramePixels.list) {
                    if (!rtInterleave.equals((Object)RtInterleave.BIL)) continue;
                    int n7 = n6 * n3;
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n3; ++j) {
                            byArray[n7 + j] = 0;
                        }
                        n7 += n4;
                    }
                }
                randomAccessFile.seek(l3);
                randomAccessFile.write(byArray);
                breezeProgress.incStep();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void replaceIgnoredPixelsWithZero(BreezeProgress breezeProgress, File file, final float f, final boolean bl) {
        RawHeader rawHeader = RawHeader.findByRaw(file);
        breezeProgress.setInfoText("Replacing data ignore values with zero");
        breezeProgress.setMaximumAndReset(rawHeader.frameCount().value);
        File file2 = FileHelper.createTempFileInWorkspace("raw");
        ByteBuffer byteBuffer = FrameListFromRaw.readRawHeader(file, rawHeader);
        try (RawFileFrameWriter rawFileFrameWriter = new RawFileFrameWriter(file2, rawHeader.bandCount(), rawHeader.pixelWidth(), rawHeader.dataSize());
             FrameReader.FrameIterator frameIterator = new FrameReader(file, rawHeader).iterator();){
            if (byteBuffer != null) {
                rawFileFrameWriter.writeHeader(byteBuffer);
            }
            while (frameIterator.hasNext()) {
                final RawFrame rawFrame = frameIterator.next();
                final int n = rawFrame.getRows().value;
                RtThreader rtThreader = new RtThreader(){

                    @Override
                    protected void doOp(boolean bl2, int n3, int n2) {
                        block0: for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < n; ++j) {
                                if (rawFrame.getFrameValue(j, i) != f) continue;
                                if (bl) {
                                    for (int k = 0; k < n; ++k) {
                                        rawFrame.setFrameValue(k, i, 0.0f);
                                    }
                                    continue block0;
                                }
                                rawFrame.setFrameValue(j, i, 0.0f);
                            }
                        }
                    }
                };
                rtThreader.execute(rawFrame.getColumns().value);
                rawFileFrameWriter.writeFrame(rawFrame);
                breezeProgress.incStep();
            }
        }
        FileHelper.moveFile(file2, file);
    }

    public static FrameCube mirrorHorizontal(RawFile rawFile) {
        RawHeader rawHeader = rawFile.header();
        FrameCube frameCube = new FrameCube(rawHeader.bandCount(), rawHeader.pixelWidth(), rawHeader.frameCount(), rawHeader.bandNames(), rawHeader.dataSize());
        RawHelper.setCubeHeaderValues(rawHeader, frameCube);
        int n = frameCube.getWidth().value;
        int n2 = frameCube.getBandCount().value;
        List<RawFrame> list = rawFile.readFrames();
        for (int i = 0; i < list.size(); ++i) {
            RawFrame rawFrame = list.get(i);
            for (int j = 0; j < n / 2 + 1; ++j) {
                int n3 = n - j - 1;
                for (int k = 0; k < n2; ++k) {
                    frameCube.setValue(i, k, j, rawFrame.getFrameValue(k, n3));
                    frameCube.setValue(i, k, n3, rawFrame.getFrameValue(k, j));
                }
            }
        }
        return frameCube;
    }

    public static FrameCube mirrorVertical(RawFile rawFile) {
        RawHeader rawHeader = rawFile.header();
        FrameCube frameCube = new FrameCube(rawHeader.bandCount(), rawHeader.pixelWidth(), rawHeader.frameCount(), rawHeader.bandNames(), rawHeader.dataSize());
        RawHelper.setCubeHeaderValues(rawHeader, frameCube);
        int n = frameCube.getWidth().value;
        int n2 = frameCube.getBandCount().value;
        List<RawFrame> list = rawFile.readFrames();
        int n3 = list.size();
        for (int i = 0; i < list.size() / 2 + 1; ++i) {
            int n4 = n3 - i - 1;
            RawFrame rawFrame = list.get(i);
            RawFrame rawFrame2 = list.get(n4);
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n2; ++k) {
                    frameCube.setValue(i, k, j, rawFrame2.getFrameValue(k, j));
                    frameCube.setValue(n4, k, j, rawFrame.getFrameValue(k, j));
                }
            }
        }
        return frameCube;
    }

    public static FrameCube binSpectral(RawFile rawFile, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Bin number must be greater than 0");
        }
        RawHeader rawHeader = rawFile.header();
        List<RawFrame> list = rawFile.readFrames();
        int n2 = list.size();
        int n3 = rawHeader.bandCount().value;
        int n4 = (int)Math.ceil((float)n3 / (float)n);
        BandNames bandNames = rawHeader.bandNames();
        String[] stringArray = new String[n4];
        int n5 = 0;
        int n6 = rawHeader.pixelWidth().value;
        FrameCube frameCube = new FrameCube(new BandCount(n4), rawHeader.pixelWidth(), new FrameCount(n2), null, rawHeader.dataSize());
        RawHelper.setCubeHeaderValues(rawHeader, frameCube);
        RgbBands rgbBands = rawHeader.rgbBands();
        frameCube.setRgbBands(new RgbBands(rgbBands.get(0) / n, rgbBands.get(1) / n, rgbBands.get(2) / n));
        for (int i = 0; i < n3; i += n) {
            Object object;
            int n7;
            float f = 0.0f;
            int n8 = Math.min(n, n3 - i);
            for (n7 = 0; n7 < n8; ++n7) {
                object = bandNames.get(i + n7);
                f += RtDataFormat.toNumberFloat((String)object);
            }
            stringArray[n5++] = RtDataFormat.toString(f / (float)n8);
            for (n7 = 0; n7 < n2; ++n7) {
                object = list.get(n7);
                for (int j = 0; j < n6; ++j) {
                    float f2 = 0.0f;
                    for (int k = 0; k < n8; ++k) {
                        f2 += ((Frame)object).getFrameValue(i + k, j);
                    }
                    frameCube.setValue(n7, n5 - 1, j, f2 / (float)n8);
                }
            }
        }
        frameCube.setBandNames(new BandNames(stringArray));
        return frameCube;
    }

    public static FrameCube binSpatialPixels(RawFile rawFile, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Bin number must be greater than 0");
        }
        RawHeader rawHeader = rawFile.header();
        List<RawFrame> list = rawFile.readFrames();
        int n2 = list.size();
        int n3 = rawHeader.bandNames().count().value;
        int n4 = rawHeader.pixelWidth().value;
        int n5 = (int)Math.ceil((float)n4 / (float)n);
        int n6 = n4 % n;
        FrameCube frameCube = new FrameCube(rawHeader.bandCount(), new PixelWidth(n5), new FrameCount(n2), rawHeader.bandNames(), rawHeader.dataSize());
        RawHelper.setCubeHeaderValues(rawHeader, frameCube);
        for (int i = 0; i < n2; ++i) {
            RawFrame rawFrame = list.get(i);
            for (int j = 0; j < n3; ++j) {
                int n7 = 0;
                for (int k = 0; k <= n4 - n; k += n) {
                    float f = 0.0f;
                    for (int i2 = 0; i2 < n; ++i2) {
                        f += rawFrame.getFrameValue(j, k + i2);
                    }
                    frameCube.setValue(i, j, n7++, f / (float)n);
                }
                if (n6 <= 0) continue;
                float f = 0.0f;
                for (int k = 0; k < n6; ++k) {
                    f += rawFrame.getFrameValue(j, n4 - n6 + k);
                }
                frameCube.setValue(i, j, n7, f / (float)n6);
            }
        }
        return frameCube;
    }

    public static FrameCube binSpatialFrames(RawFile rawFile, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Bin number must be greater than 0");
        }
        RawHeader rawHeader = rawFile.header();
        List<RawFrame> list = rawFile.readFrames();
        int n2 = list.size();
        int n3 = rawHeader.bandNames().count().value;
        int n4 = rawHeader.pixelWidth().value;
        int n5 = (int)Math.ceil((float)n2 / (float)n);
        int n6 = n2 % n;
        FrameCube frameCube = new FrameCube(rawHeader.bandCount(), rawHeader.pixelWidth(), new FrameCount(n5), rawHeader.bandNames(), rawHeader.dataSize());
        RawHelper.setCubeHeaderValues(rawHeader, frameCube);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n7 = 0;
                for (int k = 0; k <= n2 - n; k += n) {
                    float f = 0.0f;
                    for (int i2 = 0; i2 < n; ++i2) {
                        RawFrame rawFrame = list.get(k + i2);
                        f += rawFrame.getFrameValue(i, j);
                    }
                    frameCube.setValue(n7++, i, j, f / (float)n);
                }
                if (n6 <= 0) continue;
                float f = 0.0f;
                for (int k = 0; k < n6; ++k) {
                    RawFrame rawFrame = list.get(n2 - n6 + k);
                    f += rawFrame.getFrameValue(i, j);
                }
                frameCube.setValue(n7, i, j, f / (float)n6);
            }
        }
        return frameCube;
    }

    public static FrameCube rotateLeft(RawFile rawFile) {
        List<RawFrame> list = rawFile.readFrames();
        RawHeader rawHeader = rawFile.header();
        FrameCube frameCube = new FrameCube(rawHeader.bandCount(), new PixelWidth(rawHeader.frameCount().value), new FrameCount(rawHeader.pixelWidth().value), rawHeader.bandNames(), rawHeader.dataSize());
        RawHelper.setCubeHeaderValues(rawHeader, frameCube);
        int n = rawHeader.bandCount().value;
        int n2 = rawHeader.pixelWidth().value;
        int n3 = frameCube.getWidth().value;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    RawFrame rawFrame = list.get(k);
                    frameCube.setValue(n2 - 1 - j, i, k, rawFrame.getFrameValue(i, j));
                }
            }
        }
        return frameCube;
    }

    public static FrameCube rotateRight(RawFile rawFile) {
        RawHeader rawHeader = rawFile.header();
        FrameCube frameCube = new FrameCube(rawHeader.bandCount(), new PixelWidth(rawHeader.frameCount().value), new FrameCount(rawHeader.pixelWidth().value), rawHeader.bandNames(), rawHeader.dataSize());
        RawHelper.setCubeHeaderValues(rawHeader, frameCube);
        int n = rawHeader.bandCount().value;
        int n2 = rawHeader.pixelWidth().value;
        int n3 = rawHeader.frameCount().value;
        int n4 = frameCube.getWidth().value;
        List<RawFrame> list = rawFile.readFrames();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n4; ++k) {
                    RawFrame rawFrame = list.get(k);
                    frameCube.setValue(j, i, n3 - 1 - k, rawFrame.getFrameValue(i, j));
                }
            }
        }
        return frameCube;
    }

    public static FrameCube pseudoReflectance(BreezeProgressManager breezeProgressManager, Measurement measurement) {
        int n;
        RawFile rawFile = measurement.rawFile();
        RawHeader rawHeader = rawFile.header();
        int n2 = rawHeader.pixelWidth().value;
        int n3 = rawHeader.bandCount().value;
        double[] dArray = new double[n3];
        int n4 = 0;
        breezeProgressManager.setMaximumAndReset(rawHeader.frameCount().value);
        try (Object object = new FrameReader(rawFile).iterator();){
            while (((FrameReader.FrameIterator)object).hasNext()) {
                RawFrame rawFrame = ((FrameReader.FrameIterator)object).next();
                for (n = 0; n < n2; ++n) {
                    int n5;
                    boolean bl = false;
                    for (n5 = 0; n5 < n3; ++n5) {
                        if (rawFrame.getFrameValue(n5, n) == 0.0f) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    for (n5 = 0; n5 < n3; ++n5) {
                        int n6 = n5;
                        dArray[n6] = dArray[n6] + (double)rawFrame.getFrameValue(n5, n);
                    }
                    ++n4;
                }
                breezeProgressManager.incStep();
            }
        }
        if (n4 > 0) {
            object = new FrameCube(rawHeader.bandCount(), rawHeader.pixelWidth(), new FrameCount(1), rawHeader.bandNames(), DataSize.FLOAT_4);
            for (int i = 0; i < dArray.length; ++i) {
                int n7 = i;
                dArray[n7] = dArray[n7] / (double)n4;
                for (n = 0; n < n2; ++n) {
                    ((FrameCube)object).setValue(0, i, n, (float)dArray[i]);
                }
            }
            RawFileWriter.writeFramesAndHeader(measurement.getFolder(), "whiteref_measurement", ((FrameCube)object).getFrameList());
        }
        return null;
    }

    private static void setCubeHeaderValues(RawHeader rawHeader, FrameCube frameCube) {
        frameCube.setRgbBands(rawHeader.rgbBands());
        frameCube.setReferenceTarget(rawHeader.getReferenceTarget());
        frameCube.setDescription(rawHeader.getDescription());
        ExtraHeaderValues extraHeaderValues = new ExtraHeaderValues();
        extraHeaderValues.addValues(rawHeader.getParser());
        frameCube.setExtra(extraHeaderValues);
    }

    public static FrameCube revertBackup(BreezeProgressManager breezeProgressManager, Measurement measurement, RawFile rawFile) {
        File file = measurement.getFolder();
        File file2 = new File(file, "backup");
        FileHelper.copyFolder(breezeProgressManager, file2, file);
        RawHelper.deleteBackup(measurement);
        measurement.reload(true);
        return null;
    }

    public static FrameCube deleteBackup(Measurement measurement) {
        try {
            File file = new File(measurement.getFolder(), "backup");
            FileUtils.deleteDirectory((File)file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public static FrameCube realginBackup(BreezeProgressManager breezeProgressManager, Measurement measurement, RawFile rawFile) {
        File file = measurement.getFolder();
        FileHelper.copyFolder(breezeProgressManager, new File(file, "backup"), file);
        Camera.TransformAlgorithm transformAlgorithm = BreezeProperties.getInstance().getMultiCameraRealignAlgorithm();
        String string = switch (transformAlgorithm) {
            case Camera.TransformAlgorithm.SurfAndRansac -> BreezeProperties.getInstance().getMultiCameraSurfRealignmentOptions();
            case Camera.TransformAlgorithm.SiftAndRansac -> BreezeProperties.getInstance().getMultiCameraSiftRealignmentOptions();
            default -> null;
        };
        String string2 = BreezeProperties.getInstance().getMultiCameraRotate();
        TcpManager.getInstance().transformData(breezeProgressManager, List.of(measurement), transformAlgorithm, false, string, string2);
        measurement.reload(true);
        return null;
    }
}

