/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.raw;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.BreezeProgressImpl;
import se.prediktera.breeze.common.util.raw.FrameCube;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.RawFileImpl;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.util.raw.RawHelper;

public class RawHelperTest {
    @Test
    public void testBinSpectral() {
        FrameCube frameCube = new FrameCube(new BandCount(4), new PixelWidth(2), new FrameCount(2), new BandNames("10", "20", "30.5", "40"), DataSize.SHORT_2);
        frameCube.setDefaultSpectrum(new float[]{10.0f, 20.0f, 30.0f, 40.0f});
        frameCube.setRgbBands(new RgbBands(0, 1, 2));
        FrameCube.FrameCubeRawFile frameCubeRawFile = new FrameCube.FrameCubeRawFile(frameCube);
        FrameCube frameCube2 = RawHelper.binSpectral(frameCubeRawFile, 2);
        MatcherAssert.assertThat((Object)frameCube2.getBandCount().value, (Matcher)Matchers.is((Object)2));
        BandNames bandNames = frameCube2.getBandNames();
        MatcherAssert.assertThat((Object)bandNames.get(0), (Matcher)Matchers.is((Object)"15"));
        MatcherAssert.assertThat((Object)bandNames.get(1), (Matcher)Matchers.is((Object)"35.25"));
        for (int i = 0; i < frameCube2.getLines().value; ++i) {
            for (int j = 0; j < frameCube2.getWidth().value; ++j) {
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 0, j)), (Matcher)Matchers.is((Object)Float.valueOf(15.0f)));
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 1, j)), (Matcher)Matchers.is((Object)Float.valueOf(35.0f)));
            }
        }
    }

    @Test
    public void testBinSpectralUnEven() {
        FrameCube frameCube = new FrameCube(new BandCount(5), new PixelWidth(2), new FrameCount(2), new BandNames("10", "20", "30.5", "40", "50"), DataSize.SHORT_2);
        frameCube.setDefaultSpectrum(new float[]{10.0f, 20.0f, 30.0f, 40.0f, 50.0f});
        frameCube.setRgbBands(new RgbBands(0, 1, 2));
        FrameCube.FrameCubeRawFile frameCubeRawFile = new FrameCube.FrameCubeRawFile(frameCube);
        FrameCube frameCube2 = RawHelper.binSpectral(frameCubeRawFile, 2);
        MatcherAssert.assertThat((Object)frameCube2.getBandCount().value, (Matcher)Matchers.is((Object)3));
        BandNames bandNames = frameCube2.getBandNames();
        MatcherAssert.assertThat((Object)bandNames.get(0), (Matcher)Matchers.is((Object)"15"));
        MatcherAssert.assertThat((Object)bandNames.get(1), (Matcher)Matchers.is((Object)"35.25"));
        MatcherAssert.assertThat((Object)bandNames.get(2), (Matcher)Matchers.is((Object)"50"));
        for (int i = 0; i < frameCube2.getLines().value; ++i) {
            for (int j = 0; j < frameCube2.getWidth().value; ++j) {
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 0, j)), (Matcher)Matchers.is((Object)Float.valueOf(15.0f)));
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 1, j)), (Matcher)Matchers.is((Object)Float.valueOf(35.0f)));
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 2, j)), (Matcher)Matchers.is((Object)Float.valueOf(50.0f)));
            }
        }
    }

    @Test
    public void testBinSpatialPixels() {
        FrameCube frameCube = new FrameCube(new BandCount(2), new PixelWidth(4), new FrameCount(2), DataSize.SHORT_2);
        frameCube.setDefaultSpectrum(new float[]{10.0f, 20.0f});
        frameCube.setRgbBands(new RgbBands(0, 1, 2));
        FrameCube.FrameCubeRawFile frameCubeRawFile = new FrameCube.FrameCubeRawFile(frameCube);
        FrameCube frameCube2 = RawHelper.binSpatialPixels(frameCubeRawFile, 2);
        MatcherAssert.assertThat((Object)frameCube2.getWidth().value, (Matcher)Matchers.is((Object)2));
        for (int i = 0; i < frameCube2.getLines().value; ++i) {
            for (int j = 0; j < frameCube2.getWidth().value; ++j) {
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 0, j)), (Matcher)Matchers.is((Object)Float.valueOf(10.0f)));
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 1, j)), (Matcher)Matchers.is((Object)Float.valueOf(20.0f)));
            }
        }
    }

    @Test
    public void testBinSpatialPixelsUnEven() {
        FrameCube frameCube = new FrameCube(new BandCount(2), new PixelWidth(5), new FrameCount(2), DataSize.SHORT_2);
        frameCube.setDefaultSpectrum(new float[]{10.0f, 20.0f});
        frameCube.setRgbBands(new RgbBands(0, 1, 2));
        FrameCube.FrameCubeRawFile frameCubeRawFile = new FrameCube.FrameCubeRawFile(frameCube);
        FrameCube frameCube2 = RawHelper.binSpatialPixels(frameCubeRawFile, 2);
        MatcherAssert.assertThat((Object)frameCube2.getWidth().value, (Matcher)Matchers.is((Object)3));
        for (int i = 0; i < frameCube2.getLines().value; ++i) {
            for (int j = 0; j < frameCube2.getWidth().value; ++j) {
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 0, j)), (Matcher)Matchers.is((Object)Float.valueOf(10.0f)));
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 1, j)), (Matcher)Matchers.is((Object)Float.valueOf(20.0f)));
            }
        }
    }

    @Test
    public void testBinSpatialFrames() {
        FrameCube frameCube = new FrameCube(new BandCount(2), new PixelWidth(2), new FrameCount(4), DataSize.SHORT_2);
        frameCube.setDefaultSpectrum(new float[]{10.0f, 20.0f});
        frameCube.setRgbBands(new RgbBands(0, 1, 2));
        FrameCube.FrameCubeRawFile frameCubeRawFile = new FrameCube.FrameCubeRawFile(frameCube);
        FrameCube frameCube2 = RawHelper.binSpatialFrames(frameCubeRawFile, 2);
        MatcherAssert.assertThat((Object)frameCube2.getLines().value, (Matcher)Matchers.is((Object)2));
        for (int i = 0; i < frameCube2.getLines().value; ++i) {
            for (int j = 0; j < frameCube2.getWidth().value; ++j) {
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 0, j)), (Matcher)Matchers.is((Object)Float.valueOf(10.0f)));
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 1, j)), (Matcher)Matchers.is((Object)Float.valueOf(20.0f)));
            }
        }
    }

    @Test
    public void testBinSpatialFramesUnEven() {
        FrameCube frameCube = new FrameCube(new BandCount(2), new PixelWidth(2), new FrameCount(5), DataSize.SHORT_2);
        frameCube.setDefaultSpectrum(new float[]{10.0f, 20.0f});
        frameCube.setRgbBands(new RgbBands(0, 1, 2));
        FrameCube.FrameCubeRawFile frameCubeRawFile = new FrameCube.FrameCubeRawFile(frameCube);
        FrameCube frameCube2 = RawHelper.binSpatialFrames(frameCubeRawFile, 2);
        MatcherAssert.assertThat((Object)frameCube2.getLines().value, (Matcher)Matchers.is((Object)3));
        for (int i = 0; i < frameCube2.getLines().value; ++i) {
            for (int j = 0; j < frameCube2.getWidth().value; ++j) {
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 0, j)), (Matcher)Matchers.is((Object)Float.valueOf(10.0f)));
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 1, j)), (Matcher)Matchers.is((Object)Float.valueOf(20.0f)));
            }
        }
    }

    @Test
    public void testTransformHorizontalPixelsEven() {
        FrameCube frameCube = new FrameCube(new BandCount(2), new PixelWidth(2), new FrameCount(5), DataSize.SHORT_2);
        frameCube.setDefaultSpectrum(new float[]{10.0f, 20.0f});
        frameCube.setRgbBands(new RgbBands(0, 1, 2));
        FrameCube.FrameCubeRawFile frameCubeRawFile = new FrameCube.FrameCubeRawFile(frameCube);
        FrameCube frameCube2 = RawHelper.mirrorHorizontal(frameCubeRawFile);
        for (int i = 0; i < frameCube2.getLines().value; ++i) {
            for (int j = 0; j < frameCube2.getWidth().value; ++j) {
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 0, j)), (Matcher)Matchers.is((Object)Float.valueOf(10.0f)));
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 1, j)), (Matcher)Matchers.is((Object)Float.valueOf(20.0f)));
            }
        }
    }

    @Test
    public void testTransformHorizontalPixelsUnEven() {
        FrameCube frameCube = new FrameCube(new BandCount(2), new PixelWidth(3), new FrameCount(5), DataSize.SHORT_2);
        frameCube.setDefaultSpectrum(new float[]{10.0f, 20.0f});
        frameCube.setRgbBands(new RgbBands(0, 1, 2));
        FrameCube.FrameCubeRawFile frameCubeRawFile = new FrameCube.FrameCubeRawFile(frameCube);
        FrameCube frameCube2 = RawHelper.mirrorHorizontal(frameCubeRawFile);
        for (int i = 0; i < frameCube2.getLines().value; ++i) {
            for (int j = 0; j < frameCube2.getWidth().value; ++j) {
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 0, j)), (Matcher)Matchers.is((Object)Float.valueOf(10.0f)));
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 1, j)), (Matcher)Matchers.is((Object)Float.valueOf(20.0f)));
            }
        }
    }

    @Test
    public void testTransformVerticalEvenFrames() {
        FrameCube frameCube = new FrameCube(new BandCount(2), new PixelWidth(2), new FrameCount(4), DataSize.SHORT_2);
        frameCube.setDefaultSpectrum(new float[]{10.0f, 20.0f});
        frameCube.setRgbBands(new RgbBands(0, 1, 2));
        FrameCube.FrameCubeRawFile frameCubeRawFile = new FrameCube.FrameCubeRawFile(frameCube);
        FrameCube frameCube2 = RawHelper.mirrorHorizontal(frameCubeRawFile);
        for (int i = 0; i < frameCube2.getLines().value; ++i) {
            for (int j = 0; j < frameCube2.getWidth().value; ++j) {
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 0, j)), (Matcher)Matchers.is((Object)Float.valueOf(10.0f)));
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 1, j)), (Matcher)Matchers.is((Object)Float.valueOf(20.0f)));
            }
        }
    }

    @Test
    public void testTransformVerticalUnEvenFrames() {
        FrameCube frameCube = new FrameCube(new BandCount(2), new PixelWidth(2), new FrameCount(5), DataSize.SHORT_2);
        frameCube.setDefaultSpectrum(new float[]{10.0f, 20.0f});
        frameCube.setRgbBands(new RgbBands(0, 1, 2));
        FrameCube.FrameCubeRawFile frameCubeRawFile = new FrameCube.FrameCubeRawFile(frameCube);
        FrameCube frameCube2 = RawHelper.mirrorHorizontal(frameCubeRawFile);
        for (int i = 0; i < frameCube2.getLines().value; ++i) {
            for (int j = 0; j < frameCube2.getWidth().value; ++j) {
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 0, j)), (Matcher)Matchers.is((Object)Float.valueOf(10.0f)));
                MatcherAssert.assertThat((Object)Float.valueOf(frameCube2.getValue(i, 1, j)), (Matcher)Matchers.is((Object)Float.valueOf(20.0f)));
            }
        }
    }

    @Test
    public void testReplaceIgnoredPixelsWithZero() throws IOException {
        for (DataSize dataSize : new DataSize[]{DataSize.BYTE_1, DataSize.SHORT_2, DataSize.FLOAT_4}) {
            FrameCube frameCube = new FrameCube(new BandCount(2), new PixelWidth(2), new FrameCount(4), dataSize);
            frameCube.setDefaultSpectrum(new float[]{10.0f, 30.0f});
            frameCube.setRgbBands(new RgbBands(0, 1, 2));
            frameCube.setSpectrum(0, 1, new float[]{10.0f, 20.0f});
            frameCube.setSpectrum(1, 0, new float[]{20.0f, 10.0f});
            File file = File.createTempFile("temp", ".raw");
            frameCube.save(file);
            RawHelper.replaceIgnoredPixelsWithZero(BreezeProgressImpl.createEmpty(), file, 20.0f, true);
            RawFileImpl rawFileImpl = new RawFileImpl(file);
            FrameListFromRaw frameListFromRaw = rawFileImpl.readFrames();
            MatcherAssert.assertThat((Object)Float.valueOf(((RawFrame)frameListFromRaw.get(0)).getFrameValue(0, 0)), (Matcher)Matchers.is((Object)Float.valueOf(10.0f)));
            MatcherAssert.assertThat((Object)Float.valueOf(((RawFrame)frameListFromRaw.get(0)).getFrameValue(1, 0)), (Matcher)Matchers.is((Object)Float.valueOf(30.0f)));
            MatcherAssert.assertThat((Object)Float.valueOf(((RawFrame)frameListFromRaw.get(0)).getFrameValue(0, 1)), (Matcher)Matchers.is((Object)Float.valueOf(0.0f)));
            MatcherAssert.assertThat((Object)Float.valueOf(((RawFrame)frameListFromRaw.get(0)).getFrameValue(1, 1)), (Matcher)Matchers.is((Object)Float.valueOf(0.0f)));
            MatcherAssert.assertThat((Object)Float.valueOf(((RawFrame)frameListFromRaw.get(1)).getFrameValue(0, 0)), (Matcher)Matchers.is((Object)Float.valueOf(0.0f)));
            MatcherAssert.assertThat((Object)Float.valueOf(((RawFrame)frameListFromRaw.get(1)).getFrameValue(1, 0)), (Matcher)Matchers.is((Object)Float.valueOf(0.0f)));
            MatcherAssert.assertThat((Object)Float.valueOf(((RawFrame)frameListFromRaw.get(1)).getFrameValue(0, 1)), (Matcher)Matchers.is((Object)Float.valueOf(10.0f)));
            MatcherAssert.assertThat((Object)Float.valueOf(((RawFrame)frameListFromRaw.get(1)).getFrameValue(1, 1)), (Matcher)Matchers.is((Object)Float.valueOf(30.0f)));
            for (int i = 2; i < frameCube.getFrameList().size(); ++i) {
                MatcherAssert.assertThat((Object)Float.valueOf(((RawFrame)frameListFromRaw.get(i)).getFrameValue(0, 0)), (Matcher)Matchers.is((Object)Float.valueOf(10.0f)));
                MatcherAssert.assertThat((Object)Float.valueOf(((RawFrame)frameListFromRaw.get(i)).getFrameValue(1, 0)), (Matcher)Matchers.is((Object)Float.valueOf(30.0f)));
                MatcherAssert.assertThat((Object)Float.valueOf(((RawFrame)frameListFromRaw.get(i)).getFrameValue(0, 1)), (Matcher)Matchers.is((Object)Float.valueOf(10.0f)));
                MatcherAssert.assertThat((Object)Float.valueOf(((RawFrame)frameListFromRaw.get(i)).getFrameValue(1, 1)), (Matcher)Matchers.is((Object)Float.valueOf(30.0f)));
            }
            RawHeader.findHeaderFileByRaw(file).delete();
            file.delete();
        }
    }
}

