/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.thread;

import java.io.IOException;
import java.net.SocketException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import se.prediktera.breeze.common.util.thread.ExceptionHandlingThread;
import se.prediktera.breeze.util.Holder;

public class ExceptionHandlingThreadTest {
    @Test
    public void shouldCallExceptionCallbackIfJobThrew() {
        Holder holder = new Holder();
        ExceptionHandlingThread exceptionHandlingThread = new ExceptionHandlingThread("test", () -> {
            throw new RuntimeException("job threw exception");
        }, runtimeException -> {
            holder.setValue(runtimeException);
            return true;
        });
        exceptionHandlingThread.start();
        exceptionHandlingThread.joinOrThrow();
        MatcherAssert.assertThat((String)"exception callback was called", (Object)((Exception)holder.getValue()), (Matcher)CoreMatchers.notNullValue(Exception.class));
    }

    @Test
    public void shouldThrowOnStopIfJobThrew() {
        ExceptionHandlingThread exceptionHandlingThread = new ExceptionHandlingThread("test", () -> {
            throw new RuntimeException("job threw exception");
        });
        try {
            exceptionHandlingThread.start();
            exceptionHandlingThread.joinOrThrow();
            Assert.fail((String)"should throw");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowOnStopIfJobThrewAndExceptionCallbackDidNotHandleException() {
        ExceptionHandlingThread exceptionHandlingThread = new ExceptionHandlingThread("test", () -> {
            throw new RuntimeException("job threw exception");
        }, runtimeException -> false);
        try {
            exceptionHandlingThread.start();
            exceptionHandlingThread.joinOrThrow();
            Assert.fail((String)"should throw");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotThrowOnStopIfJobThrewAndExceptionCallbackHandledException() {
        ExceptionHandlingThread exceptionHandlingThread = new ExceptionHandlingThread("test", () -> {
            throw new RuntimeException("job threw exception");
        }, runtimeException -> true);
        exceptionHandlingThread.start();
        exceptionHandlingThread.joinOrThrow();
    }

    @Test
    public void exceptionHandlingThreadExceptionShouldFindCauseRecursively() {
        ExceptionHandlingThread.ExceptionHandlingThreadException exceptionHandlingThreadException = new ExceptionHandlingThread.ExceptionHandlingThreadException(new RuntimeException(new ArithmeticException("lol")));
        MatcherAssert.assertThat((String)"ArithmeticException cause is found", (boolean)exceptionHandlingThreadException.hasCause(ArithmeticException.class));
        MatcherAssert.assertThat((String)"SocketException cause is not found", (!exceptionHandlingThreadException.hasCause(SocketException.class) ? 1 : 0) != 0);
    }

    @Test
    public void exceptionHandlingThreadExceptionShouldFindCauseRecursivelyWithMessageChecking() {
        ExceptionHandlingThread.ExceptionHandlingThreadException exceptionHandlingThreadException = new ExceptionHandlingThread.ExceptionHandlingThreadException(new RuntimeException(new IOException("Socket Closed")));
        MatcherAssert.assertThat((String)"IOException: 'Socket Closed' cause is found", (boolean)exceptionHandlingThreadException.hasCause(IOException.class, "Socket Closed"));
        MatcherAssert.assertThat((String)"IOException: 'sddsfaSAS' cause is not found", (!exceptionHandlingThreadException.hasCause(IOException.class, "sddsfaSAS") ? 1 : 0) != 0);
    }
}

