/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.type;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.common.util.ClasspathResourceFile;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;

public class BandNamesTest {
    @Test
    public void testCreateWavelength() {
        BandNames bandNames = new BandNames(new BandCount(10), 100.0, 200.0);
        MatcherAssert.assertThat((String)"Wavelength length should be 10", (Object)bandNames.count().value, (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((String)"Wavelength should start with 100", (Object)bandNames.get(0), (Matcher)CoreMatchers.is((Object)"100"));
        MatcherAssert.assertThat((String)"Wavelength should end with 200", (Object)bandNames.get(bandNames.count().value - 1), (Matcher)CoreMatchers.is((Object)"200"));
    }

    @Test
    public void testCreateWavelengths() {
        BandNames bandNames = BandNames.fromBandFile(new ClasspathResourceFile("wlcalswir.wls"));
        MatcherAssert.assertThat((String)"Wavelength length should be 256", (Object)bandNames.count().value, (Matcher)CoreMatchers.is((Object)256));
    }

    @Test
    public void testToString() {
        MatcherAssert.assertThat((Object)new BandNames("8a67df40", "f6e46df2_Protein %").toString(), (Matcher)CoreMatchers.is((Object)"BandNames(8a67df40, f6e46df2_Protein %)"));
    }

    @Test
    public void testToEnviHdrString() {
        MatcherAssert.assertThat((Object)new BandNames(new String[0]).toEnviHdrString(), (Matcher)CoreMatchers.is((Object)"Wavelength = {\r\n\r\n}"));
        MatcherAssert.assertThat((Object)new BandNames("abc", "efd").toEnviHdrString(), (Matcher)CoreMatchers.is((Object)"Wavelength = {\r\nabc,\r\nefd\r\n}"));
        MatcherAssert.assertThat((Object)new BandNames("8a67df40", "f6e46df2_Protein %").toEnviHdrString(), (Matcher)CoreMatchers.is((Object)"Wavelength = {\r\n8a67df40,\r\nf6e46df2_Protein %\r\n}"));
    }

    @Test
    public void testFromSemiColonSeparatedWavelengtList() {
        BandNames bandNames = BandNames.fromSemiColonSeparatedWavelengthList("10;20;30;40");
        MatcherAssert.assertThat((Object)bandNames.toString(), (Matcher)CoreMatchers.is((Object)"BandNames(10, 20, 30, 40)"));
        MatcherAssert.assertThat((Object)bandNames.get(0), (Matcher)CoreMatchers.is((Object)"10"));
        MatcherAssert.assertThat((Object)bandNames.get(3), (Matcher)CoreMatchers.is((Object)"40"));
        MatcherAssert.assertThat((Object)bandNames.get(4), (Matcher)CoreMatchers.is((Object)"Band 5"));
    }

    @Test
    public void testGetOrInterpolate() {
        BandNames bandNames = BandNames.fromSemiColonSeparatedWavelengthList("10;20;30;40");
        MatcherAssert.assertThat((Object)bandNames.getOrInterpolate(0), (Matcher)CoreMatchers.is((Object)"10"));
        MatcherAssert.assertThat((Object)bandNames.getOrInterpolate(3), (Matcher)CoreMatchers.is((Object)"40"));
        MatcherAssert.assertThat((Object)bandNames.getOrInterpolate(4), (Matcher)CoreMatchers.is((Object)"50"));
    }

    @Test
    public void testGetIndex() {
        BandNames bandNames = BandNames.fromSemiColonSeparatedWavelengthList("A1 ;B 2; C 2;D E F");
        MatcherAssert.assertThat((Object)bandNames.indexOf("A1"), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)bandNames.indexOf("B 2"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)bandNames.indexOf("C 2"), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)bandNames.indexOf("D E F"), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testWithin() {
        MatcherAssert.assertThat((Object)BandNames.fromSemiColonSeparatedWavelengthList("10;20;30;40").getWithin(5.0f, 50.0f).toWavelength(), (Matcher)CoreMatchers.is((Object)"10;20;30;40"));
        MatcherAssert.assertThat((Object)BandNames.fromSemiColonSeparatedWavelengthList("10;20;30;40").getWithin(15.0f, 34.0f).toWavelength(), (Matcher)CoreMatchers.is((Object)"10;20;30;40"));
        MatcherAssert.assertThat((Object)BandNames.fromSemiColonSeparatedWavelengthList("10;20;30;40").getWithin(20.0f, 30.0f).toWavelength(), (Matcher)CoreMatchers.is((Object)"20;30"));
        MatcherAssert.assertThat((Object)BandNames.fromSemiColonSeparatedWavelengthList("10;20;30;40").getWithin(25.0f, 30.0f).toWavelength(), (Matcher)CoreMatchers.is((Object)"20;30"));
    }

    @Test
    public void testGetClosestRange() {
        BandNames bandNames = BandNames.fromSemiColonSeparatedWavelengthList("10;20;30;40");
        MatcherAssert.assertThat((Object)bandNames.getClosestRange("20", "30").toWavelength(), (Matcher)CoreMatchers.is((Object)"20;30"));
        MatcherAssert.assertThat((Object)bandNames.getClosestRange("15", "35").toWavelength(), (Matcher)CoreMatchers.is((Object)"20;30;40"));
        MatcherAssert.assertThat((Object)bandNames.getClosestRange("10", "40").toWavelength(), (Matcher)CoreMatchers.is((Object)"10;20;30;40"));
    }

    @Test
    public void testGetFormattedRange() {
        MatcherAssert.assertThat((Object)new BandNames("A").getFormatedRange(), (Matcher)CoreMatchers.is((Object)"A - A"));
        MatcherAssert.assertThat((Object)new BandNames("A", "B", "C").getFormatedRange(), (Matcher)CoreMatchers.is((Object)"A - C"));
        MatcherAssert.assertThat((Object)new BandNames("462.78", "700.0", "945.23").getFormatedRange(), (Matcher)CoreMatchers.is((Object)"462.78 - 945.23 nm"));
        MatcherAssert.assertThat((Object)new BandNames("462.78", "500.0", "Band 288").getFormatedRange(), (Matcher)CoreMatchers.is((Object)"462.78 - Band 288"));
    }
}

